/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryRequest;

public class PutInternalCcrRepositoryAction
extends ActionType<ActionResponse.Empty> {
    public static final PutInternalCcrRepositoryAction INSTANCE = new PutInternalCcrRepositoryAction();
    public static final String NAME = "internal:admin/ccr/internal_repository/put";

    private PutInternalCcrRepositoryAction() {
        super(NAME);
    }

    public static class TransportPutInternalRepositoryAction
    extends TransportAction<PutInternalCcrRepositoryRequest, ActionResponse.Empty> {
        private final RepositoriesService repositoriesService;

        @Inject
        public TransportPutInternalRepositoryAction(RepositoriesService repositoriesService, ActionFilters actionFilters, TransportService transportService) {
            super(PutInternalCcrRepositoryAction.NAME, actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.repositoriesService = repositoriesService;
        }

        protected void doExecute(Task task, PutInternalCcrRepositoryRequest request, ActionListener<ActionResponse.Empty> listener) {
            this.repositoriesService.registerInternalRepository(request.getName(), request.getType());
            listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
        }
    }
}

