/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.Step;

public final class PhaseCacheManagement {
    private static final Logger logger = LogManager.getLogger(PhaseCacheManagement.class);

    private PhaseCacheManagement() {
    }

    public static ClusterState refreshPhaseDefinition(ClusterState state, String index, LifecyclePolicyMetadata updatedPolicy) {
        IndexMetadata idxMeta = state.metadata().index(index);
        Metadata.Builder metadataBuilder = Metadata.builder((Metadata)state.metadata());
        PhaseCacheManagement.refreshPhaseDefinition(metadataBuilder, idxMeta, updatedPolicy);
        return ClusterState.builder((ClusterState)state).metadata(metadataBuilder.build()).build();
    }

    public static void refreshPhaseDefinition(Metadata.Builder metadataBuilder, IndexMetadata idxMeta, LifecyclePolicyMetadata updatedPolicy) {
        String index = idxMeta.getIndex().getName();
        assert (PhaseCacheManagement.eligibleToCheckForRefresh(idxMeta)) : "index " + index + " is missing crucial information needed to refresh phase definition";
        logger.trace("[{}] updating cached phase definition for policy [{}]", (Object)index, (Object)updatedPolicy.getName());
        LifecycleExecutionState currentExState = idxMeta.getLifecycleExecutionState();
        String currentPhase = currentExState.phase();
        PhaseExecutionInfo pei = new PhaseExecutionInfo(updatedPolicy.getName(), updatedPolicy.getPolicy().getPhases().get(currentPhase), updatedPolicy.getVersion(), updatedPolicy.getModifiedDate());
        LifecycleExecutionState newExState = LifecycleExecutionState.builder((LifecycleExecutionState)currentExState).setPhaseDefinition(org.elasticsearch.common.Strings.toString((ToXContent)pei, (boolean)false, (boolean)false)).build();
        metadataBuilder.put(IndexMetadata.builder((IndexMetadata)idxMeta).putCustom("ilm", newExState.asMap()));
    }

    public static boolean eligibleToCheckForRefresh(IndexMetadata metadata) {
        LifecycleExecutionState executionState = metadata.getLifecycleExecutionState();
        if (executionState == null || executionState.phaseDefinition() == null) {
            return false;
        }
        Step.StepKey currentStepKey = Step.getCurrentStepKey(executionState);
        if (currentStepKey == null || currentStepKey.phase() == null) {
            return false;
        }
        return !"ERROR".equals(currentStepKey.name());
    }

    public static ClusterState updateIndicesForPolicy(ClusterState state, NamedXContentRegistry xContentRegistry, Client client, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicy, XPackLicenseState licenseState) {
        Metadata.Builder mb = Metadata.builder((Metadata)state.metadata());
        if (PhaseCacheManagement.updateIndicesForPolicy(mb, state, xContentRegistry, client, oldPolicy, newPolicy, licenseState)) {
            return ClusterState.builder((ClusterState)state).metadata(mb).build();
        }
        return state;
    }

    public static boolean updateIndicesForPolicy(Metadata.Builder mb, ClusterState currentState, NamedXContentRegistry xContentRegistry, Client client, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicy, XPackLicenseState licenseState) {
        assert (oldPolicy.getName().equals(newPolicy.getName())) : "expected both policies to have the same id but they were: [" + oldPolicy.getName() + "] vs. [" + newPolicy.getName() + "]";
        if (oldPolicy.equals(newPolicy.getPolicy())) {
            logger.debug("policy [{}] is unchanged and no phase definition refresh is needed", (Object)oldPolicy.getName());
            return false;
        }
        List<IndexMetadata> indicesThatCanBeUpdated = currentState.metadata().indices().values().stream().filter(meta -> newPolicy.getName().equals(meta.getLifecyclePolicyName())).filter(meta -> PhaseCacheManagement.isIndexPhaseDefinitionUpdatable(xContentRegistry, client, meta, newPolicy.getPolicy(), licenseState)).toList();
        ArrayList<String> refreshedIndices = new ArrayList<String>(indicesThatCanBeUpdated.size());
        for (IndexMetadata index : indicesThatCanBeUpdated) {
            try {
                PhaseCacheManagement.refreshPhaseDefinition(mb, index, newPolicy);
                refreshedIndices.add(index.getIndex().getName());
            }
            catch (Exception e) {
                logger.warn(() -> Strings.format((String)"[%s] unable to refresh phase definition for updated policy [%s]", (Object[])new Object[]{index, newPolicy.getName()}), (Throwable)e);
            }
        }
        logger.debug("refreshed policy [{}] phase definition for [{}] indices", (Object)newPolicy.getName(), (Object)refreshedIndices.size());
        return refreshedIndices.size() > 0;
    }

    public static boolean isIndexPhaseDefinitionUpdatable(NamedXContentRegistry xContentRegistry, Client client, IndexMetadata metadata, LifecyclePolicy newPolicy, XPackLicenseState licenseState) {
        String index = metadata.getIndex().getName();
        if (!PhaseCacheManagement.eligibleToCheckForRefresh(metadata)) {
            logger.debug("[{}] does not contain enough information to check for eligibility of refreshing phase", (Object)index);
            return false;
        }
        String policyId = newPolicy.getName();
        LifecycleExecutionState executionState = metadata.getLifecycleExecutionState();
        Step.StepKey currentStepKey = Step.getCurrentStepKey(executionState);
        String currentPhase = currentStepKey.phase();
        Set newStepKeys = newPolicy.toSteps(client, licenseState).stream().map(Step::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!newStepKeys.contains(currentStepKey)) {
            logger.debug("[{}] updated policy [{}] does not contain the current step key [{}], so the policy phase will not be refreshed", (Object)index, (Object)policyId, (Object)currentStepKey);
            return false;
        }
        String phaseDef = executionState.phaseDefinition();
        Set<Step.StepKey> oldStepKeys = PhaseCacheManagement.readStepKeys(xContentRegistry, client, phaseDef, currentPhase, licenseState);
        if (oldStepKeys == null) {
            logger.debug("[{}] unable to parse phase definition for cached policy [{}], policy phase will not be refreshed", (Object)index, (Object)policyId);
            return false;
        }
        Set oldPhaseStepKeys = oldStepKeys.stream().filter(sk -> currentPhase.equals(sk.phase())).collect(Collectors.toCollection(LinkedHashSet::new));
        PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(policyId, newPolicy.getPhases().get(currentPhase), 1L, 1L);
        String peiJson = org.elasticsearch.common.Strings.toString((ToXContent)phaseExecutionInfo);
        Set<Step.StepKey> newPhaseStepKeys = PhaseCacheManagement.readStepKeys(xContentRegistry, client, peiJson, currentPhase, licenseState);
        if (newPhaseStepKeys == null) {
            logger.debug(() -> Strings.format((String)"[%s] unable to parse phase definition for policy [%s] to determine if it could be refreshed", (Object[])new Object[]{index, policyId}));
            return false;
        }
        if (newPhaseStepKeys.equals(oldPhaseStepKeys)) {
            logger.debug("[{}] updated policy [{}] contains the same phase step keys and can be refreshed", (Object)index, (Object)policyId);
            return true;
        }
        logger.debug("[{}] updated policy [{}] has different phase step keys and will NOT refresh phase definition as it differs too greatly. old: {}, new: {}", (Object)index, (Object)policyId, (Object)oldPhaseStepKeys, newPhaseStepKeys);
        return false;
    }

    @Nullable
    static Set<Step.StepKey> readStepKeys(NamedXContentRegistry xContentRegistry, Client client, String phaseDef, String currentPhase, XPackLicenseState licenseState) {
        PhaseExecutionInfo phaseExecutionInfo;
        if (phaseDef == null) {
            return null;
        }
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry), phaseDef);){
            phaseExecutionInfo = PhaseExecutionInfo.parse(parser, currentPhase);
        }
        catch (Exception e) {
            logger.trace(() -> Strings.format((String)"exception reading step keys checking for refreshability, phase definition: %s", (Object[])new Object[]{phaseDef}), (Throwable)e);
            return null;
        }
        if (phaseExecutionInfo == null || phaseExecutionInfo.getPhase() == null) {
            return null;
        }
        return phaseExecutionInfo.getPhase().getActions().values().stream().flatMap(a -> a.toSteps(client, phaseExecutionInfo.getPhase().getName(), null, licenseState).stream()).map(Step::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

