/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import org.elasticsearch.xpack.core.transform.TransformConfigVersion;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;

public final class TransformEffectiveSettings {
    private TransformEffectiveSettings() {
    }

    public static boolean writeDatesAsEpochMillis(SettingsConfig settings, TransformConfigVersion version) {
        return settings.getDatesAsEpochMillis() != null ? settings.getDatesAsEpochMillis().booleanValue() : version.before(TransformConfigVersion.V_7_11_0);
    }

    public static boolean isAlignCheckpointsDisabled(SettingsConfig settings) {
        return Boolean.FALSE.equals(settings.getAlignCheckpoints());
    }

    public static boolean isPitDisabled(SettingsConfig settings) {
        return Boolean.FALSE.equals(settings.getUsePit());
    }

    public static boolean isDeduceMappingsDisabled(SettingsConfig settings) {
        return Boolean.FALSE.equals(settings.getDeduceMappings());
    }

    public static int getNumFailureRetries(SettingsConfig settings, int defaultNumFailureRetries) {
        return TransformEffectiveSettings.isUnattended(settings) ? -1 : (settings.getNumFailureRetries() != null ? settings.getNumFailureRetries() : defaultNumFailureRetries);
    }

    public static boolean isUnattended(SettingsConfig settings) {
        return Boolean.TRUE.equals(settings.getUnattended());
    }
}

