/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDegreesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromUnsignedLongEvaluator;

public class ToDegrees
extends AbstractConvertFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToDegrees", ToDegrees::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.DOUBLE, ToDegreesEvaluator.Factory::new), Map.entry(DataType.INTEGER, (field, source) -> new ToDegreesEvaluator.Factory(new ToDoubleFromIntEvaluator.Factory(field, source), source)), Map.entry(DataType.LONG, (field, source) -> new ToDegreesEvaluator.Factory(new ToDoubleFromLongEvaluator.Factory(field, source), source)), Map.entry(DataType.UNSIGNED_LONG, (field, source) -> new ToDegreesEvaluator.Factory(new ToDoubleFromUnsignedLongEvaluator.Factory(field, source), source)));

    @FunctionInfo(returnType={"double"}, description="Converts a number in {wikipedia}/Radian[radians] to {wikipedia}/Degree_(angle)[degrees].", examples={@Example(file="floats", tag="to_degrees")})
    public ToDegrees(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToDegrees(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToDegrees.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDegrees(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDegrees::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    static double process(double deg) {
        return NumericUtils.asFiniteNumber((double)Math.toDegrees(deg));
    }
}

