/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChangeCase;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;

public class ReplaceStringCasingWithInsensitiveEquals
extends OptimizerRules.OptimizerExpressionRule<ScalarFunction> {
    public ReplaceStringCasingWithInsensitiveEquals() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected Expression rule(ScalarFunction sf, LogicalOptimizerContext ctx) {
        Not not;
        Expression expression;
        ScalarFunction e = sf;
        if (sf instanceof BinaryComparison) {
            BinaryComparison bc = (BinaryComparison)sf;
            e = ReplaceStringCasingWithInsensitiveEquals.rewriteBinaryComparison(ctx, sf, bc, false);
        } else if (sf instanceof Not && (expression = (not = (Not)sf).field()) instanceof BinaryComparison) {
            BinaryComparison bc = (BinaryComparison)expression;
            e = ReplaceStringCasingWithInsensitiveEquals.rewriteBinaryComparison(ctx, sf, bc, true);
        }
        return e;
    }

    private static Expression rewriteBinaryComparison(LogicalOptimizerContext ctx, ScalarFunction sf, BinaryComparison bc, boolean negated) {
        ScalarFunction e = sf;
        Expression expression = bc.left();
        if (expression instanceof ChangeCase) {
            ChangeCase changeCase = (ChangeCase)expression;
            if (bc.right().foldable()) {
                if (bc instanceof Equals) {
                    e = ReplaceStringCasingWithInsensitiveEquals.replaceChangeCase(ctx, bc, changeCase, negated);
                } else if (bc instanceof NotEquals) {
                    e = ReplaceStringCasingWithInsensitiveEquals.replaceChangeCase(ctx, bc, changeCase, !negated);
                }
            }
        }
        return e;
    }

    private static Expression replaceChangeCase(LogicalOptimizerContext ctx, BinaryComparison bc, ChangeCase changeCase, boolean negated) {
        TranslationAware e;
        String foldedRight = BytesRefs.toString((Object)bc.right().fold(ctx.foldCtx()));
        Expression field = ReplaceStringCasingWithInsensitiveEquals.unwrapCase(changeCase.field());
        InsensitiveEquals insensitiveEquals = e = changeCase.caseType().matchesCase(foldedRight) ? new InsensitiveEquals(bc.source(), field, bc.right()) : Literal.of((Expression)bc, (Object)Boolean.FALSE);
        if (negated) {
            e = e instanceof Literal ? new IsNotNull(e.source(), field) : new Not(e.source(), (Expression)e);
        }
        return e;
    }

    private static Expression unwrapCase(Expression e) {
        while (e instanceof ChangeCase) {
            ChangeCase cc = (ChangeCase)e;
            e = cc.field();
        }
        return e;
    }
}

