/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.TemplateParamValidator;

public class SearchApplicationTemplate
implements ToXContentObject,
Writeable {
    private static final ParseField TEMPLATE_SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField DICTIONARY_FIELD = new ParseField("dictionary", new String[0]);
    public static final SearchApplicationTemplate DEFAULT_TEMPLATE = new SearchApplicationTemplate(new Script(ScriptType.INLINE, "mustache", "{\n  \"query\": {\n    \"query_string\": {\n        \"query\": \"{{query_string}}\",\n        \"default_field\": \"{{default_field}}\"\n        }\n    }\n}\n", Map.of("query_string", "*", "default_field", "*")), null);
    private final Script script;
    private final TemplateParamValidator templateParamValidator;
    private static final ConstructingObjectParser<SearchApplicationTemplate, Void> PARSER = new ConstructingObjectParser("search_template", p -> new SearchApplicationTemplate((Script)p[0], (TemplateParamValidator)p[1]));

    public SearchApplicationTemplate(StreamInput in) throws IOException {
        this.script = (Script)in.readOptionalWriteable(Script::new);
        this.templateParamValidator = (TemplateParamValidator)in.readOptionalWriteable(TemplateParamValidator::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.script != null) {
            builder.field(TEMPLATE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
        }
        if (this.templateParamValidator != null) {
            builder.field(DICTIONARY_FIELD.getPreferredName(), (ToXContent)this.templateParamValidator);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.script);
        out.writeOptionalWriteable((Writeable)this.templateParamValidator);
    }

    public static SearchApplicationTemplate parse(XContentParser parser) {
        return (SearchApplicationTemplate)PARSER.apply(parser, null);
    }

    public SearchApplicationTemplate(Script script, @Nullable TemplateParamValidator templateParamValidator) {
        if (script != null && script.getLang() != null && !"mustache".equals(script.getLang())) {
            throw new IllegalArgumentException("only [mustache] scripting language is supported");
        }
        if (script != null && script.getType().getId() != ScriptType.INLINE.getId()) {
            throw new IllegalArgumentException("only [" + ScriptType.INLINE.getName() + "] script type is supported");
        }
        this.script = script;
        this.templateParamValidator = templateParamValidator;
    }

    public int hashCode() {
        return Objects.hash(this.script, this.templateParamValidator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchApplicationTemplate template = (SearchApplicationTemplate)o;
        if (this.script == null) {
            return template.script == null;
        }
        return this.script.equals((Object)template.script) && Objects.equals(this.templateParamValidator, template.templateParamValidator);
    }

    public void validateTemplateParams(Map<String, Object> templateParams) throws ValidationException {
        if (this.templateParamValidator != null) {
            this.templateParamValidator.validate(templateParams);
        }
    }

    public Script script() {
        return this.script;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Script.parse((XContentParser)p, (String)"mustache"), SearchApplication.TEMPLATE_SCRIPT_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                TemplateParamValidator templateParamValidator = new TemplateParamValidator(builder.copyCurrentStructure(p));
                return templateParamValidator;
            }
        }, DICTIONARY_FIELD);
    }
}

