/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.PureQuadraticFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public final class QuadraticFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Quadratic<N> {
    private final LinearFunction<N> myLinear;
    private final PureQuadraticFunction<N> myPureQuadratic;

    public static QuadraticFunction<ComplexNumber> makeComplex(Access2D<?> quadratic, Access1D<?> linear) {
        return new QuadraticFunction<ComplexNumber>((MatrixStore)GenericStore.COMPLEX.copy(quadratic), (MatrixStore)GenericStore.COMPLEX.columns(linear));
    }

    public static QuadraticFunction<ComplexNumber> makeComplex(int arity) {
        return new QuadraticFunction<ComplexNumber>((MatrixStore)GenericStore.COMPLEX.make(arity, arity), (MatrixStore)GenericStore.COMPLEX.make(arity, 1));
    }

    public static QuadraticFunction<Double> makePrimitive(Access2D<?> quadratic, Access1D<?> linear) {
        return new QuadraticFunction<Double>((MatrixStore)Primitive64Store.FACTORY.copy(quadratic), (MatrixStore)Primitive64Store.FACTORY.columns(linear));
    }

    public static QuadraticFunction<Double> makePrimitive(int arity) {
        return new QuadraticFunction<Double>((MatrixStore)Primitive64Store.FACTORY.make(arity, arity), (MatrixStore)Primitive64Store.FACTORY.make(arity, 1));
    }

    public static QuadraticFunction<RationalNumber> makeRational(Access2D<?> quadratic, Access1D<?> linear) {
        return new QuadraticFunction<RationalNumber>((MatrixStore)GenericStore.RATIONAL.copy(quadratic), (MatrixStore)GenericStore.RATIONAL.columns(linear));
    }

    public static QuadraticFunction<RationalNumber> makeRational(int arity) {
        return new QuadraticFunction<RationalNumber>((MatrixStore)GenericStore.RATIONAL.make(arity, arity), (MatrixStore)GenericStore.RATIONAL.make(arity, 1));
    }

    public static <N extends Comparable<N>> QuadraticFunction<N> wrap(PhysicalStore<N> quadratic, PhysicalStore<N> linear) {
        return new QuadraticFunction<N>(quadratic, linear);
    }

    QuadraticFunction(MatrixStore<N> quadratic, MatrixStore<N> linear) {
        this.myPureQuadratic = new PureQuadraticFunction<N>(quadratic);
        this.myLinear = new LinearFunction<N>(linear);
        if (this.myPureQuadratic.arity() != this.myLinear.arity()) {
            throw new IllegalArgumentException("Must have the same arity!");
        }
    }

    @Override
    public int arity() {
        return this.myLinear.arity();
    }

    @Override
    public N getConstant() {
        return this.myPureQuadratic.getConstant();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        MatrixStore<MatrixStore<N>> pureQuadraticPart = this.myPureQuadratic.getGradient(point);
        MatrixStore<N> linearPart = this.myLinear.getGradient(point);
        return pureQuadraticPart.add(linearPart);
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myPureQuadratic.getHessian(point);
    }

    @Override
    public MatrixStore<N> getLinearFactors() {
        return this.myLinear.getLinearFactors();
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return (N)((Comparable)this.getScalarValue(arg).get());
    }

    @Override
    public PhysicalStore<N> linear() {
        return this.myLinear.linear();
    }

    @Override
    public PhysicalStore<N> quadratic() {
        return this.myPureQuadratic.quadratic();
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myPureQuadratic.setConstant(constant);
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myLinear.factory();
    }

    Scalar<N> getScalarValue(Access1D<N> arg) {
        Scalar<N> retVal = this.myPureQuadratic.getScalarValue(arg);
        N linearPart = this.myLinear.invoke(arg);
        return (Scalar)retVal.add(linearPart);
    }
}

