/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.BigIntegers;

class JcaJcePGPUtil {
    static final ASN1ObjectIdentifier cryptlib = new ASN1ObjectIdentifier("1.3.6.1.4.1.3029");
    static final ASN1ObjectIdentifier ecc = cryptlib.branch("1").branch("5");
    static final ASN1ObjectIdentifier curvey25519 = ecc.branch("1");
    static final ASN1ObjectIdentifier ellipticCurve = new ASN1ObjectIdentifier("1.3.6.1.4.1.11591.15");
    static final ASN1ObjectIdentifier Ed25519 = ellipticCurve.branch("1");

    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string = PGPUtil.getSymmetricCipherName(n);
        if (string == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string);
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        NamedECDomainParameters namedECDomainParameters = ECDomainParametersIndex.lookupDomainParameters((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (namedECDomainParameters == null) {
            return ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        return new X9ECParameters(namedECDomainParameters.getCurve(), new X9ECPoint(namedECDomainParameters.getG()), namedECDomainParameters.getN(), namedECDomainParameters.getH(), namedECDomainParameters.getSeed());
    }
}

