/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanArrayVector;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanLookup;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.ToMask;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class BooleanArrayBlock
extends AbstractArrayBlock
implements BooleanBlock {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BooleanArrayBlock.class);
    private final BooleanArrayVector vector;

    BooleanArrayBlock(boolean[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        this(new BooleanArrayVector(values, firstValueIndexes == null ? positionCount : firstValueIndexes[positionCount], blockFactory), positionCount, firstValueIndexes, nulls, mvOrdering);
    }

    private BooleanArrayBlock(BooleanArrayVector vector, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering);
        this.vector = vector;
        assert (firstValueIndexes != null ? firstValueIndexes[this.getPositionCount()] == vector.getPositionCount() : vector.getPositionCount() == this.getPositionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BooleanArrayBlock readArrayBlock(BlockFactory blockFactory, BlockStreamInput in) throws IOException {
        AbstractArrayBlock.SubFields sub = new AbstractArrayBlock.SubFields(blockFactory, (StreamInput)in);
        BooleanArrayVector vector = null;
        boolean success = false;
        try {
            vector = BooleanArrayVector.readArrayVector(sub.vectorPositions(), (StreamInput)in, blockFactory);
            BooleanArrayBlock block = new BooleanArrayBlock(vector, sub.positionCount, sub.firstValueIndexes, sub.nullsMask, sub.mvOrdering);
            blockFactory.adjustBreaker(block.ramBytesUsed() - vector.ramBytesUsed() - sub.bytesReserved);
            success = true;
            BooleanArrayBlock booleanArrayBlock = block;
            return booleanArrayBlock;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)vector);
                blockFactory.adjustBreaker(-sub.bytesReserved);
            }
        }
    }

    void writeArrayBlock(StreamOutput out) throws IOException {
        this.writeSubFields(out);
        this.vector.writeArrayVector(this.vector.getPositionCount(), out);
    }

    @Override
    public BooleanVector asVector() {
        return null;
    }

    @Override
    public ToMask toMask() {
        if (this.getPositionCount() == 0) {
            return new ToMask(this.blockFactory().newConstantBooleanVector(false, 0), false);
        }
        try (BooleanVector.FixedBuilder builder = this.blockFactory().newBooleanVectorFixedBuilder(this.getPositionCount());){
            boolean hasMv = false;
            for (int p = 0; p < this.getPositionCount(); ++p) {
                builder.appendBoolean(switch (this.getValueCount(p)) {
                    case 0 -> false;
                    case 1 -> this.getBoolean(this.getFirstValueIndex(p));
                    default -> {
                        hasMv = true;
                        yield false;
                    }
                });
            }
            ToMask toMask = new ToMask(builder.build(), hasMv);
            return toMask;
        }
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        return this.vector.getBoolean(valueIndex);
    }

    @Override
    public BooleanBlock filter(int ... positions) {
        try (BooleanBlock.Builder builder = this.blockFactory().newBooleanBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendBoolean(this.getBoolean(first));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendBoolean(this.getBoolean(first + c));
                }
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.mvOrdering(this.mvOrdering()).build();
            return booleanBlock;
        }
    }

    @Override
    public BooleanBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return this;
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return this;
            }
            return (BooleanBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (BooleanBlock.Builder builder = this.blockFactory().newBooleanBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (!mask.getBoolean(p)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int start = this.getFirstValueIndex(p);
                if (valueCount == 1) {
                    builder.appendBoolean(this.getBoolean(start));
                    continue;
                }
                int end = start + valueCount;
                builder.beginPositionEntry();
                for (int i = start; i < end; ++i) {
                    builder.appendBoolean(this.getBoolean(i));
                }
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    public ReleasableIterator<BooleanBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new BooleanLookup(this, positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public BooleanBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        if (this.nullsMask == null) {
            this.vector.incRef();
            return this.vector.asBlock();
        }
        int expandedPositionCount = this.vector.getPositionCount();
        long bitSetRamUsedEstimate = Math.max((long)this.nullsMask.size(), BlockRamUsageEstimator.sizeOfBitSet(expandedPositionCount));
        this.blockFactory().adjustBreaker(bitSetRamUsedEstimate);
        BooleanArrayBlock expanded = new BooleanArrayBlock(this.vector, expandedPositionCount, null, this.shiftNullsToExpandedPositions(), Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        this.blockFactory().adjustBreaker(expanded.ramBytesUsedOnlyBlock() - bitSetRamUsedEstimate);
        this.vector.incRef();
        return expanded;
    }

    private long ramBytesUsedOnlyBlock() {
        return BASE_RAM_BYTES_USED + BlockRamUsageEstimator.sizeOf(this.firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(this.nullsMask);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedOnlyBlock() + this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanBlock) {
            BooleanBlock that = (BooleanBlock)obj;
            return BooleanBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + String.valueOf((Object)this.mvOrdering()) + ", vector=" + String.valueOf(this.vector) + "]";
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsedOnlyBlock());
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

