/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpClientManager;
import org.elasticsearch.xpack.inference.external.http.RequestExecutor;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.retry.RetryingHttpSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorService;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorServiceSettings;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.TimedListener;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public class HttpRequestSender
implements Sender {
    private static final TimeValue START_COMPLETED_WAIT_TIME = TimeValue.timeValueSeconds((long)5L);
    private final ThreadPool threadPool;
    private final HttpClientManager manager;
    private final RequestExecutor service;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final CountDownLatch startCompleted = new CountDownLatch(1);
    private final RequestSender requestSender;

    private HttpRequestSender(ThreadPool threadPool, HttpClientManager httpClientManager, ClusterService clusterService, Settings settings, RequestSender requestSender) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.manager = Objects.requireNonNull(httpClientManager);
        this.requestSender = Objects.requireNonNull(requestSender);
        this.service = new RequestExecutorService(threadPool, this.startCompleted, new RequestExecutorServiceSettings(settings, clusterService), requestSender);
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.manager.start();
            this.threadPool.executor("inference_utility").execute(this.service::start);
            this.waitForStartToComplete();
        }
    }

    @Override
    public void updateRateLimitDivisor(int rateLimitDivisor) {
        this.service.updateRateLimitDivisor(rateLimitDivisor);
    }

    private void waitForStartToComplete() {
        try {
            if (!this.startCompleted.await(START_COMPLETED_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)) {
                throw new IllegalStateException("Http sender startup did not complete in time");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Http sender interrupted while waiting for startup to complete");
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.close();
        this.service.shutdown();
    }

    @Override
    public void send(RequestManager requestCreator, InferenceInputs inferenceInputs, @Nullable TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        assert (this.started.get()) : "call start() before sending a request";
        this.waitForStartToComplete();
        this.service.execute(requestCreator, inferenceInputs, timeout, listener);
    }

    @Override
    public void sendWithoutQueuing(Logger logger, Request request, ResponseHandler responseHandler, @Nullable TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        assert (this.started.get()) : "call start() before sending a request";
        this.waitForStartToComplete();
        ContextPreservingActionListener preservedListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadPool.getThreadContext());
        TimedListener timedListener = new TimedListener(timeout, preservedListener, this.threadPool);
        this.threadPool.executor("inference_utility").execute(() -> this.requestSender.send(logger, request, timedListener::hasCompleted, responseHandler, timedListener.getListener()));
    }

    public static class Factory {
        private final ServiceComponents serviceComponents;
        private final HttpClientManager httpClientManager;
        private final ClusterService clusterService;
        private final RequestSender requestSender;

        public Factory(ServiceComponents serviceComponents, HttpClientManager httpClientManager, ClusterService clusterService) {
            this.serviceComponents = Objects.requireNonNull(serviceComponents);
            this.httpClientManager = Objects.requireNonNull(httpClientManager);
            this.clusterService = Objects.requireNonNull(clusterService);
            this.requestSender = new RetryingHttpSender(this.httpClientManager.getHttpClient(), serviceComponents.throttlerManager(), new RetrySettings(serviceComponents.settings(), clusterService), serviceComponents.threadPool());
        }

        public Sender createSender() {
            return new HttpRequestSender(this.serviceComponents.threadPool(), this.httpClientManager, this.clusterService, this.serviceComponents.settings(), this.requestSender);
        }
    }
}

