/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.ResettableValue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DataStreamFailureStore(Boolean enabled) implements SimpleDiffable<DataStreamFailureStore>,
ToXContentObject
{
    public static final String FAILURE_STORE = "failure_store";
    public static final String ENABLED = "enabled";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ConstructingObjectParser<DataStreamFailureStore, Void> PARSER = new ConstructingObjectParser("failure_store", false, (args, unused) -> new DataStreamFailureStore((Boolean)args[0]));

    public DataStreamFailureStore {
        if (enabled == null) {
            throw new IllegalArgumentException("Failure store configuration should have at least one non-null configuration value.");
        }
    }

    public DataStreamFailureStore(StreamInput in) throws IOException {
        this(in.readOptionalBoolean());
    }

    public static Diff<DataStreamFailureStore> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamFailureStore::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.enabled);
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.enabled != null) {
            builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        }
        builder.endObject();
        return builder;
    }

    public static DataStreamFailureStore fromXContent(XContentParser parser) throws IOException {
        return (DataStreamFailureStore)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
    }

    public record Template(ResettableValue<Boolean> enabled) implements Writeable,
    ToXContentObject
    {
        public static final ConstructingObjectParser<Template, Void> PARSER = new ConstructingObjectParser("failure_store_template", false, (args, unused) -> new Template(args[0] == null ? ResettableValue.undefined() : (ResettableValue)args[0]));

        public Template {
            if (enabled.get() == null) {
                throw new IllegalArgumentException("Failure store configuration should have at least one non-null configuration value.");
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            ResettableValue.write(out, this.enabled, StreamOutput::writeBoolean);
        }

        public static Template read(StreamInput in) throws IOException {
            ResettableValue<Boolean> enabled = ResettableValue.read(in, StreamInput::readBoolean);
            return new Template(enabled);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.enabled.toXContent(builder, params, ENABLED_FIELD.getPreferredName());
            builder.endObject();
            return builder;
        }

        public static Template fromXContent(XContentParser parser) throws IOException {
            return (Template)PARSER.parse(parser, null);
        }

        public static Template merge(Template ignored, Template update) {
            return update;
        }

        public DataStreamFailureStore toFailureStore() {
            return new DataStreamFailureStore(this.enabled.get());
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this, true, true);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? ResettableValue.reset() : ResettableValue.create(p.booleanValue()), ENABLED_FIELD, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        }
    }
}

