/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.index.mapper.Uid;

final class IdStoredFieldLoader {
    private final CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> reader;
    private final IdOnlyFieldVisitor visitor = new IdOnlyFieldVisitor();

    IdStoredFieldLoader(LeafReader in) {
        this.reader = IdStoredFieldLoader.getStoredFieldsReader(in);
    }

    private static CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> getStoredFieldsReader(LeafReader in) {
        if (in instanceof SequentialStoredFieldsLeafReader) {
            return (arg_0, arg_1) -> ((StoredFieldsReader)((SequentialStoredFieldsLeafReader)in).getSequentialStoredFieldsReader()).document(arg_0, arg_1);
        }
        throw new IllegalArgumentException("Requires a SequentialStoredFieldsReader, got " + String.valueOf(in.getClass()));
    }

    String id(int doc) throws IOException {
        this.visitor.reset();
        this.reader.accept(doc, this.visitor);
        return this.visitor.id;
    }

    private static class IdOnlyFieldVisitor
    extends StoredFieldVisitor {
        private String id = null;
        private boolean visited = false;

        private IdOnlyFieldVisitor() {
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
            if (this.visited) {
                return StoredFieldVisitor.Status.STOP;
            }
            if ("_id".equals(fieldInfo.name)) {
                this.visited = true;
                return StoredFieldVisitor.Status.YES;
            }
            return StoredFieldVisitor.Status.NO;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) {
            assert ("_id".equals(fieldInfo.name)) : fieldInfo;
            this.id = Uid.decodeId(value);
        }

        void reset() {
            this.id = null;
            this.visited = false;
        }
    }
}

