/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.LeafDoubleFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class SortedDoublesIndexFieldData
extends IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;
    protected final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;
    protected final boolean indexed;

    public SortedDoublesIndexFieldData(String fieldName, IndexNumericFieldData.NumericType numericType, ValuesSourceType valuesSourceType, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory, boolean indexed) {
        this.fieldName = fieldName;
        this.numericType = Objects.requireNonNull(numericType);
        assert (this.numericType.isFloatingPoint());
        this.valuesSourceType = valuesSourceType;
        this.toScriptFieldFactory = toScriptFieldFactory;
        this.indexed = indexed;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return this.numericType == IndexNumericFieldData.NumericType.HALF_FLOAT;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public LeafNumericFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    @Override
    public LeafNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        return switch (this.numericType) {
            case IndexNumericFieldData.NumericType.HALF_FLOAT -> new SortedNumericHalfFloatFieldData(reader, field, this.toScriptFieldFactory);
            case IndexNumericFieldData.NumericType.FLOAT -> new SortedNumericFloatFieldData(reader, field, this.toScriptFieldFactory);
            default -> new SortedNumericDoubleFieldData(reader, field, this.toScriptFieldFactory);
        };
    }

    static final class SortedNumericHalfFloatFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;
        private final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        SortedNumericHalfFloatFieldData(LeafReader reader, String field, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.reader = reader;
            this.field = field;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                NumericDocValues single = DocValues.unwrapSingleton((SortedNumericDocValues)raw);
                if (single != null) {
                    return FieldData.singleton(new SingleHalfFloatValues(single));
                }
                return new MultiHalfFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getDoubleValues(), name);
        }
    }

    static final class SortedNumericFloatFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;
        private final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        SortedNumericFloatFieldData(LeafReader reader, String field, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.reader = reader;
            this.field = field;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                NumericDocValues single = DocValues.unwrapSingleton((SortedNumericDocValues)raw);
                if (single != null) {
                    return FieldData.singleton(new SingleFloatValues(single));
                }
                return new MultiFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getDoubleValues(), name);
        }
    }

    static final class SortedNumericDoubleFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;
        protected final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        SortedNumericDoubleFieldData(LeafReader reader, String field, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.reader = reader;
            this.field = field;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                return FieldData.sortableLongBitsToDoubles(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getDoubleValues(), name);
        }
    }

    static final class MultiFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)((int)this.in.nextValue()));
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleFloatValues(NumericDocValues in) {
            this.in = in;
        }

        public double doubleValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)((int)this.in.longValue()));
        }

        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    static final class MultiHalfFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiHalfFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.nextValue()));
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleHalfFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleHalfFloatValues(NumericDocValues in) {
            this.in = in;
        }

        public double doubleValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.longValue()));
        }

        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final ValuesSourceType valuesSourceType;
        protected final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;
        private final boolean indexed;

        public Builder(String name, IndexNumericFieldData.NumericType numericType, ValuesSourceType valuesSourceType, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory, boolean indexed) {
            this.name = name;
            this.numericType = numericType;
            this.valuesSourceType = valuesSourceType;
            this.toScriptFieldFactory = toScriptFieldFactory;
            this.indexed = indexed;
        }

        public SortedDoublesIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SortedDoublesIndexFieldData(this.name, this.numericType, this.valuesSourceType, this.toScriptFieldFactory, this.indexed);
        }
    }
}

