/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.internal.rewriter;

import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;

public interface QueryRewriteInterceptor {
    public QueryBuilder interceptAndRewrite(QueryRewriteContext var1, QueryBuilder var2);

    public String getQueryName();

    public static QueryRewriteInterceptor multi(Map<String, QueryRewriteInterceptor> interceptors) {
        return interceptors.isEmpty() ? new NoOpQueryRewriteInterceptor() : new CompositeQueryRewriteInterceptor(interceptors);
    }

    public static class NoOpQueryRewriteInterceptor
    implements QueryRewriteInterceptor {
        @Override
        public QueryBuilder interceptAndRewrite(QueryRewriteContext context, QueryBuilder queryBuilder) {
            return queryBuilder;
        }

        @Override
        public String getQueryName() {
            return null;
        }
    }

    public static class CompositeQueryRewriteInterceptor
    implements QueryRewriteInterceptor {
        final String NAME = "composite";
        private final Map<String, QueryRewriteInterceptor> interceptors;

        private CompositeQueryRewriteInterceptor(Map<String, QueryRewriteInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        @Override
        public String getQueryName() {
            return "composite";
        }

        @Override
        public QueryBuilder interceptAndRewrite(QueryRewriteContext context, QueryBuilder queryBuilder) {
            QueryRewriteInterceptor interceptor = this.interceptors.get(queryBuilder.getName());
            if (interceptor != null) {
                return interceptor.interceptAndRewrite(context, queryBuilder);
            }
            return queryBuilder;
        }
    }
}

