/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.search.aggregations.support.AggregationInfo;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class AggregationUsageService
implements ReportingService<AggregationInfo> {
    private static final String ES_SEARCH_QUERY_AGGREGATIONS_TOTAL_COUNT = "es.search.query.aggregations.total";
    private final LongCounter aggregationsUsageCounter;
    private final Map<String, Map<String, LongAdder>> aggs;
    private final AggregationInfo info;
    public static final String OTHER_SUBTYPE = "other";

    private AggregationUsageService(Builder builder) {
        this.aggs = builder.aggs;
        this.info = new AggregationInfo(this.aggs);
        this.aggregationsUsageCounter = builder.meterRegistry.registerLongCounter(ES_SEARCH_QUERY_AGGREGATIONS_TOTAL_COUNT, "Aggregations usage", "count");
    }

    public void incAggregationUsage(String aggregationName, String valuesSourceType) {
        Map<String, LongAdder> valuesSourceMap = this.aggs.get(aggregationName);
        if (valuesSourceMap != null) {
            LongAdder adder = valuesSourceMap.get(valuesSourceType);
            if (adder != null) {
                adder.increment();
            }
            assert (adder != null) : "Unknown subtype [" + aggregationName + "][" + valuesSourceType + "]";
        }
        assert (valuesSourceMap != null) : "Unknown aggregation [" + aggregationName + "][" + valuesSourceType + "]";
        String VALUES_SOURCE_KEY = "values_source";
        String AGGREGATION_NAME_KEY = "aggregation_name";
        this.aggregationsUsageCounter.incrementBy(1L, Map.of(AGGREGATION_NAME_KEY, aggregationName, VALUES_SOURCE_KEY, valuesSourceType));
    }

    public Map<String, Object> getUsageStats() {
        HashMap<String, Object> aggsUsageMap = new HashMap<String, Object>();
        this.aggs.forEach((name, agg) -> {
            HashMap aggUsageMap = new HashMap();
            agg.forEach((k, v) -> {
                long val = v.longValue();
                if (val > 0L) {
                    aggUsageMap.put(k, val);
                }
            });
            if (!aggUsageMap.isEmpty()) {
                aggsUsageMap.put((String)name, aggUsageMap);
            }
        });
        return aggsUsageMap;
    }

    @Override
    public AggregationInfo info() {
        return this.info;
    }

    public static class Builder {
        private final Map<String, Map<String, LongAdder>> aggs = new HashMap<String, Map<String, LongAdder>>();
        private final MeterRegistry meterRegistry;

        public Builder() {
            this(MeterRegistry.NOOP);
        }

        public Builder(MeterRegistry meterRegistry) {
            assert (meterRegistry != null);
            this.meterRegistry = meterRegistry;
        }

        public void registerAggregationUsage(String aggregationName) {
            this.registerAggregationUsage(aggregationName, AggregationUsageService.OTHER_SUBTYPE);
        }

        public void registerAggregationUsage(String aggregationName, String valuesSourceType) {
            Map subAgg = this.aggs.computeIfAbsent(aggregationName, k -> new HashMap());
            if (subAgg.put(valuesSourceType, new LongAdder()) != null) {
                throw new IllegalArgumentException("stats for aggregation [" + aggregationName + "][" + valuesSourceType + "] already registered");
            }
        }

        public AggregationUsageService build() {
            return new AggregationUsageService(this);
        }
    }
}

