package vulnerability

import (
	"fmt"

	"github.com/anchore/grype/grype/pkg/qualifier"
	"github.com/anchore/grype/grype/version"
	"github.com/anchore/syft/syft/cpe"
)

type Reference struct {
	ID        string
	Namespace string
	Internal  any
}

type Vulnerability struct {
	Reference
	Status                 string
	PackageName            string
	Constraint             version.Constraint
	PackageQualifiers      []qualifier.Qualifier
	CPEs                   []cpe.CPE
	Fix                    Fix
	Advisories             []Advisory
	RelatedVulnerabilities []Reference
	Metadata               *Metadata
}

func (v Vulnerability) String() string {
	constraint := "(none)"
	if v.Constraint != nil {
		constraint = v.Constraint.String()
	}
	return fmt.Sprintf("Vuln(id=%s constraint=%q qualifiers=%+v)", v.ID, constraint, v.PackageQualifiers)
}
