/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.xml.AbstractModifyXmlFileAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathReplaceAction
extends AbstractModifyXmlFileAction
implements PropertyLoggingInterceptor {
    private File[] files;
    private String xpathExpression;
    private String regex = ".*";
    private String replacement;
    private boolean replaceAll = false;
    private boolean quoteVariables = true;
    private boolean logReplacement = true;

    public File[] getFiles() {
        return XPathReplaceAction.replaceVariables(this.files);
    }

    public void setFiles(File[] fileArray) {
        this.files = fileArray;
    }

    public String getXpathExpression() {
        return XPathReplaceAction.replaceVariables(this.xpathExpression);
    }

    public void setXpathExpression(String string) {
        this.xpathExpression = string;
    }

    public String getRegex() {
        return XPathReplaceAction.replaceVariables(this.regex, this.quoteVariables ? ReplacementMode.REGEXP_MATCH : ReplacementMode.PLAIN);
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public String getReplacement() {
        return XPathReplaceAction.replaceVariables(this.replacement, this.quoteVariables ? ReplacementMode.REGEXP_REPLACEMENT : ReplacementMode.PLAIN);
    }

    public void setReplacement(String string) {
        this.replacement = string;
    }

    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    public void setReplaceAll(boolean bl) {
        this.replaceAll = bl;
    }

    public boolean isQuoteVariables() {
        return this.quoteVariables;
    }

    public void setQuoteVariables(boolean bl) {
        this.quoteVariables = bl;
    }

    public boolean isLogReplacement() {
        return this.logReplacement;
    }

    public void setLogReplacement(boolean bl) {
        this.logReplacement = bl;
    }

    public Object getLogValueForProperty(String string, Object object) {
        return this.maybeFilterLogReplacement(string, "replacement", object, this.logReplacement);
    }

    public boolean execute(Context context) throws UserCanceledException {
        return this.executeForMultipleFiles(context, this.getFiles());
    }

    protected boolean modifyFile(File file, Context context) throws IOException {
        Document document = this.parseFile(file);
        NodeList nodeList = XmlHelper.getNodeList(document, this.getXpathExpression());
        if (nodeList == null) {
            return false;
        }
        if (nodeList.getLength() == 0) {
            Logger.getInstance().log(this, "No nodes found for XPath " + this.getXpathExpression(), false);
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeValue();
            if (string == null) {
                return false;
            }
            string = this.isReplaceAll() ? string.replaceAll(this.getRegex(), this.getReplacement()) : string.replaceFirst(this.getRegex(), this.getReplacement());
            node.setNodeValue(string);
        }
        XmlHelper.writeFile(file, document);
        return true;
    }
}

