#include <stdio.h>
#include <errno.h>
#include <pcre.h>
#include <ctype.h>
#include <string.h>
#include "vars.h"

int add_id(char *string,char ***id_list,int *count)
{
 char tmp[ML_CFG],etmp[ML_ETMP], *k;
 FILE *fp;
 int i;

 #ifdef DEBUG_ID
 fprintf(stderr,"Parse id string: %s\n",string);
 #endif

 // Get from file?
 if (string[0]=='f' && string[1]==':')
  {
     #ifdef DEBUG_ID
     fprintf(stderr," get id from file: %s\n",&string[2]);
     #endif

     if (strlen(string)>ML_FILE_NAME)
        {
	 sprintf(etmp,"ERROR: Very long file name, exit: %s",&string[2]);
	 exit(-1);
	}

     // Open file
     if ((fp=fopen(&string[2],"r"))==NULL)
         { // Open error
           sprintf(etmp,"ERROR: Can't open file %s: %s",&string[2],strerror(errno));
           err_mes(etmp);
           exit(-1);
         }
  
     // Parse file
     while(!feof(fp))
     {
      // Get line
      if (fgets(tmp,ML_CFG,fp)==NULL) continue;

      //Chomp
       if (tmp[strlen(tmp)-1]=='\n' || tmp[strlen(tmp)-1]=='\r') tmp[strlen(tmp)-1]=0;
       if (tmp[strlen(tmp)-1]=='\n' || tmp[strlen(tmp)-1]=='\r') tmp[strlen(tmp)-1]=0;
       if (strlen(tmp)<=0) continue;
		 
      #ifdef DEBUG_ID
       fprintf(stderr,"   read id: %s\n",tmp);
      #endif

     // Strip by comment  ' ',9,'#',';'
      k=strchr(tmp,' '); if (k) *k=0;
      k=strchr(tmp,9); if (k) *k=0;
      k=strchr(tmp,'#'); if (k) *k=0; 
      k=strchr(tmp,';'); if (k) *k=0;      
      

      //Strip free space in line start
       while(tmp[0]==' ' || tmp[0]==9)
        for(i=0;i<strlen(tmp);i++)
         tmp[i]=tmp[i+1];
			       
     //Check for comment
       if(tmp[0]!='#' && tmp[0]!=';' && tmp[0]!=0)
        {
	 #ifdef DEBUG_ID
          fprintf(stderr,"  write id: %s\n",tmp);
         #endif

         add_id(tmp,id_list,count);
	}
     }
    fclose(fp);
    return(0);
   }
 
  if (strlen(string)>ML_IDENT) 
     {
      sprintf(etmp,"ERROR: Len of id >%i, exit: %s",ML_IDENT,string);
      err_mes(etmp);
      exit(-1);
     }
  
  for(i=0;i<strlen(string);i++)
  {
   string[i]=tolower((int)string[i]);
  }
     
  //Add memory
  *id_list=(char**)realloc(*id_list,(1+(*count))*sizeof(char*));
	   if (*id_list==NULL)
	   {
	    err_mes("Error: Can't allocate memory(realoc) for allow_id\n");
	    exit(-1);
           }

      (*id_list)[(*count)]=(char*)strdup(string);
	   if ((*id_list)[(*count)]==NULL)
	   {
	    err_mes("Error: Can't allocate memory(strdup) for allow_id\n");
	    exit(-1);
           }

    (*count)++;
    return(0);
   
}

int sort_id(char ***id_list,int *count)
{
 #ifdef DEBUG_ID
 int i;
 #endif

 qsort(*id_list,*count,sizeof(char*),cmp_urls);


 #ifdef DEBUG_ID
 fprintf(stderr," === Sort id list ===\n");
 for (i=0;i<*count;i++)
 fprintf(stderr,"%s\n",(*id_list)[i]);
 #endif
 
 return(0);
}


/**********************************************
 *********** Find in allow_id list ************/
 
 int check_id(char **id_list,int count)
{

 #ifdef DEBUG_ID
 fprintf(stderr," Find id %s in id list\n",input_ident_un);
 #endif

  if (bsearch(&input_ident_un, id_list, count, sizeof(char*),cmp_urls))
       return(1);   //Found
  else return (0);  //Not Found
}
 
 	     
