/* $Id$
 *
 * Copyright (C) 2005 The Trustees of the University of Pennsylvania
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 * vlan.h
 *
 * This header file provides support for IEEE 802.1q tagged Ethernet
 * frames. 
 */

#ifndef _VLAN_H
#define _VLAN_H

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#ifdef HAVE_NETINET_IN_H
#  include <netinet/in.h>
#endif

#ifndef ETHERTYPE_VLAN
#  define ETHERTYPE_VLAN 0x8100
#endif /* ETHERTYPE_VLAN */

struct vlan_hdr {
  unsigned char ether_dhost[6];
  unsigned char ether_shost[6];
  unsigned short protocol;
  unsigned short pcv;		/* priority/cfi/vlan id */
  unsigned short ether_type;
};

#define VLAN_ID_MASK 0x0fff
#define VLAN_ID(vh) (ntohs((vh)->pcv) & VLAN_ID_MASK)

#endif /* _VLAN_H */
