import os
import sys

from macholib.util import is_platform_file


def print_platform_files(root, files):
    for fn in files:
        path = os.path.join(root, fn)
        if is_platform_file(path):
            print(path)

def run():
    deferred = []

    app = os.path.abspath(sys.argv[1])

    for root, _dirs, files in os.walk(app, topdown=False):
        # MacOS directory stuff must be signed last
        if root.endswith("Contents/MacOS"):
            deferred.append((root, files))
            continue
        print_platform_files(root, files)

    for root, files in deferred:
        print_platform_files(root, files)

    print(app)


if __name__ == "__main__":
    run()
