// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1p4beta1/image_annotator.proto

package vision

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	_ "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A bucketized representation of likelihood, which is intended to give clients
// highly stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// It is very unlikely that the image belongs to the specified vertical.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// It is unlikely that the image belongs to the specified vertical.
	Likelihood_UNLIKELY Likelihood = 2
	// It is possible that the image belongs to the specified vertical.
	Likelihood_POSSIBLE Likelihood = 3
	// It is likely that the image belongs to the specified vertical.
	Likelihood_LIKELY Likelihood = 4
	// It is very likely that the image belongs to the specified vertical.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{0}
}

// Type of Google Cloud Vision API feature to be extracted.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run text detection / optical character recognition (OCR). Text detection
	// is optimized for areas of text within a larger image; if the image is
	// a document, use `DOCUMENT_TEXT_DETECTION` instead.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run dense text document OCR. Takes precedence when both
	// `DOCUMENT_TEXT_DETECTION` and `TEXT_DETECTION` are present.
	Feature_DOCUMENT_TEXT_DETECTION Feature_Type = 11
	// Run Safe Search to detect potentially unsafe
	// or undesirable content.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of image properties, such as the
	// image's dominant colors.
	Feature_IMAGE_PROPERTIES Feature_Type = 7
	// Run crop hints.
	Feature_CROP_HINTS Feature_Type = 9
	// Run web detection.
	Feature_WEB_DETECTION Feature_Type = 10
	// Run Product Search.
	Feature_PRODUCT_SEARCH Feature_Type = 12
	// Run localizer for object detection.
	Feature_OBJECT_LOCALIZATION Feature_Type = 19
)

var Feature_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "FACE_DETECTION",
	2:  "LANDMARK_DETECTION",
	3:  "LOGO_DETECTION",
	4:  "LABEL_DETECTION",
	5:  "TEXT_DETECTION",
	11: "DOCUMENT_TEXT_DETECTION",
	6:  "SAFE_SEARCH_DETECTION",
	7:  "IMAGE_PROPERTIES",
	9:  "CROP_HINTS",
	10: "WEB_DETECTION",
	12: "PRODUCT_SEARCH",
	19: "OBJECT_LOCALIZATION",
}

var Feature_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":        0,
	"FACE_DETECTION":          1,
	"LANDMARK_DETECTION":      2,
	"LOGO_DETECTION":          3,
	"LABEL_DETECTION":         4,
	"TEXT_DETECTION":          5,
	"DOCUMENT_TEXT_DETECTION": 11,
	"SAFE_SEARCH_DETECTION":   6,
	"IMAGE_PROPERTIES":        7,
	"CROP_HINTS":              9,
	"WEB_DETECTION":           10,
	"PRODUCT_SEARCH":          12,
	"OBJECT_LOCALIZATION":     19,
}

func (x Feature_Type) String() string {
	return proto.EnumName(Feature_Type_name, int32(x))
}

func (Feature_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{0, 0}
}

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image
// without considering mirror projections typical of photos. So, `LEFT_EYE`,
// typically, is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
)

var FaceAnnotation_Landmark_Type_name = map[int32]string{
	0:  "UNKNOWN_LANDMARK",
	1:  "LEFT_EYE",
	2:  "RIGHT_EYE",
	3:  "LEFT_OF_LEFT_EYEBROW",
	4:  "RIGHT_OF_LEFT_EYEBROW",
	5:  "LEFT_OF_RIGHT_EYEBROW",
	6:  "RIGHT_OF_RIGHT_EYEBROW",
	7:  "MIDPOINT_BETWEEN_EYES",
	8:  "NOSE_TIP",
	9:  "UPPER_LIP",
	10: "LOWER_LIP",
	11: "MOUTH_LEFT",
	12: "MOUTH_RIGHT",
	13: "MOUTH_CENTER",
	14: "NOSE_BOTTOM_RIGHT",
	15: "NOSE_BOTTOM_LEFT",
	16: "NOSE_BOTTOM_CENTER",
	17: "LEFT_EYE_TOP_BOUNDARY",
	18: "LEFT_EYE_RIGHT_CORNER",
	19: "LEFT_EYE_BOTTOM_BOUNDARY",
	20: "LEFT_EYE_LEFT_CORNER",
	21: "RIGHT_EYE_TOP_BOUNDARY",
	22: "RIGHT_EYE_RIGHT_CORNER",
	23: "RIGHT_EYE_BOTTOM_BOUNDARY",
	24: "RIGHT_EYE_LEFT_CORNER",
	25: "LEFT_EYEBROW_UPPER_MIDPOINT",
	26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
	27: "LEFT_EAR_TRAGION",
	28: "RIGHT_EAR_TRAGION",
	29: "LEFT_EYE_PUPIL",
	30: "RIGHT_EYE_PUPIL",
	31: "FOREHEAD_GLABELLA",
	32: "CHIN_GNATHION",
	33: "CHIN_LEFT_GONION",
	34: "CHIN_RIGHT_GONION",
}

var FaceAnnotation_Landmark_Type_value = map[string]int32{
	"UNKNOWN_LANDMARK":             0,
	"LEFT_EYE":                     1,
	"RIGHT_EYE":                    2,
	"LEFT_OF_LEFT_EYEBROW":         3,
	"RIGHT_OF_LEFT_EYEBROW":        4,
	"LEFT_OF_RIGHT_EYEBROW":        5,
	"RIGHT_OF_RIGHT_EYEBROW":       6,
	"MIDPOINT_BETWEEN_EYES":        7,
	"NOSE_TIP":                     8,
	"UPPER_LIP":                    9,
	"LOWER_LIP":                    10,
	"MOUTH_LEFT":                   11,
	"MOUTH_RIGHT":                  12,
	"MOUTH_CENTER":                 13,
	"NOSE_BOTTOM_RIGHT":            14,
	"NOSE_BOTTOM_LEFT":             15,
	"NOSE_BOTTOM_CENTER":           16,
	"LEFT_EYE_TOP_BOUNDARY":        17,
	"LEFT_EYE_RIGHT_CORNER":        18,
	"LEFT_EYE_BOTTOM_BOUNDARY":     19,
	"LEFT_EYE_LEFT_CORNER":         20,
	"RIGHT_EYE_TOP_BOUNDARY":       21,
	"RIGHT_EYE_RIGHT_CORNER":       22,
	"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
	"RIGHT_EYE_LEFT_CORNER":        24,
	"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
	"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
	"LEFT_EAR_TRAGION":             27,
	"RIGHT_EAR_TRAGION":            28,
	"LEFT_EYE_PUPIL":               29,
	"RIGHT_EYE_PUPIL":              30,
	"FOREHEAD_GLABELLA":            31,
	"CHIN_GNATHION":                32,
	"CHIN_LEFT_GONION":             33,
	"CHIN_RIGHT_GONION":            34,
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return proto.EnumName(FaceAnnotation_Landmark_Type_name, int32(x))
}

func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{3, 0, 0}
}

// Batch operation states.
type OperationMetadata_State int32

const (
	// Invalid.
	OperationMetadata_STATE_UNSPECIFIED OperationMetadata_State = 0
	// Request is received.
	OperationMetadata_CREATED OperationMetadata_State = 1
	// Request is actively being processed.
	OperationMetadata_RUNNING OperationMetadata_State = 2
	// The batch processing is done.
	OperationMetadata_DONE OperationMetadata_State = 3
	// The batch processing was cancelled.
	OperationMetadata_CANCELLED OperationMetadata_State = 4
)

var OperationMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATED",
	2: "RUNNING",
	3: "DONE",
	4: "CANCELLED",
}

var OperationMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATED":           1,
	"RUNNING":           2,
	"DONE":              3,
	"CANCELLED":         4,
}

func (x OperationMetadata_State) String() string {
	return proto.EnumName(OperationMetadata_State_name, int32(x))
}

func (OperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{37, 0}
}

// The type of Google Cloud Vision API detection to perform, and the maximum
// number of results to return for that type. Multiple `Feature` objects can
// be specified in the `features` list.
type Feature struct {
	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vision.v1p4beta1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type. Does not apply to
	// `TEXT_DETECTION`, `DOCUMENT_TEXT_DETECTION`, or `CROP_HINTS`.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Model to use for the feature.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Feature) Reset()         { *m = Feature{} }
func (m *Feature) String() string { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()    {}
func (*Feature) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{0}
}

func (m *Feature) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Feature.Unmarshal(m, b)
}
func (m *Feature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Feature.Marshal(b, m, deterministic)
}
func (m *Feature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Feature.Merge(m, src)
}
func (m *Feature) XXX_Size() int {
	return xxx_messageInfo_Feature.Size(m)
}
func (m *Feature) XXX_DiscardUnknown() {
	xxx_messageInfo_Feature.DiscardUnknown(m)
}

var xxx_messageInfo_Feature proto.InternalMessageInfo

func (m *Feature) GetType() Feature_Type {
	if m != nil {
		return m.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

func (m *Feature) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *Feature) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// External image source (Google Cloud Storage or web URL image location).
type ImageSource struct {
	// **Use `image_uri` instead.**
	//
	// The Google Cloud Storage  URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. See
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris) for more info.
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri,proto3" json:"gcs_image_uri,omitempty"`
	// The URI of the source image. Can be either:
	//
	// 1. A Google Cloud Storage URI of the form
	//    `gs://bucket_name/object_name`. Object versioning is not supported. See
	//    [Google Cloud Storage Request
	//    URIs](https://cloud.google.com/storage/docs/reference-uris) for more
	//    info.
	//
	// 2. A publicly-accessible image HTTP/HTTPS URL. When fetching images from
	//    HTTP/HTTPS URLs, Google cannot guarantee that the request will be
	//    completed. Your request may fail if the specified host denies the
	//    request (e.g. due to request throttling or DOS prevention), or if Google
	//    throttles requests to the site for abuse prevention. You should not
	//    depend on externally-hosted images for production applications.
	//
	// When both `gcs_image_uri` and `image_uri` are specified, `image_uri` takes
	// precedence.
	ImageUri             string   `protobuf:"bytes,2,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageSource) Reset()         { *m = ImageSource{} }
func (m *ImageSource) String() string { return proto.CompactTextString(m) }
func (*ImageSource) ProtoMessage()    {}
func (*ImageSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{1}
}

func (m *ImageSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageSource.Unmarshal(m, b)
}
func (m *ImageSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageSource.Marshal(b, m, deterministic)
}
func (m *ImageSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSource.Merge(m, src)
}
func (m *ImageSource) XXX_Size() int {
	return xxx_messageInfo_ImageSource.Size(m)
}
func (m *ImageSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSource.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSource proto.InternalMessageInfo

func (m *ImageSource) GetGcsImageUri() string {
	if m != nil {
		return m.GcsImageUri
	}
	return ""
}

func (m *ImageSource) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	// Image content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location, or publicly-accessible image
	// URL. If both `content` and `source` are provided for an image, `content`
	// takes precedence and is used to perform the image annotation request.
	Source               *ImageSource `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{2}
}

func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Image) GetSource() *ImageSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// `BoundingPoly` (the polygon will be unbounded) if only a partial face
	// appears in the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The `fd_bounding_poly` bounding polygon is tighter than the
	// `boundingPoly`, and encloses only the skin part of the face. Typically, it
	// is used to eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly,proto3" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	// Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
	// of the face relative to the image vertical about the axis perpendicular to
	// the face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle,proto3" json:"roll_angle,omitempty"`
	// Yaw angle, which indicates the leftward/rightward angle that the face is
	// pointing relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle,proto3" json:"pan_angle,omitempty"`
	// Pitch angle, which indicates the upwards/downwards angle that the face is
	// pointing relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle,proto3" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence,proto3" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence,proto3" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood   Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"headwear_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{3}
}

func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(m, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.FdBoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

func (m *FaceAnnotation) GetRollAngle() float32 {
	if m != nil {
		return m.RollAngle
	}
	return 0
}

func (m *FaceAnnotation) GetPanAngle() float32 {
	if m != nil {
		return m.PanAngle
	}
	return 0
}

func (m *FaceAnnotation) GetTiltAngle() float32 {
	if m != nil {
		return m.TiltAngle
	}
	return 0
}

func (m *FaceAnnotation) GetDetectionConfidence() float32 {
	if m != nil {
		return m.DetectionConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetLandmarkingConfidence() float32 {
	if m != nil {
		return m.LandmarkingConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetJoyLikelihood() Likelihood {
	if m != nil {
		return m.JoyLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSorrowLikelihood() Likelihood {
	if m != nil {
		return m.SorrowLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetAngerLikelihood() Likelihood {
	if m != nil {
		return m.AngerLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSurpriseLikelihood() Likelihood {
	if m != nil {
		return m.SurpriseLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetUnderExposedLikelihood() Likelihood {
	if m != nil {
		return m.UnderExposedLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetBlurredLikelihood() Likelihood {
	if m != nil {
		return m.BlurredLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetHeadwearLikelihood() Likelihood {
	if m != nil {
		return m.HeadwearLikelihood
	}
	return Likelihood_UNKNOWN
}

// A face-specific landmark (for example, a face feature).
type FaceAnnotation_Landmark struct {
	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.vision.v1p4beta1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position             *Position `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *FaceAnnotation_Landmark) Reset()         { *m = FaceAnnotation_Landmark{} }
func (m *FaceAnnotation_Landmark) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation_Landmark) ProtoMessage()    {}
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{3, 0}
}

func (m *FaceAnnotation_Landmark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation_Landmark.Unmarshal(m, b)
}
func (m *FaceAnnotation_Landmark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation_Landmark.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation_Landmark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation_Landmark.Merge(m, src)
}
func (m *FaceAnnotation_Landmark) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation_Landmark.Size(m)
}
func (m *FaceAnnotation_Landmark) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation_Landmark.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation_Landmark proto.InternalMessageInfo

func (m *FaceAnnotation_Landmark) GetType() FaceAnnotation_Landmark_Type {
	if m != nil {
		return m.Type
	}
	return FaceAnnotation_Landmark_UNKNOWN_LANDMARK
}

func (m *FaceAnnotation_Landmark) GetPosition() *Position {
	if m != nil {
		return m.Position
	}
	return nil
}

// Detected entity location information.
type LocationInfo struct {
	// lat/long location coordinates.
	LatLng               *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *LocationInfo) Reset()         { *m = LocationInfo{} }
func (m *LocationInfo) String() string { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()    {}
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{4}
}

func (m *LocationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationInfo.Unmarshal(m, b)
}
func (m *LocationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationInfo.Marshal(b, m, deterministic)
}
func (m *LocationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationInfo.Merge(m, src)
}
func (m *LocationInfo) XXX_Size() int {
	return xxx_messageInfo_LocationInfo.Size(m)
}
func (m *LocationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LocationInfo proto.InternalMessageInfo

func (m *LocationInfo) GetLatLng() *latlng.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

// A `Property` consists of a user-supplied name/value pair.
type Property struct {
	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Value of numeric properties.
	Uint64Value          uint64   `protobuf:"varint,3,opt,name=uint64_value,json=uint64Value,proto3" json:"uint64_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Property) Reset()         { *m = Property{} }
func (m *Property) String() string { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()    {}
func (*Property) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{5}
}

func (m *Property) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Property.Unmarshal(m, b)
}
func (m *Property) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Property.Marshal(b, m, deterministic)
}
func (m *Property) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Property.Merge(m, src)
}
func (m *Property) XXX_Size() int {
	return xxx_messageInfo_Property.Size(m)
}
func (m *Property) XXX_DiscardUnknown() {
	xxx_messageInfo_Property.DiscardUnknown(m)
}

var xxx_messageInfo_Property proto.InternalMessageInfo

func (m *Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Property) GetUint64Value() uint64 {
	if m != nil {
		return m.Uint64Value
	}
	return 0
}

// Set of detected entity features.
type EntityAnnotation struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	Mid string `protobuf:"bytes,1,opt,name=mid,proto3" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// `description` is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale,proto3" json:"locale,omitempty"`
	// Entity textual description, expressed in its `locale` language.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// **Deprecated. Use `score` instead.**
	// The accuracy of the entity detection in an image.
	// For example, for an image in which the "Eiffel Tower" entity is detected,
	// this field represents the confidence that there is a tower in the query
	// image. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"` // Deprecated: Do not use.
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of "tower" is likely higher to an image
	// containing the detected "Eiffel Tower" than to an image containing a
	// detected distant towering building, even though the confidence that
	// there is a tower in each image may be the same. Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality,proto3" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Not produced
	// for `LABEL_DETECTION` features.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// `LocationInfo` elements can be present because one location may
	// indicate the location of the scene in the image, and another location
	// may indicate the location of the place where the image was taken.
	// Location information is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations,proto3" json:"locations,omitempty"`
	// Some entities may have optional user-supplied `Property` (name/value)
	// fields, such a score or string that qualifies the entity.
	Properties           []*Property `protobuf:"bytes,9,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EntityAnnotation) Reset()         { *m = EntityAnnotation{} }
func (m *EntityAnnotation) String() string { return proto.CompactTextString(m) }
func (*EntityAnnotation) ProtoMessage()    {}
func (*EntityAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{6}
}

func (m *EntityAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityAnnotation.Unmarshal(m, b)
}
func (m *EntityAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityAnnotation.Marshal(b, m, deterministic)
}
func (m *EntityAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityAnnotation.Merge(m, src)
}
func (m *EntityAnnotation) XXX_Size() int {
	return xxx_messageInfo_EntityAnnotation.Size(m)
}
func (m *EntityAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_EntityAnnotation proto.InternalMessageInfo

func (m *EntityAnnotation) GetMid() string {
	if m != nil {
		return m.Mid
	}
	return ""
}

func (m *EntityAnnotation) GetLocale() string {
	if m != nil {
		return m.Locale
	}
	return ""
}

func (m *EntityAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EntityAnnotation) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

// Deprecated: Do not use.
func (m *EntityAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *EntityAnnotation) GetTopicality() float32 {
	if m != nil {
		return m.Topicality
	}
	return 0
}

func (m *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *EntityAnnotation) GetLocations() []*LocationInfo {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *EntityAnnotation) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Set of detected objects with bounding boxes.
type LocalizedObjectAnnotation struct {
	// Object ID that should align with EntityAnnotation mid.
	Mid string `protobuf:"bytes,1,opt,name=mid,proto3" json:"mid,omitempty"`
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Object name, expressed in its `language_code` language.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// Image region to which this object belongs. This must be populated.
	BoundingPoly         *BoundingPoly `protobuf:"bytes,5,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LocalizedObjectAnnotation) Reset()         { *m = LocalizedObjectAnnotation{} }
func (m *LocalizedObjectAnnotation) String() string { return proto.CompactTextString(m) }
func (*LocalizedObjectAnnotation) ProtoMessage()    {}
func (*LocalizedObjectAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{7}
}

func (m *LocalizedObjectAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocalizedObjectAnnotation.Unmarshal(m, b)
}
func (m *LocalizedObjectAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocalizedObjectAnnotation.Marshal(b, m, deterministic)
}
func (m *LocalizedObjectAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalizedObjectAnnotation.Merge(m, src)
}
func (m *LocalizedObjectAnnotation) XXX_Size() int {
	return xxx_messageInfo_LocalizedObjectAnnotation.Size(m)
}
func (m *LocalizedObjectAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalizedObjectAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LocalizedObjectAnnotation proto.InternalMessageInfo

func (m *LocalizedObjectAnnotation) GetMid() string {
	if m != nil {
		return m.Mid
	}
	return ""
}

func (m *LocalizedObjectAnnotation) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *LocalizedObjectAnnotation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LocalizedObjectAnnotation) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *LocalizedObjectAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

// Set of features pertaining to the image, computed by computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	// Represents the adult content likelihood for the image. Adult content may
	// contain elements such as nudity, pornographic images or cartoons, or
	// sexual activities.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood that this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood that this image contains violent content.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"violence,omitempty"`
	// Likelihood that the request image contains racy content. Racy content may
	// include (but is not limited to) skimpy or sheer clothing, strategically
	// covered nudity, lewd or provocative poses, or close-ups of sensitive
	// body areas.
	Racy                 Likelihood `protobuf:"varint,9,opt,name=racy,proto3,enum=google.cloud.vision.v1p4beta1.Likelihood" json:"racy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SafeSearchAnnotation) Reset()         { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()    {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{8}
}

func (m *SafeSearchAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SafeSearchAnnotation.Unmarshal(m, b)
}
func (m *SafeSearchAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SafeSearchAnnotation.Marshal(b, m, deterministic)
}
func (m *SafeSearchAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SafeSearchAnnotation.Merge(m, src)
}
func (m *SafeSearchAnnotation) XXX_Size() int {
	return xxx_messageInfo_SafeSearchAnnotation.Size(m)
}
func (m *SafeSearchAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_SafeSearchAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_SafeSearchAnnotation proto.InternalMessageInfo

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolence() Likelihood {
	if m != nil {
		return m.Violence
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetRacy() Likelihood {
	if m != nil {
		return m.Racy
	}
	return Likelihood_UNKNOWN
}

// Rectangle determined by min and max `LatLng` pairs.
type LatLongRect struct {
	// Min lat/long pair.
	MinLatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng,proto3" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng            *latlng.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng,proto3" json:"max_lat_lng,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *LatLongRect) Reset()         { *m = LatLongRect{} }
func (m *LatLongRect) String() string { return proto.CompactTextString(m) }
func (*LatLongRect) ProtoMessage()    {}
func (*LatLongRect) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{9}
}

func (m *LatLongRect) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LatLongRect.Unmarshal(m, b)
}
func (m *LatLongRect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LatLongRect.Marshal(b, m, deterministic)
}
func (m *LatLongRect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LatLongRect.Merge(m, src)
}
func (m *LatLongRect) XXX_Size() int {
	return xxx_messageInfo_LatLongRect.Size(m)
}
func (m *LatLongRect) XXX_DiscardUnknown() {
	xxx_messageInfo_LatLongRect.DiscardUnknown(m)
}

var xxx_messageInfo_LatLongRect proto.InternalMessageInfo

func (m *LatLongRect) GetMinLatLng() *latlng.LatLng {
	if m != nil {
		return m.MinLatLng
	}
	return nil
}

func (m *LatLongRect) GetMaxLatLng() *latlng.LatLng {
	if m != nil {
		return m.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score, and the fraction of
// the image that the color occupies in the image.
type ColorInfo struct {
	// RGB components of the color.
	Color *color.Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
	// The fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction        float32  `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction,proto3" json:"pixel_fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ColorInfo) Reset()         { *m = ColorInfo{} }
func (m *ColorInfo) String() string { return proto.CompactTextString(m) }
func (*ColorInfo) ProtoMessage()    {}
func (*ColorInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{10}
}

func (m *ColorInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ColorInfo.Unmarshal(m, b)
}
func (m *ColorInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ColorInfo.Marshal(b, m, deterministic)
}
func (m *ColorInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ColorInfo.Merge(m, src)
}
func (m *ColorInfo) XXX_Size() int {
	return xxx_messageInfo_ColorInfo.Size(m)
}
func (m *ColorInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ColorInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ColorInfo proto.InternalMessageInfo

func (m *ColorInfo) GetColor() *color.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

func (m *ColorInfo) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *ColorInfo) GetPixelFraction() float32 {
	if m != nil {
		return m.PixelFraction
	}
	return 0
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	// RGB color values with their score and pixel fraction.
	Colors               []*ColorInfo `protobuf:"bytes,1,rep,name=colors,proto3" json:"colors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DominantColorsAnnotation) Reset()         { *m = DominantColorsAnnotation{} }
func (m *DominantColorsAnnotation) String() string { return proto.CompactTextString(m) }
func (*DominantColorsAnnotation) ProtoMessage()    {}
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{11}
}

func (m *DominantColorsAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DominantColorsAnnotation.Unmarshal(m, b)
}
func (m *DominantColorsAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DominantColorsAnnotation.Marshal(b, m, deterministic)
}
func (m *DominantColorsAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DominantColorsAnnotation.Merge(m, src)
}
func (m *DominantColorsAnnotation) XXX_Size() int {
	return xxx_messageInfo_DominantColorsAnnotation.Size(m)
}
func (m *DominantColorsAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_DominantColorsAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_DominantColorsAnnotation proto.InternalMessageInfo

func (m *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if m != nil {
		return m.Colors
	}
	return nil
}

// Stores image properties, such as dominant colors.
type ImageProperties struct {
	// If present, dominant colors completed successfully.
	DominantColors       *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors,proto3" json:"dominant_colors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ImageProperties) Reset()         { *m = ImageProperties{} }
func (m *ImageProperties) String() string { return proto.CompactTextString(m) }
func (*ImageProperties) ProtoMessage()    {}
func (*ImageProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{12}
}

func (m *ImageProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageProperties.Unmarshal(m, b)
}
func (m *ImageProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageProperties.Marshal(b, m, deterministic)
}
func (m *ImageProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageProperties.Merge(m, src)
}
func (m *ImageProperties) XXX_Size() int {
	return xxx_messageInfo_ImageProperties.Size(m)
}
func (m *ImageProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageProperties.DiscardUnknown(m)
}

var xxx_messageInfo_ImageProperties proto.InternalMessageInfo

func (m *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if m != nil {
		return m.DominantColors
	}
	return nil
}

// Single crop hint that is used to generate a new crop when serving an image.
type CropHint struct {
	// The bounding polygon for the crop region. The coordinates of the bounding
	// box are in the original image's scale.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Confidence of this being a salient region.  Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Fraction of importance of this salient region with respect to the original
	// image.
	ImportanceFraction   float32  `protobuf:"fixed32,3,opt,name=importance_fraction,json=importanceFraction,proto3" json:"importance_fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CropHint) Reset()         { *m = CropHint{} }
func (m *CropHint) String() string { return proto.CompactTextString(m) }
func (*CropHint) ProtoMessage()    {}
func (*CropHint) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{13}
}

func (m *CropHint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CropHint.Unmarshal(m, b)
}
func (m *CropHint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CropHint.Marshal(b, m, deterministic)
}
func (m *CropHint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CropHint.Merge(m, src)
}
func (m *CropHint) XXX_Size() int {
	return xxx_messageInfo_CropHint.Size(m)
}
func (m *CropHint) XXX_DiscardUnknown() {
	xxx_messageInfo_CropHint.DiscardUnknown(m)
}

var xxx_messageInfo_CropHint proto.InternalMessageInfo

func (m *CropHint) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *CropHint) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *CropHint) GetImportanceFraction() float32 {
	if m != nil {
		return m.ImportanceFraction
	}
	return 0
}

// Set of crop hints that are used to generate new crops when serving images.
type CropHintsAnnotation struct {
	// Crop hint results.
	CropHints            []*CropHint `protobuf:"bytes,1,rep,name=crop_hints,json=cropHints,proto3" json:"crop_hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CropHintsAnnotation) Reset()         { *m = CropHintsAnnotation{} }
func (m *CropHintsAnnotation) String() string { return proto.CompactTextString(m) }
func (*CropHintsAnnotation) ProtoMessage()    {}
func (*CropHintsAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{14}
}

func (m *CropHintsAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CropHintsAnnotation.Unmarshal(m, b)
}
func (m *CropHintsAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CropHintsAnnotation.Marshal(b, m, deterministic)
}
func (m *CropHintsAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CropHintsAnnotation.Merge(m, src)
}
func (m *CropHintsAnnotation) XXX_Size() int {
	return xxx_messageInfo_CropHintsAnnotation.Size(m)
}
func (m *CropHintsAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_CropHintsAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_CropHintsAnnotation proto.InternalMessageInfo

func (m *CropHintsAnnotation) GetCropHints() []*CropHint {
	if m != nil {
		return m.CropHints
	}
	return nil
}

// Parameters for crop hints annotation request.
type CropHintsParams struct {
	// Aspect ratios in floats, representing the ratio of the width to the height
	// of the image. For example, if the desired aspect ratio is 4/3, the
	// corresponding float value should be 1.33333.  If not specified, the
	// best possible crop is returned. The number of provided aspect ratios is
	// limited to a maximum of 16; any aspect ratios provided after the 16th are
	// ignored.
	AspectRatios         []float32 `protobuf:"fixed32,1,rep,packed,name=aspect_ratios,json=aspectRatios,proto3" json:"aspect_ratios,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CropHintsParams) Reset()         { *m = CropHintsParams{} }
func (m *CropHintsParams) String() string { return proto.CompactTextString(m) }
func (*CropHintsParams) ProtoMessage()    {}
func (*CropHintsParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{15}
}

func (m *CropHintsParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CropHintsParams.Unmarshal(m, b)
}
func (m *CropHintsParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CropHintsParams.Marshal(b, m, deterministic)
}
func (m *CropHintsParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CropHintsParams.Merge(m, src)
}
func (m *CropHintsParams) XXX_Size() int {
	return xxx_messageInfo_CropHintsParams.Size(m)
}
func (m *CropHintsParams) XXX_DiscardUnknown() {
	xxx_messageInfo_CropHintsParams.DiscardUnknown(m)
}

var xxx_messageInfo_CropHintsParams proto.InternalMessageInfo

func (m *CropHintsParams) GetAspectRatios() []float32 {
	if m != nil {
		return m.AspectRatios
	}
	return nil
}

// Parameters for web detection request.
type WebDetectionParams struct {
	// Whether to include results derived from the geo information in the image.
	IncludeGeoResults    bool     `protobuf:"varint,2,opt,name=include_geo_results,json=includeGeoResults,proto3" json:"include_geo_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WebDetectionParams) Reset()         { *m = WebDetectionParams{} }
func (m *WebDetectionParams) String() string { return proto.CompactTextString(m) }
func (*WebDetectionParams) ProtoMessage()    {}
func (*WebDetectionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{16}
}

func (m *WebDetectionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebDetectionParams.Unmarshal(m, b)
}
func (m *WebDetectionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebDetectionParams.Marshal(b, m, deterministic)
}
func (m *WebDetectionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebDetectionParams.Merge(m, src)
}
func (m *WebDetectionParams) XXX_Size() int {
	return xxx_messageInfo_WebDetectionParams.Size(m)
}
func (m *WebDetectionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_WebDetectionParams.DiscardUnknown(m)
}

var xxx_messageInfo_WebDetectionParams proto.InternalMessageInfo

func (m *WebDetectionParams) GetIncludeGeoResults() bool {
	if m != nil {
		return m.IncludeGeoResults
	}
	return false
}

// Image context and/or feature-specific parameters.
type ImageContext struct {
	// Not used.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect,proto3" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported languages](/vision/docs/languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Parameters for crop hints annotation request.
	CropHintsParams *CropHintsParams `protobuf:"bytes,4,opt,name=crop_hints_params,json=cropHintsParams,proto3" json:"crop_hints_params,omitempty"`
	// Parameters for product search.
	ProductSearchParams *ProductSearchParams `protobuf:"bytes,5,opt,name=product_search_params,json=productSearchParams,proto3" json:"product_search_params,omitempty"`
	// Parameters for web detection.
	WebDetectionParams   *WebDetectionParams `protobuf:"bytes,6,opt,name=web_detection_params,json=webDetectionParams,proto3" json:"web_detection_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImageContext) Reset()         { *m = ImageContext{} }
func (m *ImageContext) String() string { return proto.CompactTextString(m) }
func (*ImageContext) ProtoMessage()    {}
func (*ImageContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{17}
}

func (m *ImageContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageContext.Unmarshal(m, b)
}
func (m *ImageContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageContext.Marshal(b, m, deterministic)
}
func (m *ImageContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageContext.Merge(m, src)
}
func (m *ImageContext) XXX_Size() int {
	return xxx_messageInfo_ImageContext.Size(m)
}
func (m *ImageContext) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageContext.DiscardUnknown(m)
}

var xxx_messageInfo_ImageContext proto.InternalMessageInfo

func (m *ImageContext) GetLatLongRect() *LatLongRect {
	if m != nil {
		return m.LatLongRect
	}
	return nil
}

func (m *ImageContext) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *ImageContext) GetCropHintsParams() *CropHintsParams {
	if m != nil {
		return m.CropHintsParams
	}
	return nil
}

func (m *ImageContext) GetProductSearchParams() *ProductSearchParams {
	if m != nil {
		return m.ProductSearchParams
	}
	return nil
}

func (m *ImageContext) GetWebDetectionParams() *WebDetectionParams {
	if m != nil {
		return m.WebDetectionParams
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features, and with context information.
type AnnotateImageRequest struct {
	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext         *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AnnotateImageRequest) Reset()         { *m = AnnotateImageRequest{} }
func (m *AnnotateImageRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateImageRequest) ProtoMessage()    {}
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{18}
}

func (m *AnnotateImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateImageRequest.Unmarshal(m, b)
}
func (m *AnnotateImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateImageRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateImageRequest.Merge(m, src)
}
func (m *AnnotateImageRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateImageRequest.Size(m)
}
func (m *AnnotateImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateImageRequest proto.InternalMessageInfo

func (m *AnnotateImageRequest) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *AnnotateImageRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateImageRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

// If an image was produced from a file (e.g. a PDF), this message gives
// information about the source of that image.
type ImageAnnotationContext struct {
	// The URI of the file used to produce the image.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// If the file was a PDF or TIFF, this field gives the page number within
	// the file used to produce the image.
	PageNumber           int32    `protobuf:"varint,2,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageAnnotationContext) Reset()         { *m = ImageAnnotationContext{} }
func (m *ImageAnnotationContext) String() string { return proto.CompactTextString(m) }
func (*ImageAnnotationContext) ProtoMessage()    {}
func (*ImageAnnotationContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{19}
}

func (m *ImageAnnotationContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageAnnotationContext.Unmarshal(m, b)
}
func (m *ImageAnnotationContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageAnnotationContext.Marshal(b, m, deterministic)
}
func (m *ImageAnnotationContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageAnnotationContext.Merge(m, src)
}
func (m *ImageAnnotationContext) XXX_Size() int {
	return xxx_messageInfo_ImageAnnotationContext.Size(m)
}
func (m *ImageAnnotationContext) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageAnnotationContext.DiscardUnknown(m)
}

var xxx_messageInfo_ImageAnnotationContext proto.InternalMessageInfo

func (m *ImageAnnotationContext) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *ImageAnnotationContext) GetPageNumber() int32 {
	if m != nil {
		return m.PageNumber
	}
	return 0
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	// If present, face detection has completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// If present, landmark detection has completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations,proto3" json:"landmark_annotations,omitempty"`
	// If present, logo detection has completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations,proto3" json:"logo_annotations,omitempty"`
	// If present, label detection has completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// If present, localized object detection has completed successfully.
	// This will be sorted descending by confidence score.
	LocalizedObjectAnnotations []*LocalizedObjectAnnotation `protobuf:"bytes,22,rep,name=localized_object_annotations,json=localizedObjectAnnotations,proto3" json:"localized_object_annotations,omitempty"`
	// If present, text (OCR) detection has completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	// This annotation provides the structural hierarchy for the OCR detected
	// text.
	FullTextAnnotation *TextAnnotation `protobuf:"bytes,12,opt,name=full_text_annotation,json=fullTextAnnotation,proto3" json:"full_text_annotation,omitempty"`
	// If present, safe-search annotation has completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation,proto3" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation,proto3" json:"image_properties_annotation,omitempty"`
	// If present, crop hints have completed successfully.
	CropHintsAnnotation *CropHintsAnnotation `protobuf:"bytes,11,opt,name=crop_hints_annotation,json=cropHintsAnnotation,proto3" json:"crop_hints_annotation,omitempty"`
	// If present, web detection has completed successfully.
	WebDetection *WebDetection `protobuf:"bytes,13,opt,name=web_detection,json=webDetection,proto3" json:"web_detection,omitempty"`
	// If present, product search has completed successfully.
	ProductSearchResults *ProductSearchResults `protobuf:"bytes,14,opt,name=product_search_results,json=productSearchResults,proto3" json:"product_search_results,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in image annotations are guaranteed to be
	// correct, even when `error` is set.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// If present, contextual information is needed to understand where this image
	// comes from.
	Context              *ImageAnnotationContext `protobuf:"bytes,21,opt,name=context,proto3" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *AnnotateImageResponse) Reset()         { *m = AnnotateImageResponse{} }
func (m *AnnotateImageResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateImageResponse) ProtoMessage()    {}
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{20}
}

func (m *AnnotateImageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateImageResponse.Unmarshal(m, b)
}
func (m *AnnotateImageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateImageResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateImageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateImageResponse.Merge(m, src)
}
func (m *AnnotateImageResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateImageResponse.Size(m)
}
func (m *AnnotateImageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateImageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateImageResponse proto.InternalMessageInfo

func (m *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LandmarkAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LogoAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLocalizedObjectAnnotations() []*LocalizedObjectAnnotation {
	if m != nil {
		return m.LocalizedObjectAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetFullTextAnnotation() *TextAnnotation {
	if m != nil {
		return m.FullTextAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if m != nil {
		return m.ImagePropertiesAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetCropHintsAnnotation() *CropHintsAnnotation {
	if m != nil {
		return m.CropHintsAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetWebDetection() *WebDetection {
	if m != nil {
		return m.WebDetection
	}
	return nil
}

func (m *AnnotateImageResponse) GetProductSearchResults() *ProductSearchResults {
	if m != nil {
		return m.ProductSearchResults
	}
	return nil
}

func (m *AnnotateImageResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *AnnotateImageResponse) GetContext() *ImageAnnotationContext {
	if m != nil {
		return m.Context
	}
	return nil
}

// Response to a single file annotation request. A file may contain one or more
// images, which individually have their own responses.
type AnnotateFileResponse struct {
	// Information about the file for which this response is generated.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Individual responses to images found within the file.
	Responses []*AnnotateImageResponse `protobuf:"bytes,2,rep,name=responses,proto3" json:"responses,omitempty"`
	// This field gives the total number of pages in the file.
	TotalPages           int32    `protobuf:"varint,3,opt,name=total_pages,json=totalPages,proto3" json:"total_pages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateFileResponse) Reset()         { *m = AnnotateFileResponse{} }
func (m *AnnotateFileResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateFileResponse) ProtoMessage()    {}
func (*AnnotateFileResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{21}
}

func (m *AnnotateFileResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateFileResponse.Unmarshal(m, b)
}
func (m *AnnotateFileResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateFileResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateFileResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateFileResponse.Merge(m, src)
}
func (m *AnnotateFileResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateFileResponse.Size(m)
}
func (m *AnnotateFileResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateFileResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateFileResponse proto.InternalMessageInfo

func (m *AnnotateFileResponse) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *AnnotateFileResponse) GetResponses() []*AnnotateImageResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

func (m *AnnotateFileResponse) GetTotalPages() int32 {
	if m != nil {
		return m.TotalPages
	}
	return 0
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	// Individual image annotation requests for this batch.
	Requests             []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *BatchAnnotateImagesRequest) Reset()         { *m = BatchAnnotateImagesRequest{} }
func (m *BatchAnnotateImagesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesRequest) ProtoMessage()    {}
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{22}
}

func (m *BatchAnnotateImagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnnotateImagesRequest.Unmarshal(m, b)
}
func (m *BatchAnnotateImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnnotateImagesRequest.Marshal(b, m, deterministic)
}
func (m *BatchAnnotateImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnnotateImagesRequest.Merge(m, src)
}
func (m *BatchAnnotateImagesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchAnnotateImagesRequest.Size(m)
}
func (m *BatchAnnotateImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnnotateImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnnotateImagesRequest proto.InternalMessageInfo

func (m *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	// Individual responses to image annotation requests within the batch.
	Responses            []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *BatchAnnotateImagesResponse) Reset()         { *m = BatchAnnotateImagesResponse{} }
func (m *BatchAnnotateImagesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesResponse) ProtoMessage()    {}
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{23}
}

func (m *BatchAnnotateImagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnnotateImagesResponse.Unmarshal(m, b)
}
func (m *BatchAnnotateImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnnotateImagesResponse.Marshal(b, m, deterministic)
}
func (m *BatchAnnotateImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnnotateImagesResponse.Merge(m, src)
}
func (m *BatchAnnotateImagesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchAnnotateImagesResponse.Size(m)
}
func (m *BatchAnnotateImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnnotateImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnnotateImagesResponse proto.InternalMessageInfo

func (m *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// A request to annotate one single file, e.g. a PDF, TIFF or GIF file.
type AnnotateFileRequest struct {
	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image(s) in the file.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
	// Pages of the file to perform image annotation.
	//
	// Pages starts from 1, we assume the first page of the file is page 1.
	// At most 5 pages are supported per request. Pages can be negative.
	//
	// Page 1 means the first page.
	// Page 2 means the second page.
	// Page -1 means the last page.
	// Page -2 means the second to the last page.
	//
	// If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
	//
	// If this field is empty, by default the service performs image annotation
	// for the first 5 pages of the file.
	Pages                []int32  `protobuf:"varint,4,rep,packed,name=pages,proto3" json:"pages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateFileRequest) Reset()         { *m = AnnotateFileRequest{} }
func (m *AnnotateFileRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateFileRequest) ProtoMessage()    {}
func (*AnnotateFileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{24}
}

func (m *AnnotateFileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateFileRequest.Unmarshal(m, b)
}
func (m *AnnotateFileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateFileRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateFileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateFileRequest.Merge(m, src)
}
func (m *AnnotateFileRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateFileRequest.Size(m)
}
func (m *AnnotateFileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateFileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateFileRequest proto.InternalMessageInfo

func (m *AnnotateFileRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *AnnotateFileRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateFileRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

func (m *AnnotateFileRequest) GetPages() []int32 {
	if m != nil {
		return m.Pages
	}
	return nil
}

// A list of requests to annotate files using the BatchAnnotateFiles API.
type BatchAnnotateFilesRequest struct {
	// The list of file annotation requests. Right now we support only one
	// AnnotateFileRequest in BatchAnnotateFilesRequest.
	Requests             []*AnnotateFileRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *BatchAnnotateFilesRequest) Reset()         { *m = BatchAnnotateFilesRequest{} }
func (m *BatchAnnotateFilesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchAnnotateFilesRequest) ProtoMessage()    {}
func (*BatchAnnotateFilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{25}
}

func (m *BatchAnnotateFilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnnotateFilesRequest.Unmarshal(m, b)
}
func (m *BatchAnnotateFilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnnotateFilesRequest.Marshal(b, m, deterministic)
}
func (m *BatchAnnotateFilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnnotateFilesRequest.Merge(m, src)
}
func (m *BatchAnnotateFilesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchAnnotateFilesRequest.Size(m)
}
func (m *BatchAnnotateFilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnnotateFilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnnotateFilesRequest proto.InternalMessageInfo

func (m *BatchAnnotateFilesRequest) GetRequests() []*AnnotateFileRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// A list of file annotation responses.
type BatchAnnotateFilesResponse struct {
	// The list of file annotation responses, each response corresponding to each
	// AnnotateFileRequest in BatchAnnotateFilesRequest.
	Responses            []*AnnotateFileResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *BatchAnnotateFilesResponse) Reset()         { *m = BatchAnnotateFilesResponse{} }
func (m *BatchAnnotateFilesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchAnnotateFilesResponse) ProtoMessage()    {}
func (*BatchAnnotateFilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{26}
}

func (m *BatchAnnotateFilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnnotateFilesResponse.Unmarshal(m, b)
}
func (m *BatchAnnotateFilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnnotateFilesResponse.Marshal(b, m, deterministic)
}
func (m *BatchAnnotateFilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnnotateFilesResponse.Merge(m, src)
}
func (m *BatchAnnotateFilesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchAnnotateFilesResponse.Size(m)
}
func (m *BatchAnnotateFilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnnotateFilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnnotateFilesResponse proto.InternalMessageInfo

func (m *BatchAnnotateFilesResponse) GetResponses() []*AnnotateFileResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// An offline file annotation request.
type AsyncAnnotateFileRequest struct {
	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image(s) in the file.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
	// Required. The desired output location and metadata (e.g. format).
	OutputConfig         *OutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AsyncAnnotateFileRequest) Reset()         { *m = AsyncAnnotateFileRequest{} }
func (m *AsyncAnnotateFileRequest) String() string { return proto.CompactTextString(m) }
func (*AsyncAnnotateFileRequest) ProtoMessage()    {}
func (*AsyncAnnotateFileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{27}
}

func (m *AsyncAnnotateFileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsyncAnnotateFileRequest.Unmarshal(m, b)
}
func (m *AsyncAnnotateFileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsyncAnnotateFileRequest.Marshal(b, m, deterministic)
}
func (m *AsyncAnnotateFileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsyncAnnotateFileRequest.Merge(m, src)
}
func (m *AsyncAnnotateFileRequest) XXX_Size() int {
	return xxx_messageInfo_AsyncAnnotateFileRequest.Size(m)
}
func (m *AsyncAnnotateFileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsyncAnnotateFileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsyncAnnotateFileRequest proto.InternalMessageInfo

func (m *AsyncAnnotateFileRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *AsyncAnnotateFileRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AsyncAnnotateFileRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

func (m *AsyncAnnotateFileRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// The response for a single offline file annotation request.
type AsyncAnnotateFileResponse struct {
	// The output location and metadata from AsyncAnnotateFileRequest.
	OutputConfig         *OutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AsyncAnnotateFileResponse) Reset()         { *m = AsyncAnnotateFileResponse{} }
func (m *AsyncAnnotateFileResponse) String() string { return proto.CompactTextString(m) }
func (*AsyncAnnotateFileResponse) ProtoMessage()    {}
func (*AsyncAnnotateFileResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{28}
}

func (m *AsyncAnnotateFileResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsyncAnnotateFileResponse.Unmarshal(m, b)
}
func (m *AsyncAnnotateFileResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsyncAnnotateFileResponse.Marshal(b, m, deterministic)
}
func (m *AsyncAnnotateFileResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsyncAnnotateFileResponse.Merge(m, src)
}
func (m *AsyncAnnotateFileResponse) XXX_Size() int {
	return xxx_messageInfo_AsyncAnnotateFileResponse.Size(m)
}
func (m *AsyncAnnotateFileResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsyncAnnotateFileResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsyncAnnotateFileResponse proto.InternalMessageInfo

func (m *AsyncAnnotateFileResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request for async image annotation for a list of images.
type AsyncBatchAnnotateImagesRequest struct {
	// Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Required. The desired output location and metadata (e.g. format).
	OutputConfig         *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AsyncBatchAnnotateImagesRequest) Reset()         { *m = AsyncBatchAnnotateImagesRequest{} }
func (m *AsyncBatchAnnotateImagesRequest) String() string { return proto.CompactTextString(m) }
func (*AsyncBatchAnnotateImagesRequest) ProtoMessage()    {}
func (*AsyncBatchAnnotateImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{29}
}

func (m *AsyncBatchAnnotateImagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsyncBatchAnnotateImagesRequest.Unmarshal(m, b)
}
func (m *AsyncBatchAnnotateImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsyncBatchAnnotateImagesRequest.Marshal(b, m, deterministic)
}
func (m *AsyncBatchAnnotateImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsyncBatchAnnotateImagesRequest.Merge(m, src)
}
func (m *AsyncBatchAnnotateImagesRequest) XXX_Size() int {
	return xxx_messageInfo_AsyncBatchAnnotateImagesRequest.Size(m)
}
func (m *AsyncBatchAnnotateImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsyncBatchAnnotateImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsyncBatchAnnotateImagesRequest proto.InternalMessageInfo

func (m *AsyncBatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

func (m *AsyncBatchAnnotateImagesRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Response to an async batch image annotation request.
type AsyncBatchAnnotateImagesResponse struct {
	// The output location and metadata from AsyncBatchAnnotateImagesRequest.
	OutputConfig         *OutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AsyncBatchAnnotateImagesResponse) Reset()         { *m = AsyncBatchAnnotateImagesResponse{} }
func (m *AsyncBatchAnnotateImagesResponse) String() string { return proto.CompactTextString(m) }
func (*AsyncBatchAnnotateImagesResponse) ProtoMessage()    {}
func (*AsyncBatchAnnotateImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{30}
}

func (m *AsyncBatchAnnotateImagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsyncBatchAnnotateImagesResponse.Unmarshal(m, b)
}
func (m *AsyncBatchAnnotateImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsyncBatchAnnotateImagesResponse.Marshal(b, m, deterministic)
}
func (m *AsyncBatchAnnotateImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsyncBatchAnnotateImagesResponse.Merge(m, src)
}
func (m *AsyncBatchAnnotateImagesResponse) XXX_Size() int {
	return xxx_messageInfo_AsyncBatchAnnotateImagesResponse.Size(m)
}
func (m *AsyncBatchAnnotateImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsyncBatchAnnotateImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsyncBatchAnnotateImagesResponse proto.InternalMessageInfo

func (m *AsyncBatchAnnotateImagesResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Multiple async file annotation requests are batched into a single service
// call.
type AsyncBatchAnnotateFilesRequest struct {
	// Individual async file annotation requests for this batch.
	Requests             []*AsyncAnnotateFileRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *AsyncBatchAnnotateFilesRequest) Reset()         { *m = AsyncBatchAnnotateFilesRequest{} }
func (m *AsyncBatchAnnotateFilesRequest) String() string { return proto.CompactTextString(m) }
func (*AsyncBatchAnnotateFilesRequest) ProtoMessage()    {}
func (*AsyncBatchAnnotateFilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{31}
}

func (m *AsyncBatchAnnotateFilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsyncBatchAnnotateFilesRequest.Unmarshal(m, b)
}
func (m *AsyncBatchAnnotateFilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsyncBatchAnnotateFilesRequest.Marshal(b, m, deterministic)
}
func (m *AsyncBatchAnnotateFilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsyncBatchAnnotateFilesRequest.Merge(m, src)
}
func (m *AsyncBatchAnnotateFilesRequest) XXX_Size() int {
	return xxx_messageInfo_AsyncBatchAnnotateFilesRequest.Size(m)
}
func (m *AsyncBatchAnnotateFilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsyncBatchAnnotateFilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsyncBatchAnnotateFilesRequest proto.InternalMessageInfo

func (m *AsyncBatchAnnotateFilesRequest) GetRequests() []*AsyncAnnotateFileRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to an async batch file annotation request.
type AsyncBatchAnnotateFilesResponse struct {
	// The list of file annotation responses, one for each request in
	// AsyncBatchAnnotateFilesRequest.
	Responses            []*AsyncAnnotateFileResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AsyncBatchAnnotateFilesResponse) Reset()         { *m = AsyncBatchAnnotateFilesResponse{} }
func (m *AsyncBatchAnnotateFilesResponse) String() string { return proto.CompactTextString(m) }
func (*AsyncBatchAnnotateFilesResponse) ProtoMessage()    {}
func (*AsyncBatchAnnotateFilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{32}
}

func (m *AsyncBatchAnnotateFilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsyncBatchAnnotateFilesResponse.Unmarshal(m, b)
}
func (m *AsyncBatchAnnotateFilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsyncBatchAnnotateFilesResponse.Marshal(b, m, deterministic)
}
func (m *AsyncBatchAnnotateFilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsyncBatchAnnotateFilesResponse.Merge(m, src)
}
func (m *AsyncBatchAnnotateFilesResponse) XXX_Size() int {
	return xxx_messageInfo_AsyncBatchAnnotateFilesResponse.Size(m)
}
func (m *AsyncBatchAnnotateFilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsyncBatchAnnotateFilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsyncBatchAnnotateFilesResponse proto.InternalMessageInfo

func (m *AsyncBatchAnnotateFilesResponse) GetResponses() []*AsyncAnnotateFileResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// The desired input location and metadata.
type InputConfig struct {
	// The Google Cloud Storage location to read the input from.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
	// File content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	//
	// Currently, this field only works for BatchAnnotateFiles requests. It does
	// not work for AsyncBatchAnnotateFiles requests.
	Content []byte `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
	// The type of the file. Currently only "application/pdf" and "image/tiff"
	// are supported. Wildcards are not supported.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{33}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

func (m *InputConfig) GetGcsSource() *GcsSource {
	if m != nil {
		return m.GcsSource
	}
	return nil
}

func (m *InputConfig) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *InputConfig) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// The desired output location and metadata.
type OutputConfig struct {
	// The Google Cloud Storage location to write the output(s) to.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
	// The max number of response protos to put into each output JSON file on
	// Google Cloud Storage.
	// The valid range is [1, 100]. If not specified, the default value is 20.
	//
	// For example, for one pdf file with 100 pages, 100 response protos will
	// be generated. If `batch_size` = 20, then 5 json files each
	// containing 20 response protos will be written under the prefix
	// `gcs_destination`.`uri`.
	//
	// Currently, batch_size only applies to GcsDestination, with potential future
	// support for other output configurations.
	BatchSize            int32    `protobuf:"varint,2,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{34}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if m != nil {
		return m.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

// The Google Cloud Storage location where the input will be read from.
type GcsSource struct {
	// Google Cloud Storage URI for the input file. This must only be a
	// Google Cloud Storage object. Wildcards are not currently supported.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{35}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The Google Cloud Storage location where the output will be written to.
type GcsDestination struct {
	// Google Cloud Storage URI where the results will be stored. Results will
	// be in JSON format and preceded by its corresponding input URI. This field
	// can either represent a single file, or a prefix for multiple outputs.
	// Prefixes must end in a `/`.
	//
	// Examples:
	//
	// *    File: gs://bucket-name/filename.json
	// *    Prefix: gs://bucket-name/prefix/here/
	// *    File: gs://bucket-name/prefix/here
	//
	// If multiple outputs, each response is still AnnotateFileResponse, each of
	// which contains some subset of the full list of AnnotateImageResponse.
	// Multiple outputs can happen if, for example, the output JSON is too large
	// and overflows into multiple sharded files.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{36}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Contains metadata for the BatchAnnotateImages operation.
type OperationMetadata struct {
	// Current state of the batch operation.
	State OperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.vision.v1p4beta1.OperationMetadata_State" json:"state,omitempty"`
	// The time when the batch request was received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time when the operation result was last updated.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8288fdc97aa9da03, []int{37}
}

func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (m *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(m, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

func (m *OperationMetadata) GetState() OperationMetadata_State {
	if m != nil {
		return m.State
	}
	return OperationMetadata_STATE_UNSPECIFIED
}

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.vision.v1p4beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.vision.v1p4beta1.Feature_Type", Feature_Type_name, Feature_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1p4beta1.FaceAnnotation_Landmark_Type", FaceAnnotation_Landmark_Type_name, FaceAnnotation_Landmark_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1p4beta1.OperationMetadata_State", OperationMetadata_State_name, OperationMetadata_State_value)
	proto.RegisterType((*Feature)(nil), "google.cloud.vision.v1p4beta1.Feature")
	proto.RegisterType((*ImageSource)(nil), "google.cloud.vision.v1p4beta1.ImageSource")
	proto.RegisterType((*Image)(nil), "google.cloud.vision.v1p4beta1.Image")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.vision.v1p4beta1.FaceAnnotation")
	proto.RegisterType((*FaceAnnotation_Landmark)(nil), "google.cloud.vision.v1p4beta1.FaceAnnotation.Landmark")
	proto.RegisterType((*LocationInfo)(nil), "google.cloud.vision.v1p4beta1.LocationInfo")
	proto.RegisterType((*Property)(nil), "google.cloud.vision.v1p4beta1.Property")
	proto.RegisterType((*EntityAnnotation)(nil), "google.cloud.vision.v1p4beta1.EntityAnnotation")
	proto.RegisterType((*LocalizedObjectAnnotation)(nil), "google.cloud.vision.v1p4beta1.LocalizedObjectAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.vision.v1p4beta1.SafeSearchAnnotation")
	proto.RegisterType((*LatLongRect)(nil), "google.cloud.vision.v1p4beta1.LatLongRect")
	proto.RegisterType((*ColorInfo)(nil), "google.cloud.vision.v1p4beta1.ColorInfo")
	proto.RegisterType((*DominantColorsAnnotation)(nil), "google.cloud.vision.v1p4beta1.DominantColorsAnnotation")
	proto.RegisterType((*ImageProperties)(nil), "google.cloud.vision.v1p4beta1.ImageProperties")
	proto.RegisterType((*CropHint)(nil), "google.cloud.vision.v1p4beta1.CropHint")
	proto.RegisterType((*CropHintsAnnotation)(nil), "google.cloud.vision.v1p4beta1.CropHintsAnnotation")
	proto.RegisterType((*CropHintsParams)(nil), "google.cloud.vision.v1p4beta1.CropHintsParams")
	proto.RegisterType((*WebDetectionParams)(nil), "google.cloud.vision.v1p4beta1.WebDetectionParams")
	proto.RegisterType((*ImageContext)(nil), "google.cloud.vision.v1p4beta1.ImageContext")
	proto.RegisterType((*AnnotateImageRequest)(nil), "google.cloud.vision.v1p4beta1.AnnotateImageRequest")
	proto.RegisterType((*ImageAnnotationContext)(nil), "google.cloud.vision.v1p4beta1.ImageAnnotationContext")
	proto.RegisterType((*AnnotateImageResponse)(nil), "google.cloud.vision.v1p4beta1.AnnotateImageResponse")
	proto.RegisterType((*AnnotateFileResponse)(nil), "google.cloud.vision.v1p4beta1.AnnotateFileResponse")
	proto.RegisterType((*BatchAnnotateImagesRequest)(nil), "google.cloud.vision.v1p4beta1.BatchAnnotateImagesRequest")
	proto.RegisterType((*BatchAnnotateImagesResponse)(nil), "google.cloud.vision.v1p4beta1.BatchAnnotateImagesResponse")
	proto.RegisterType((*AnnotateFileRequest)(nil), "google.cloud.vision.v1p4beta1.AnnotateFileRequest")
	proto.RegisterType((*BatchAnnotateFilesRequest)(nil), "google.cloud.vision.v1p4beta1.BatchAnnotateFilesRequest")
	proto.RegisterType((*BatchAnnotateFilesResponse)(nil), "google.cloud.vision.v1p4beta1.BatchAnnotateFilesResponse")
	proto.RegisterType((*AsyncAnnotateFileRequest)(nil), "google.cloud.vision.v1p4beta1.AsyncAnnotateFileRequest")
	proto.RegisterType((*AsyncAnnotateFileResponse)(nil), "google.cloud.vision.v1p4beta1.AsyncAnnotateFileResponse")
	proto.RegisterType((*AsyncBatchAnnotateImagesRequest)(nil), "google.cloud.vision.v1p4beta1.AsyncBatchAnnotateImagesRequest")
	proto.RegisterType((*AsyncBatchAnnotateImagesResponse)(nil), "google.cloud.vision.v1p4beta1.AsyncBatchAnnotateImagesResponse")
	proto.RegisterType((*AsyncBatchAnnotateFilesRequest)(nil), "google.cloud.vision.v1p4beta1.AsyncBatchAnnotateFilesRequest")
	proto.RegisterType((*AsyncBatchAnnotateFilesResponse)(nil), "google.cloud.vision.v1p4beta1.AsyncBatchAnnotateFilesResponse")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.vision.v1p4beta1.InputConfig")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.vision.v1p4beta1.OutputConfig")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.vision.v1p4beta1.GcsSource")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.vision.v1p4beta1.GcsDestination")
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.vision.v1p4beta1.OperationMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/vision/v1p4beta1/image_annotator.proto", fileDescriptor_8288fdc97aa9da03)
}

var fileDescriptor_8288fdc97aa9da03 = []byte{
	// 3262 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5a, 0x41, 0x6f, 0x23, 0xc7,
	0x95, 0x36, 0x49, 0x51, 0x22, 0x1f, 0x29, 0xa9, 0x55, 0x94, 0x34, 0x94, 0x66, 0x34, 0x23, 0xb7,
	0xed, 0x5d, 0xd9, 0xeb, 0x95, 0x30, 0x1a, 0xdb, 0x6b, 0x8f, 0xd7, 0xeb, 0xa5, 0xa8, 0x96, 0xc4,
	0x1d, 0x8a, 0xa4, 0x4b, 0xd4, 0x8c, 0x67, 0xe0, 0x45, 0x6f, 0xab, 0x59, 0xe4, 0xb4, 0xa7, 0xd9,
	0xd5, 0xee, 0x6e, 0xce, 0x48, 0x73, 0x5c, 0x60, 0x0f, 0x7b, 0x58, 0x60, 0x81, 0xdc, 0x73, 0x48,
	0x10, 0x18, 0x08, 0x10, 0xe7, 0x90, 0xfc, 0x83, 0xe4, 0x9c, 0x20, 0xc8, 0x21, 0x40, 0xae, 0xc9,
	0x21, 0x3f, 0x21, 0xc7, 0xa0, 0xaa, 0xab, 0xc9, 0x6a, 0x92, 0x23, 0x8a, 0x33, 0x76, 0x10, 0x20,
	0x27, 0x76, 0xbd, 0x57, 0xdf, 0xf7, 0xaa, 0xde, 0xab, 0x7a, 0xf5, 0xba, 0xd8, 0x70, 0xa7, 0x43,
	0x69, 0xc7, 0x26, 0x3b, 0xa6, 0x4d, 0x7b, 0xad, 0x9d, 0xa7, 0x96, 0x6f, 0x51, 0x67, 0xe7, 0xe9,
	0x6d, 0xf7, 0xbd, 0x33, 0x12, 0x18, 0xb7, 0x77, 0xac, 0xae, 0xd1, 0x21, 0xba, 0xe1, 0x38, 0x34,
	0x30, 0x02, 0xea, 0x6d, 0xbb, 0x1e, 0x0d, 0x28, 0xda, 0x08, 0x41, 0xdb, 0x1c, 0xb4, 0x1d, 0x82,
	0xb6, 0xfb, 0xa0, 0xf5, 0x1b, 0x82, 0xd3, 0x70, 0xad, 0x1d, 0x01, 0xb5, 0xa8, 0xe3, 0x87, 0xe0,
	0xf5, 0x77, 0x2f, 0xb7, 0xd8, 0x21, 0xb4, 0x4b, 0x02, 0xef, 0x42, 0xf4, 0xde, 0xbd, 0xbc, 0xb7,
	0xeb, 0xd1, 0x56, 0xcf, 0x0c, 0x74, 0x9f, 0x18, 0x9e, 0xf9, 0x58, 0x60, 0x26, 0xcc, 0x29, 0x20,
	0xe7, 0x81, 0x3e, 0x18, 0x97, 0x00, 0xdd, 0xbe, 0x1c, 0xf4, 0x8c, 0x9c, 0xe9, 0x2d, 0x12, 0x10,
	0x53, 0x82, 0xbc, 0x21, 0x20, 0x36, 0x75, 0x3a, 0x5e, 0xcf, 0x71, 0x2c, 0xa7, 0xb3, 0x43, 0x5d,
	0xe2, 0xc5, 0xa6, 0xbb, 0x29, 0x3a, 0xf1, 0xd6, 0x59, 0xaf, 0xbd, 0xd3, 0xb6, 0x88, 0xdd, 0xd2,
	0xbb, 0x86, 0xff, 0x44, 0xf4, 0xb8, 0x35, 0xdc, 0x23, 0xb0, 0xba, 0xc4, 0x0f, 0x8c, 0xae, 0x2b,
	0x3a, 0x5c, 0x13, 0x1d, 0x3c, 0xd7, 0xdc, 0xf1, 0x03, 0x23, 0xe8, 0xf9, 0x43, 0x8a, 0xe0, 0xc2,
	0x25, 0x3b, 0x26, 0xb5, 0xa3, 0x00, 0xad, 0x17, 0x65, 0x85, 0x6d, 0x04, 0xb6, 0xd3, 0x09, 0x35,
	0xea, 0xd7, 0x29, 0x98, 0x3b, 0x20, 0x46, 0xd0, 0xf3, 0x08, 0xfa, 0x14, 0x66, 0x58, 0x87, 0x62,
	0x62, 0x33, 0xb1, 0xb5, 0xb0, 0xfb, 0x4f, 0xdb, 0x97, 0x46, 0x75, 0x5b, 0xa0, 0xb6, 0x9b, 0x17,
	0x2e, 0xc1, 0x1c, 0x88, 0x6e, 0x41, 0xae, 0x6b, 0x9c, 0xeb, 0x1e, 0xf1, 0x7b, 0x76, 0xe0, 0x17,
	0x93, 0x9b, 0x89, 0xad, 0x34, 0x86, 0xae, 0x71, 0x8e, 0x43, 0x09, 0x5a, 0x86, 0x74, 0x97, 0xb6,
	0x88, 0x5d, 0x4c, 0x6d, 0x26, 0xb6, 0xb2, 0x38, 0x6c, 0xa8, 0x3f, 0x4c, 0xc2, 0x0c, 0x63, 0x41,
	0xcb, 0xa0, 0x34, 0x1f, 0x36, 0x34, 0xfd, 0xb4, 0x76, 0xd2, 0xd0, 0xca, 0x95, 0x83, 0x8a, 0xb6,
	0xaf, 0xbc, 0x86, 0x10, 0x2c, 0x1c, 0x94, 0xca, 0x9a, 0xbe, 0xaf, 0x35, 0xb5, 0x72, 0xb3, 0x52,
	0xaf, 0x29, 0x09, 0xb4, 0x0a, 0xa8, 0x5a, 0xaa, 0xed, 0x1f, 0x97, 0xf0, 0x3d, 0x49, 0x9e, 0x64,
	0x7d, 0xab, 0xf5, 0xc3, 0xba, 0x24, 0x4b, 0xa1, 0x02, 0x2c, 0x56, 0x4b, 0x7b, 0x5a, 0x55, 0x12,
	0xce, 0xb0, 0x8e, 0x4d, 0xed, 0xf3, 0xa6, 0x24, 0x4b, 0xa3, 0xeb, 0x70, 0x6d, 0xbf, 0x5e, 0x3e,
	0x3d, 0xd6, 0x6a, 0x4d, 0x7d, 0x48, 0x99, 0x43, 0x6b, 0xb0, 0x72, 0x52, 0x3a, 0xd0, 0xf4, 0x13,
	0xad, 0x84, 0xcb, 0x47, 0x92, 0x6a, 0x96, 0x0d, 0xbb, 0x72, 0x5c, 0x3a, 0xd4, 0xf4, 0x06, 0xae,
	0x37, 0x34, 0xdc, 0xac, 0x68, 0x27, 0xca, 0x1c, 0x5a, 0x00, 0x28, 0xe3, 0x7a, 0x43, 0x3f, 0xaa,
	0xd4, 0x9a, 0x27, 0x4a, 0x16, 0x2d, 0xc1, 0xfc, 0x03, 0x6d, 0x4f, 0x02, 0x02, 0x1b, 0x44, 0x03,
	0xd7, 0xf7, 0x4f, 0xcb, 0x4d, 0x41, 0xab, 0xe4, 0xd1, 0x35, 0x28, 0xd4, 0xf7, 0xfe, 0x43, 0x2b,
	0x37, 0xf5, 0x6a, 0xbd, 0x5c, 0xaa, 0x56, 0x1e, 0x95, 0x78, 0xe7, 0x82, 0x5a, 0x83, 0x5c, 0x85,
	0xed, 0xbe, 0x13, 0xda, 0xf3, 0x4c, 0x82, 0x54, 0x98, 0xef, 0x98, 0xbe, 0x1e, 0x6e, 0xc8, 0x9e,
	0x67, 0xf1, 0xa8, 0x65, 0x71, 0xae, 0x63, 0xfa, 0xbc, 0xdb, 0xa9, 0x67, 0xa1, 0xeb, 0x90, 0x1d,
	0xe8, 0x93, 0x5c, 0x9f, 0xb1, 0x84, 0x52, 0x25, 0x90, 0xe6, 0x1d, 0x51, 0x11, 0xe6, 0x4c, 0xea,
	0x04, 0xc4, 0x09, 0x38, 0x47, 0x1e, 0x47, 0x4d, 0xb4, 0x07, 0xb3, 0x3e, 0xb7, 0xc6, 0xc1, 0xb9,
	0xdd, 0x77, 0x26, 0x2c, 0x09, 0x69, 0x7c, 0x58, 0x20, 0xd5, 0x1f, 0x29, 0xb0, 0x70, 0x60, 0x98,
	0xa4, 0xd4, 0xdf, 0x60, 0xa8, 0x01, 0xf3, 0x67, 0xb4, 0xe7, 0xb4, 0x2c, 0xa7, 0xa3, 0xbb, 0xd4,
	0xbe, 0xe0, 0x66, 0x73, 0x13, 0x17, 0xdc, 0x9e, 0xc0, 0x34, 0xa8, 0x7d, 0x81, 0xf3, 0x67, 0x52,
	0x0b, 0x9d, 0x82, 0xd2, 0x6e, 0xe9, 0x71, 0xd2, 0xe4, 0xf4, 0xa4, 0x0b, 0xed, 0x96, 0xdc, 0x46,
	0x4d, 0xc8, 0xda, 0x86, 0xd3, 0xea, 0x1a, 0xde, 0x13, 0xbf, 0x98, 0xda, 0x4c, 0x6d, 0xe5, 0x76,
	0x3f, 0x98, 0xb4, 0x2b, 0x62, 0x53, 0xdd, 0xae, 0x0a, 0x38, 0x1e, 0x10, 0xa1, 0x0d, 0x00, 0x8f,
	0xda, 0xb6, 0x6e, 0x38, 0x1d, 0x9b, 0x14, 0x67, 0x36, 0x13, 0x5b, 0x49, 0x9c, 0x65, 0x92, 0x12,
	0x13, 0xb0, 0xa0, 0xb9, 0x86, 0x23, 0xb4, 0x69, 0xae, 0xcd, 0xb8, 0x86, 0x13, 0x2a, 0x37, 0x00,
	0x02, 0xcb, 0x0e, 0x84, 0x76, 0x36, 0xc4, 0x32, 0x49, 0xa8, 0xbe, 0x0d, 0xcb, 0xfd, 0xa4, 0xa4,
	0x9b, 0xd4, 0x69, 0x5b, 0x2d, 0xe2, 0x98, 0xa4, 0x38, 0xc7, 0x3b, 0x16, 0xfa, 0xba, 0x72, 0x5f,
	0x85, 0xde, 0x87, 0xd5, 0x68, 0x68, 0xcc, 0x75, 0x12, 0x28, 0xc3, 0x41, 0x2b, 0x92, 0x56, 0x82,
	0x35, 0x60, 0xe1, 0x4b, 0x7a, 0xa1, 0xdb, 0xd6, 0x13, 0x62, 0x5b, 0x8f, 0x29, 0x6d, 0x15, 0xb3,
	0x3c, 0x6b, 0xbc, 0x3d, 0xc1, 0x3f, 0xd5, 0x3e, 0x00, 0xcf, 0x7f, 0x49, 0x2f, 0x06, 0x4d, 0x74,
	0x1f, 0x96, 0x7c, 0xea, 0x79, 0xf4, 0x99, 0x4c, 0x0a, 0xd3, 0x92, 0x2a, 0x21, 0x87, 0xc4, 0xdb,
	0x04, 0xc5, 0x70, 0x3a, 0xc4, 0x93, 0x69, 0x73, 0xd3, 0xd2, 0x2e, 0x72, 0x0a, 0x89, 0xf5, 0x11,
	0x14, 0xfc, 0x9e, 0xe7, 0x7a, 0x96, 0x4f, 0x64, 0xe2, 0xfc, 0xb4, 0xc4, 0x28, 0x62, 0x91, 0xb8,
	0x4d, 0x28, 0xf6, 0x9c, 0x16, 0xf1, 0x74, 0x72, 0xee, 0x52, 0x9f, 0xb4, 0x64, 0x03, 0xf3, 0xd3,
	0x1a, 0x58, 0xe5, 0x54, 0x5a, 0xc8, 0x24, 0x19, 0xf9, 0x1c, 0xd0, 0x99, 0xdd, 0xf3, 0xbc, 0x38,
	0xfd, 0xc2, 0xb4, 0xf4, 0x4b, 0x82, 0x24, 0xee, 0x9a, 0xc7, 0xc4, 0x68, 0x3d, 0x23, 0x46, 0xcc,
	0xe7, 0x8b, 0x53, 0xbb, 0x26, 0x62, 0x19, 0xc8, 0xd6, 0x7f, 0x37, 0x07, 0x99, 0x68, 0x4f, 0xa1,
	0xba, 0x38, 0xaf, 0x52, 0x9c, 0xf9, 0xe3, 0x97, 0xdb, 0x99, 0xf2, 0xf9, 0x55, 0x86, 0x8c, 0x4b,
	0x7d, 0x8b, 0xe9, 0xf9, 0xbe, 0xcc, 0xed, 0xfe, 0xe3, 0x04, 0xd2, 0x86, 0xe8, 0x8e, 0xfb, 0x40,
	0xf5, 0xe7, 0xb3, 0x83, 0xd3, 0xec, 0xb4, 0x76, 0xaf, 0x56, 0x7f, 0x50, 0xd3, 0xa3, 0xb3, 0x4a,
	0x79, 0x0d, 0xe5, 0x21, 0x53, 0xd5, 0x0e, 0x9a, 0xba, 0xf6, 0x50, 0x53, 0x12, 0x68, 0x1e, 0xb2,
	0xb8, 0x72, 0x78, 0x14, 0x36, 0x93, 0xa8, 0x08, 0xcb, 0x5c, 0x59, 0x3f, 0xd0, 0xa3, 0x4e, 0x7b,
	0xb8, 0xfe, 0x40, 0x49, 0xb1, 0xe3, 0x27, 0xec, 0x38, 0xac, 0x9a, 0x61, 0xaa, 0x08, 0xd4, 0xe7,
	0xe2, 0xaa, 0x34, 0x5a, 0x87, 0xd5, 0x3e, 0x2a, 0xae, 0x9b, 0x65, 0xb0, 0xe3, 0xca, 0x7e, 0xa3,
	0x5e, 0xa9, 0x35, 0xf5, 0x3d, 0xad, 0xf9, 0x40, 0xd3, 0x6a, 0x4c, 0xcb, 0x8e, 0xae, 0x3c, 0x64,
	0x6a, 0xf5, 0x13, 0x4d, 0x6f, 0x56, 0x1a, 0x4a, 0x86, 0x8d, 0xf1, 0xb4, 0xd1, 0xd0, 0xb0, 0x5e,
	0xad, 0x34, 0x94, 0x2c, 0x6b, 0x56, 0xeb, 0x0f, 0x44, 0x13, 0xd8, 0x31, 0x77, 0x5c, 0x3f, 0x6d,
	0x1e, 0xf1, 0x51, 0x29, 0x39, 0xb4, 0x08, 0xb9, 0xb0, 0xcd, 0xed, 0x29, 0x79, 0xa4, 0x40, 0x3e,
	0x14, 0x94, 0xb5, 0x5a, 0x53, 0xc3, 0xca, 0x3c, 0x5a, 0x81, 0x25, 0x4e, 0xbf, 0x57, 0x6f, 0x36,
	0xeb, 0xc7, 0xa2, 0xe3, 0x02, 0xf3, 0x97, 0x2c, 0xe6, 0x7c, 0x8b, 0xec, 0xa4, 0x97, 0xa5, 0x82,
	0x44, 0xe9, 0xcf, 0x5a, 0x7b, 0xa8, 0xe9, 0xcd, 0x7a, 0x43, 0xdf, 0xab, 0x9f, 0xd6, 0xf6, 0x4b,
	0xf8, 0xa1, 0xb2, 0x14, 0x53, 0x85, 0xb3, 0x2e, 0xd7, 0x71, 0x4d, 0xc3, 0x0a, 0x42, 0x37, 0xa0,
	0xd8, 0x57, 0x09, 0xc6, 0x3e, 0xb0, 0xd0, 0x77, 0x3f, 0xd3, 0xf2, 0x07, 0x81, 0x5b, 0x1e, 0x38,
	0x72, 0xc4, 0xdc, 0x4a, 0x5c, 0x17, 0xb3, 0xb7, 0x8a, 0x36, 0x60, 0x6d, 0xa0, 0x1b, 0x36, 0x78,
	0x6d, 0x10, 0xd5, 0x61, 0x8b, 0x45, 0x74, 0x0b, 0xae, 0xcb, 0x71, 0xd6, 0xc3, 0x10, 0x44, 0x11,
	0x53, 0xd6, 0xd0, 0x26, 0xdc, 0x88, 0x85, 0x74, 0xb8, 0xc7, 0x3a, 0x73, 0x68, 0x48, 0x51, 0xc2,
	0x7a, 0x13, 0x97, 0x0e, 0x59, 0x1d, 0x71, 0x9d, 0x79, 0x5f, 0xe0, 0x24, 0xf1, 0x0d, 0x5e, 0x39,
	0x45, 0x73, 0x6f, 0x9c, 0x36, 0x2a, 0x55, 0x65, 0x83, 0x55, 0x4e, 0x83, 0xe1, 0x85, 0xc2, 0x9b,
	0x0c, 0x7f, 0x50, 0xc7, 0xda, 0x91, 0x56, 0xda, 0xd7, 0x0f, 0x79, 0x61, 0x55, 0x2d, 0x29, 0xb7,
	0x58, 0x79, 0x53, 0x3e, 0xaa, 0xd4, 0xf4, 0xc3, 0x5a, 0xa9, 0x79, 0xc4, 0x28, 0x37, 0x99, 0x7d,
	0x2e, 0xe2, 0xbc, 0x87, 0xf5, 0x1a, 0x93, 0xbe, 0xce, 0xf0, 0x5c, 0x1a, 0x32, 0x0b, 0xb1, 0xaa,
	0xfe, 0x2b, 0xe4, 0xab, 0xd4, 0xe4, 0x7b, 0xb3, 0xe2, 0xb4, 0x29, 0x7a, 0x17, 0xe6, 0x6c, 0x23,
	0xd0, 0x6d, 0xa7, 0x23, 0xca, 0x83, 0x42, 0xb4, 0x15, 0xd9, 0x56, 0xdd, 0xae, 0x1a, 0x41, 0xd5,
	0xe9, 0xe0, 0x59, 0x9b, 0xff, 0xaa, 0x0f, 0x20, 0xd3, 0xf0, 0x58, 0xad, 0x1d, 0x5c, 0x20, 0x04,
	0x33, 0x8e, 0xd1, 0x25, 0xa2, 0x20, 0xe2, 0xcf, 0xac, 0xf0, 0x7c, 0x6a, 0xd8, 0x3d, 0x22, 0xaa,
	0xa0, 0xb0, 0x81, 0x5e, 0x87, 0x7c, 0xcf, 0x72, 0x82, 0x0f, 0xde, 0xd3, 0x43, 0x25, 0x4b, 0x24,
	0x33, 0x38, 0x17, 0xca, 0xee, 0x33, 0x91, 0xfa, 0xfd, 0x14, 0x28, 0x9a, 0x13, 0x58, 0xc1, 0x85,
	0x54, 0xc0, 0x28, 0x90, 0xea, 0x5a, 0x2d, 0x61, 0x80, 0x3d, 0xa2, 0x55, 0x98, 0xb5, 0xa9, 0x69,
	0xd8, 0x91, 0x01, 0xd1, 0x42, 0x9b, 0x90, 0x6b, 0x11, 0xdf, 0xf4, 0x2c, 0x97, 0x27, 0x95, 0xb0,
	0xec, 0x95, 0x45, 0x6c, 0x64, 0xbe, 0x49, 0xbd, 0xa8, 0x10, 0x08, 0x1b, 0x48, 0x05, 0x90, 0x4e,
	0x62, 0x5e, 0x05, 0xec, 0x25, 0x8b, 0x09, 0x2c, 0x49, 0xd1, 0x4d, 0x80, 0x80, 0xba, 0x96, 0x69,
	0xd8, 0x56, 0x70, 0x21, 0x6a, 0x01, 0x49, 0x32, 0x5a, 0x66, 0xcd, 0xbd, 0x6a, 0x99, 0x55, 0x81,
	0xac, 0x2d, 0x62, 0xe4, 0x17, 0x33, 0xbc, 0x1e, 0x9a, 0xc4, 0x26, 0xc7, 0x14, 0x0f, 0xd0, 0xe8,
	0x10, 0xc0, 0x0d, 0x03, 0x66, 0x11, 0xbf, 0x98, 0xe5, 0x5c, 0x13, 0x93, 0xad, 0x88, 0x30, 0x96,
	0xa0, 0xea, 0xaf, 0x12, 0xb0, 0xc6, 0x8c, 0xd8, 0xd6, 0x73, 0xd2, 0xaa, 0x9f, 0x7d, 0x49, 0xcc,
	0xe0, 0xd2, 0x48, 0xbd, 0x01, 0xf3, 0xb6, 0xe1, 0x74, 0x7a, 0xac, 0x2c, 0x36, 0x69, 0x2b, 0x0a,
	0x58, 0x3e, 0x12, 0x96, 0x69, 0x8b, 0xf4, 0x97, 0x50, 0x2a, 0xbe, 0x84, 0xc6, 0x04, 0x6a, 0xc4,
	0xc9, 0xe9, 0x57, 0x74, 0xb2, 0xfa, 0x87, 0x24, 0x2c, 0x9f, 0x18, 0x6d, 0x72, 0xc2, 0x5f, 0x61,
	0xa5, 0xb9, 0x7c, 0x0a, 0x69, 0xa3, 0xd5, 0xb3, 0x03, 0xf1, 0x7e, 0x36, 0xc5, 0x49, 0x1a, 0xe2,
	0x18, 0x81, 0xef, 0x52, 0xda, 0xe6, 0x53, 0x9e, 0x8e, 0x80, 0xe3, 0x50, 0x19, 0xe6, 0xba, 0xa4,
	0xc5, 0xd6, 0x97, 0x38, 0x73, 0xa7, 0xa0, 0x88, 0x90, 0x48, 0x83, 0xcc, 0x53, 0x8b, 0xda, 0x7c,
	0x61, 0xcf, 0x4c, 0xcb, 0xd2, 0x87, 0xa2, 0x4f, 0x60, 0xc6, 0x33, 0xcc, 0x8b, 0xe9, 0xcb, 0x4e,
	0x0e, 0x53, 0x9f, 0x41, 0x8e, 0xa5, 0x10, 0xea, 0x74, 0x30, 0x31, 0x03, 0x74, 0x07, 0x72, 0x5d,
	0xcb, 0xd1, 0xaf, 0x90, 0x71, 0xb2, 0x5d, 0xcb, 0x09, 0x1f, 0x39, 0xc8, 0x38, 0xef, 0x83, 0x92,
	0x97, 0x81, 0x8c, 0xf3, 0xf0, 0x51, 0xf5, 0x20, 0x5b, 0x66, 0x6f, 0xe6, 0x3c, 0xc9, 0x6d, 0x41,
	0x9a, 0xbf, 0xa6, 0x0b, 0x83, 0x28, 0x86, 0xe5, 0xdd, 0x70, 0xd8, 0x61, 0xb0, 0xfa, 0x92, 0xf2,
	0xea, 0x7b, 0x0b, 0x16, 0x5c, 0xeb, 0x9c, 0xd8, 0x7a, 0xdb, 0x33, 0xcc, 0x7e, 0x86, 0x49, 0xe2,
	0x79, 0x2e, 0x3d, 0x10, 0x42, 0xf5, 0x0b, 0x28, 0xee, 0xd3, 0xae, 0xe5, 0x18, 0x4e, 0xc0, 0x49,
	0x7d, 0x69, 0x55, 0xfd, 0x3b, 0xcc, 0x72, 0x0b, 0x7e, 0x31, 0xc1, 0x37, 0xe1, 0xd6, 0x04, 0x4f,
	0xf6, 0x07, 0x8f, 0x05, 0x4e, 0xf5, 0x61, 0x91, 0xbf, 0xf8, 0x35, 0xfa, 0x9b, 0x12, 0xfd, 0x17,
	0x2c, 0xb6, 0x84, 0x41, 0xbd, 0xcf, 0xce, 0x66, 0xf8, 0x2f, 0x13, 0xd8, 0x5f, 0x34, 0x4c, 0xbc,
	0xd0, 0x8a, 0x69, 0xd4, 0x9f, 0x24, 0x20, 0x53, 0xf6, 0xa8, 0x7b, 0x64, 0x39, 0xc1, 0x77, 0xf0,
	0x42, 0x79, 0x33, 0x96, 0x7f, 0x43, 0x9f, 0xcb, 0xb9, 0x77, 0x07, 0x0a, 0x56, 0xd7, 0xa5, 0x5e,
	0x60, 0x38, 0x26, 0x19, 0xf6, 0x3e, 0x1a, 0xa8, 0xfa, 0x21, 0xf8, 0x4f, 0x28, 0x44, 0xc3, 0x95,
	0xbd, 0x7f, 0x00, 0x60, 0x7a, 0xd4, 0xd5, 0x1f, 0x33, 0xb9, 0x88, 0xc0, 0xa4, 0x34, 0x18, 0xf1,
	0xe0, 0xac, 0x19, 0x31, 0xaa, 0x1f, 0xc0, 0x62, 0x9f, 0xbe, 0x61, 0x78, 0x46, 0xd7, 0x67, 0x89,
	0xce, 0xf0, 0x5d, 0x62, 0x06, 0x3a, 0xbf, 0x80, 0x0a, 0xd9, 0x93, 0x38, 0x1f, 0x0a, 0x31, 0x97,
	0xa9, 0xfb, 0x80, 0x1e, 0x90, 0xb3, 0xfd, 0xe8, 0xbd, 0x50, 0x40, 0xb7, 0xa1, 0x60, 0x39, 0xa6,
	0xdd, 0x6b, 0x11, 0xbd, 0x43, 0x68, 0xec, 0x3e, 0x27, 0x83, 0x97, 0x84, 0xea, 0x90, 0x50, 0x71,
	0xad, 0xa3, 0x7e, 0x93, 0x82, 0x3c, 0x5f, 0x02, 0x65, 0xea, 0x04, 0xe4, 0x3c, 0x40, 0x35, 0x96,
	0x64, 0x03, 0xdd, 0xa6, 0x4e, 0x47, 0xf7, 0x88, 0x19, 0x88, 0x80, 0x4c, 0xba, 0x3f, 0x90, 0x76,
	0x24, 0xce, 0xd9, 0xd2, 0xf6, 0x7c, 0x0b, 0x16, 0xfa, 0x49, 0x3b, 0x74, 0x55, 0x72, 0x33, 0xb5,
	0x95, 0xc5, 0xfd, 0x54, 0xce, 0x27, 0x8e, 0x1e, 0xc1, 0xd2, 0xc0, 0x9b, 0xba, 0xcb, 0x27, 0x23,
	0x0a, 0xf9, 0xed, 0x2b, 0x3a, 0x55, 0x78, 0x0f, 0x2f, 0x9a, 0x43, 0xee, 0x6c, 0xc3, 0x4a, 0xfc,
	0x72, 0x31, 0xe2, 0x0f, 0x13, 0xfe, 0xee, 0xe4, 0xb3, 0x8b, 0x61, 0xc3, 0xa4, 0x2e, 0x6c, 0x14,
	0xdc, 0x51, 0x21, 0x32, 0x61, 0x39, 0x76, 0xb7, 0x18, 0x99, 0x99, 0xe5, 0x66, 0x6e, 0x4f, 0x30,
	0x33, 0x1a, 0x4c, 0x8c, 0x9e, 0x8d, 0xc8, 0xd4, 0x3f, 0x25, 0x60, 0x59, 0xac, 0x42, 0xc2, 0x03,
	0x87, 0xc9, 0x57, 0x3d, 0xe2, 0x07, 0xe8, 0x2e, 0xa4, 0xf9, 0x05, 0x91, 0x08, 0xd8, 0x9b, 0x57,
	0xb9, 0xf0, 0xc1, 0x21, 0x04, 0xed, 0x41, 0xa6, 0x1d, 0xde, 0x09, 0x86, 0xe1, 0xc9, 0xed, 0xfe,
	0xc3, 0xd5, 0xae, 0x10, 0x71, 0x1f, 0xc7, 0x76, 0x72, 0x78, 0x63, 0x65, 0x86, 0x2b, 0x89, 0xef,
	0xa8, 0xc9, 0x3b, 0x59, 0x5e, 0x7c, 0x38, 0x6f, 0x49, 0x2d, 0xf5, 0x1e, 0xac, 0x72, 0xed, 0x60,
	0xd3, 0x45, 0x8b, 0x54, 0x81, 0xd4, 0xe0, 0xde, 0x8c, 0x3d, 0xa2, 0x5b, 0x90, 0x73, 0x99, 0x71,
	0xa7, 0xd7, 0x3d, 0x23, 0x5e, 0x74, 0x7f, 0xc9, 0x44, 0x35, 0x2e, 0x51, 0x7f, 0x01, 0xb0, 0x32,
	0xe4, 0x37, 0xdf, 0xa5, 0x8e, 0x4f, 0xd0, 0xe7, 0xa0, 0xb4, 0x0d, 0x93, 0x48, 0xf7, 0xc8, 0xd1,
	0x76, 0xfe, 0xe7, 0xa9, 0xde, 0x4b, 0xf1, 0x62, 0x3b, 0xd6, 0xf6, 0xd1, 0x19, 0x2c, 0x47, 0x57,
	0x30, 0x31, 0xf6, 0xd0, 0xc5, 0x3b, 0x13, 0xd8, 0x87, 0x6b, 0x57, 0x5c, 0x88, 0xc8, 0x64, 0x1b,
	0x8f, 0x40, 0xb1, 0x69, 0x87, 0xc6, 0xf8, 0x53, 0x2f, 0xc7, 0xbf, 0xc8, 0x88, 0x64, 0xee, 0x2f,
	0x60, 0xc9, 0x36, 0xce, 0x88, 0x1d, 0x23, 0x9f, 0x79, 0x39, 0x72, 0x85, 0x33, 0xc9, 0xec, 0xcf,
	0xe1, 0x86, 0x1d, 0x55, 0x7f, 0x3a, 0xe5, 0xe5, 0x5f, 0xcc, 0xd0, 0x2a, 0x37, 0xf4, 0xe1, 0x15,
	0xaa, 0xd4, 0xb1, 0x05, 0x24, 0x5e, 0xb7, 0x5f, 0xa4, 0xe2, 0x5e, 0x1b, 0xfa, 0xef, 0x80, 0x65,
	0x83, 0x97, 0xf3, 0x1a, 0x23, 0x92, 0xb9, 0x75, 0x58, 0x6e, 0xf7, 0x6c, 0x5b, 0x1f, 0x32, 0xc0,
	0x2f, 0x98, 0x26, 0xaf, 0xa9, 0x66, 0x8c, 0x0d, 0x23, 0x46, 0x15, 0x97, 0x21, 0x0b, 0x56, 0x7d,
	0xa3, 0x4d, 0xa2, 0x64, 0x26, 0x99, 0x08, 0x33, 0xcd, 0x9d, 0x09, 0x26, 0xc6, 0x95, 0xa8, 0x78,
	0xd9, 0x1f, 0x57, 0xb8, 0x3a, 0x70, 0x3d, 0xdc, 0xd4, 0x83, 0xb2, 0x5d, 0xb6, 0x97, 0xb9, 0x52,
	0x82, 0x1e, 0x2a, 0x31, 0xf0, 0x9a, 0x15, 0x17, 0x48, 0xf6, 0xda, 0xb0, 0x22, 0x1d, 0x03, 0x92,
	0xa5, 0xdc, 0x95, 0x52, 0xf5, 0x98, 0x73, 0x1a, 0x17, 0xcc, 0x31, 0x87, 0x77, 0x03, 0xe6, 0x63,
	0xa9, 0x9a, 0x5f, 0xce, 0x4d, 0x4e, 0x56, 0x72, 0x8e, 0xc6, 0x79, 0x39, 0x3b, 0xb3, 0xa0, 0x0c,
	0x1d, 0x32, 0xd1, 0xd9, 0xbb, 0x70, 0xa5, 0xa0, 0xc4, 0x4e, 0x19, 0x71, 0x3a, 0xe3, 0x65, 0x77,
	0x8c, 0x94, 0x95, 0x9e, 0xc4, 0xf3, 0xa8, 0xc7, 0x0b, 0x68, 0xa9, 0xf4, 0xf4, 0x5c, 0x73, 0xfb,
	0x84, 0xff, 0xa9, 0x84, 0xc3, 0x0e, 0xa8, 0x2e, 0xfe, 0x1f, 0x38, 0x0f, 0x8a, 0x2b, 0xbc, 0xef,
	0xfb, 0x57, 0x09, 0xd5, 0x48, 0xbe, 0xc5, 0x11, 0x8b, 0xfa, 0x7b, 0xe9, 0xf4, 0x39, 0xb0, 0xec,
	0x41, 0x12, 0x3d, 0x86, 0xbc, 0xe5, 0xb8, 0xbd, 0x20, 0xbc, 0x85, 0xee, 0x5c, 0xb1, 0x6a, 0xa8,
	0x30, 0x08, 0xbf, 0x9a, 0xee, 0xe0, 0x9c, 0x35, 0x68, 0x20, 0x0c, 0x59, 0x4f, 0x50, 0x47, 0xe9,
	0xf2, 0xbd, 0x09, 0x5c, 0x63, 0x93, 0x3b, 0x1e, 0xd0, 0xb0, 0x23, 0x22, 0xa0, 0x81, 0x61, 0xeb,
	0xec, 0x54, 0xf0, 0xf9, 0xf1, 0x94, 0x66, 0x6f, 0xdd, 0x81, 0x61, 0x37, 0x98, 0x44, 0xed, 0xc2,
	0xfa, 0x9e, 0x11, 0xf4, 0xd7, 0x7f, 0xc8, 0xe4, 0x47, 0xe7, 0x6b, 0x1d, 0x32, 0x5e, 0xf8, 0x18,
	0x1d, 0x0f, 0x77, 0xa6, 0x1b, 0x11, 0xc7, 0xe2, 0x3e, 0x89, 0xfa, 0x15, 0x5c, 0x1f, 0x6b, 0x4e,
	0x78, 0x34, 0xe6, 0x82, 0xc4, 0xb7, 0xe2, 0x02, 0xf5, 0xff, 0x93, 0x50, 0x88, 0x87, 0x2f, 0x9c,
	0xdb, 0xb7, 0x1c, 0xbd, 0xbf, 0xc9, 0x72, 0x82, 0xbd, 0x87, 0x85, 0x91, 0x67, 0x27, 0x58, 0x1a,
	0x87, 0x0d, 0xf5, 0x09, 0xac, 0xc5, 0xa2, 0xc0, 0xdc, 0xd2, 0x8f, 0x79, 0x6d, 0x24, 0xe6, 0xbb,
	0x57, 0x0c, 0x81, 0xe4, 0x5d, 0x29, 0xe4, 0x74, 0x68, 0x85, 0x09, 0x63, 0x22, 0xe2, 0x9f, 0x8d,
	0x46, 0xfc, 0xce, 0x54, 0xe6, 0x46, 0x03, 0xfe, 0x9b, 0x24, 0x14, 0x4b, 0xfe, 0x85, 0x63, 0xfe,
	0xdd, 0x46, 0xbd, 0x01, 0xf3, 0xb4, 0x17, 0x48, 0xb3, 0x9c, 0xb9, 0x12, 0x63, 0x9d, 0x63, 0xc4,
	0x34, 0xf3, 0x54, 0x6a, 0xa9, 0x5d, 0x58, 0x1b, 0xe3, 0x52, 0x11, 0xc3, 0x11, 0x73, 0x89, 0x57,
	0x35, 0xf7, 0xcb, 0x04, 0xdc, 0xe2, 0xf6, 0xfe, 0x8a, 0xb9, 0x69, 0x74, 0x1a, 0xc9, 0x57, 0x9d,
	0x46, 0x00, 0x9b, 0x2f, 0x9e, 0xc5, 0x77, 0xe6, 0xbc, 0x1e, 0xdc, 0x1c, 0xb5, 0x1a, 0xdb, 0xe2,
	0x27, 0x23, 0xae, 0x9b, 0x74, 0xd1, 0xf1, 0xa2, 0xfd, 0x24, 0xed, 0xf3, 0x8b, 0x71, 0x21, 0x8b,
	0x6f, 0xf6, 0xfb, 0xa3, 0x9b, 0xfd, 0xc3, 0xe9, 0x0d, 0x8f, 0xee, 0xf8, 0xff, 0x4b, 0x40, 0x4e,
	0xda, 0xa2, 0xe8, 0x10, 0xa0, 0x63, 0xfa, 0xba, 0xf8, 0x18, 0x20, 0x74, 0xe8, 0xa4, 0x8b, 0xa2,
	0x43, 0xd3, 0x17, 0x9f, 0x02, 0x64, 0x3b, 0xd1, 0xa3, 0xfc, 0xad, 0x41, 0x2a, 0xfe, 0xad, 0xc1,
	0x75, 0xc8, 0x76, 0xad, 0x2e, 0xd1, 0xf9, 0x3f, 0x7a, 0xe2, 0x5b, 0x05, 0x26, 0x68, 0x5e, 0xb8,
	0x44, 0xfd, 0x9f, 0x04, 0xe4, 0xe5, 0x00, 0xa1, 0xfb, 0xb0, 0xc8, 0x06, 0xd4, 0x22, 0x7e, 0x60,
	0x39, 0x61, 0x71, 0x97, 0xb8, 0x52, 0x65, 0x7c, 0x68, 0xfa, 0xfb, 0x03, 0x10, 0x5e, 0xe8, 0xc4,
	0xda, 0x68, 0x03, 0xe0, 0x8c, 0xb9, 0x5b, 0xf7, 0xad, 0xe7, 0x44, 0xbc, 0x00, 0x66, 0xb9, 0xe4,
	0xc4, 0x7a, 0x4e, 0xd4, 0x0d, 0xc8, 0xf6, 0xa7, 0x35, 0xfa, 0xfe, 0xa8, 0xaa, 0xb0, 0x10, 0xe7,
	0x1f, 0xd3, 0xe7, 0x9b, 0x24, 0x2c, 0xd5, 0xa3, 0x8f, 0x82, 0x8e, 0x49, 0x60, 0xb4, 0x8c, 0xc0,
	0x40, 0x55, 0x48, 0xfb, 0x2c, 0x20, 0xe2, 0x6e, 0x77, 0xd2, 0x57, 0x06, 0x23, 0x04, 0xbc, 0x64,
	0x23, 0x38, 0x24, 0x41, 0x1f, 0x43, 0xce, 0xf4, 0x88, 0x11, 0x10, 0x3d, 0xb0, 0xba, 0x44, 0xdc,
	0x50, 0xac, 0x47, 0x9c, 0xd1, 0x77, 0x45, 0xdb, 0xcd, 0xe8, 0xbb, 0x22, 0x0c, 0x61, 0x77, 0x26,
	0x60, 0xe0, 0x9e, 0xdb, 0xea, 0x83, 0x67, 0x27, 0x83, 0xc3, 0xee, 0x4c, 0xa0, 0x7e, 0x06, 0x69,
	0x3e, 0x12, 0xb4, 0x02, 0x4b, 0x27, 0xcd, 0x52, 0x73, 0xf8, 0x5b, 0x9e, 0x1c, 0xcc, 0x95, 0xb1,
	0x56, 0x6a, 0x6a, 0xfb, 0x4a, 0x82, 0x35, 0xf0, 0x69, 0xad, 0x56, 0xa9, 0x1d, 0x2a, 0x49, 0x94,
	0x81, 0x99, 0xfd, 0x7a, 0x4d, 0x53, 0x52, 0x68, 0x1e, 0xb2, 0xe5, 0x52, 0xad, 0xac, 0x55, 0xab,
	0xda, 0xbe, 0x32, 0xf3, 0x0e, 0x01, 0x90, 0xfe, 0x5c, 0xce, 0xc1, 0x9c, 0xf8, 0x53, 0x55, 0x79,
	0x0d, 0x2d, 0xc1, 0xfc, 0x7d, 0x0d, 0x3f, 0xd4, 0x4f, 0x6b, 0xd5, 0xca, 0x3d, 0xad, 0xfa, 0x50,
	0x49, 0xa0, 0x3c, 0x64, 0xfa, 0xad, 0x24, 0x6b, 0x35, 0xea, 0x27, 0x27, 0x95, 0xbd, 0x2a, 0x23,
	0x06, 0x98, 0x15, 0x9a, 0x19, 0xb4, 0x08, 0x39, 0x0e, 0x15, 0x82, 0xf4, 0xee, 0xaf, 0xd3, 0xb0,
	0x20, 0x17, 0xae, 0xd4, 0x43, 0x3f, 0x4b, 0x40, 0x61, 0x4c, 0xa6, 0x41, 0x1f, 0x4d, 0xba, 0x57,
	0x7c, 0x61, 0x8e, 0x5d, 0xbf, 0xfb, 0x32, 0xd0, 0x70, 0x57, 0xaa, 0x6f, 0xfd, 0xf7, 0x6f, 0xff,
	0xf8, 0xbd, 0xe4, 0x2d, 0x75, 0x7d, 0xf8, 0x7b, 0x3c, 0xff, 0xae, 0x78, 0xc7, 0x21, 0x77, 0x13,
	0xef, 0xa0, 0x9f, 0x26, 0x00, 0x8d, 0xa6, 0x0c, 0xf4, 0xe1, 0x34, 0x96, 0xe5, 0xe4, 0xb6, 0xfe,
	0xd1, 0x4b, 0x20, 0xc5, 0x90, 0xdf, 0xe4, 0x43, 0xbe, 0xa9, 0xae, 0x49, 0x43, 0x6e, 0xb3, 0x1e,
	0xb1, 0x11, 0xff, 0x38, 0x21, 0xea, 0x8b, 0x71, 0xce, 0xfe, 0xb7, 0xab, 0xe4, 0xb3, 0x4b, 0x3c,
	0xbe, 0x11, 0xe1, 0xa5, 0xaf, 0xf2, 0x06, 0xfb, 0x47, 0xdd, 0xe1, 0x23, 0x7c, 0x5b, 0x7d, 0x73,
	0x8c, 0x53, 0x47, 0x98, 0xd9, 0x60, 0xbf, 0x4e, 0xc0, 0xb5, 0x17, 0xa4, 0x65, 0xf4, 0xc9, 0xd4,
	0x63, 0x8d, 0x39, 0x7a, 0xc2, 0x50, 0xb7, 0xf9, 0x50, 0xb7, 0xd4, 0x37, 0x46, 0x9d, 0x39, 0x6e,
	0xa4, 0x7b, 0xff, 0x9b, 0x80, 0xd7, 0x4d, 0xda, 0xbd, 0x7c, 0x4c, 0x7b, 0x85, 0xf8, 0xa2, 0x6f,
	0xb0, 0xfd, 0xdd, 0x48, 0x3c, 0x2a, 0x0b, 0x54, 0x87, 0xda, 0x86, 0xd3, 0xd9, 0xa6, 0x5e, 0x67,
	0xa7, 0x43, 0x1c, 0xbe, 0xfb, 0x77, 0x42, 0x95, 0xe1, 0x5a, 0xfe, 0x0b, 0xbe, 0x8e, 0xfc, 0x38,
	0x14, 0xfc, 0x39, 0x91, 0xf8, 0x41, 0x72, 0xe6, 0xb0, 0x7c, 0xbf, 0x76, 0x36, 0xcb, 0x91, 0x77,
	0xfe, 0x12, 0x00, 0x00, 0xff, 0xff, 0x60, 0xef, 0x71, 0x29, 0x5f, 0x2a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ImageAnnotatorClient is the client API for ImageAnnotator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
	// Service that performs image detection and annotation for a batch of files.
	// Now only "application/pdf", "image/tiff" and "image/gif" are supported.
	//
	// This service will extract at most 5 (customers can specify which 5 in
	// AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each
	// file provided and perform detection and annotation for each image
	// extracted.
	BatchAnnotateFiles(ctx context.Context, in *BatchAnnotateFilesRequest, opts ...grpc.CallOption) (*BatchAnnotateFilesResponse, error)
	// Run asynchronous image detection and annotation for a list of images.
	//
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateImagesResponse` (results).
	//
	// This service will write image annotation outputs to json files in customer
	// GCS bucket, each json file containing BatchAnnotateImagesResponse proto.
	AsyncBatchAnnotateImages(ctx context.Context, in *AsyncBatchAnnotateImagesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Run asynchronous image detection and annotation for a list of generic
	// files, such as PDF files, which may contain multiple pages and multiple
	// images per page. Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type imageAnnotatorClient struct {
	cc *grpc.ClientConn
}

func NewImageAnnotatorClient(cc *grpc.ClientConn) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1p4beta1.ImageAnnotator/BatchAnnotateImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) BatchAnnotateFiles(ctx context.Context, in *BatchAnnotateFilesRequest, opts ...grpc.CallOption) (*BatchAnnotateFilesResponse, error) {
	out := new(BatchAnnotateFilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1p4beta1.ImageAnnotator/BatchAnnotateFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateImages(ctx context.Context, in *AsyncBatchAnnotateImagesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1p4beta1.ImageAnnotator/AsyncBatchAnnotateImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1p4beta1.ImageAnnotator/AsyncBatchAnnotateFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageAnnotatorServer is the server API for ImageAnnotator service.
type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
	// Service that performs image detection and annotation for a batch of files.
	// Now only "application/pdf", "image/tiff" and "image/gif" are supported.
	//
	// This service will extract at most 5 (customers can specify which 5 in
	// AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each
	// file provided and perform detection and annotation for each image
	// extracted.
	BatchAnnotateFiles(context.Context, *BatchAnnotateFilesRequest) (*BatchAnnotateFilesResponse, error)
	// Run asynchronous image detection and annotation for a list of images.
	//
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateImagesResponse` (results).
	//
	// This service will write image annotation outputs to json files in customer
	// GCS bucket, each json file containing BatchAnnotateImagesResponse proto.
	AsyncBatchAnnotateImages(context.Context, *AsyncBatchAnnotateImagesRequest) (*longrunning.Operation, error)
	// Run asynchronous image detection and annotation for a list of generic
	// files, such as PDF files, which may contain multiple pages and multiple
	// images per page. Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(context.Context, *AsyncBatchAnnotateFilesRequest) (*longrunning.Operation, error)
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p4beta1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_BatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p4beta1.ImageAnnotator/BatchAnnotateFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateFiles(ctx, req.(*BatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p4beta1.ImageAnnotator/AsyncBatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateImages(ctx, req.(*AsyncBatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p4beta1.ImageAnnotator/AsyncBatchAnnotateFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, req.(*AsyncBatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1p4beta1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
		{
			MethodName: "BatchAnnotateFiles",
			Handler:    _ImageAnnotator_BatchAnnotateFiles_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateImages",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateImages_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateFiles",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateFiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1p4beta1/image_annotator.proto",
}
