/*  frameworks.c - main function and threads for frameworks.
 
    (Derived from:
    qcam.c - The frontend to Gqcam, a GTK based QuickPict clone.)

    Copyright (C) 1999 Cory Lueninghoener (cluenin1@bigred.unl.edu)
    Copyright (C) 2003 Pat Mahoney <pat@polycrystal.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include "common.h"

#define NORMAL 1
#define DUMP 2

/* global vars */
gboolean fwks_quit = FALSE;

/* Hack to allow forcing of palette for webcams that lie about their paletter
 * (or more likely bugs in frameworks decode the thing wrong... */
gint force_palette = -1;

int main(int argc, char *argv[])
{
    struct Interface *interface;
    static struct Camera camera;
    int i;
    gint action = NORMAL;
    gboolean force_read = FALSE;
    GString *device_file = NULL;

    /* To command line args: "-r" forces read(), and "device_name" is
     * the filename of the video device (defaults to /dev/video). */
    if (argc > 1) {
        for (i=1; i<argc; i++) {
            if (strcmp("-r", argv[i]) == 0) {
                force_read = TRUE;
            } else if (strcmp("--dump", argv[i]) == 0) {
                action = DUMP;
	    } else if (strcmp("--force-palette", argv[i]) == 0) {
		i++;
		force_palette = atoi(argv[i]);
            } else {
                device_file = g_string_new(argv[i]);
            }
        }
    }
    if (device_file == NULL)
        device_file = g_string_new("/dev/video");


    g_thread_init(NULL);

    /* Initialize the camera. It should start a thread that reads from
     * the camera repeatedly and then return. */
    frameworks_camera_initialize(&camera, device_file, force_read);

    if (action == NORMAL) {
        gtk_init(&argc, &argv);
        gdk_rgb_init();
        gdk_threads_init();

        /* Initialize the interface.  It should start any threads it
         * needs, then run gtk_main() itself and never return until
         * program exit */
        interface = frameworks_interface_run(&camera);

        exit(0);
    } else if (action == DUMP) {
        /* Dump a raw image with some headers to stdout */
        struct Camera *cam;
        cam = &camera;
        /* wait for the next available frame */
        g_mutex_lock(cam->buf_b_mutex);
        while (!cam->buf_b_ready)
            g_cond_wait(cam->buf_b_cond, cam->buf_b_mutex);

        /* dump headers */
        printf("Size: %dx%d\n", cam->buf_b->width, cam->buf_b->height);
        printf("Bytes per px: %f\n", cam->buf_b->bpp);
        printf("Palette: %d\n", cam->buf_b->format);
        printf("Raw data begins after this line\n");
        fflush(NULL);
        write(1, cam->buf_b->data,
              cam->buf_b->width * cam->buf_b->height * cam->buf_b->bpp);

        cam->buf_b_ready = FALSE;
        fwks_quit = TRUE;
        /* allow the camera thread to continue */
        g_mutex_unlock(cam->buf_b_mutex);
    }
}
