/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.PsiDiagramNode;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.UmlJavaUtils;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.java.utils.UmlPsiUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaUmlNode
extends PsiDiagramNode<PsiElement> {
    @NotNull
    private final NullableLazyValue<Icon> myIcon;

    JavaUmlNode(@NotNull PsiElement psiElement, @NotNull DiagramBuilder builder) {
        if (psiElement == null) {
            JavaUmlNode.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            JavaUmlNode.$$$reportNull$$$0(1);
        }
        super(psiElement, builder);
        this.myIcon = NullableLazyValue.lazyNullable(this::computeIcon);
    }

    JavaUmlNode(@NotNull PsiElement psiElement, @NotNull DiagramProvider<PsiElement> provider) {
        if (psiElement == null) {
            JavaUmlNode.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            JavaUmlNode.$$$reportNull$$$0(3);
        }
        super(psiElement, provider);
        this.myIcon = NullableLazyValue.lazyNullable(this::computeIcon);
    }

    @Override
    public String getTooltip() {
        Object psiElement = this.getElement();
        if (psiElement instanceof PsiClass) {
            return "<html><b>" + UmlPsiUtil.getClassQualifiedName((PsiClass)psiElement) + "</b></html>";
        }
        if (psiElement instanceof PsiPackage) {
            return UmlJavaUtils.getInfo((PsiPackage)psiElement).toString();
        }
        return DiagramJavaBundle.message("unknown.node.tooltip", new Object[0]);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @Override
    @Nullable
    public SimpleColoredText getIconAsText() {
        Object psiElement = this.getElement();
        if (psiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            if (UmlKotlinUtils.DataClasses.isDataClass(psiClass)) {
                return new SimpleColoredText("<<data>>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (psiClass.isRecord()) {
                return new SimpleColoredText("<<record>>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (psiClass.isAnnotationType()) {
                return new SimpleColoredText("<<annotation>>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (psiClass.isInterface()) {
                return new SimpleColoredText("<<interface>>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (psiClass.isEnum()) {
                return new SimpleColoredText("<<enumeration>>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
        if (psiElement instanceof PsiPackage) {
            return new SimpleColoredText("<<package>>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        return null;
    }

    @Nullable
    private Icon computeIcon() {
        Object element = this.getElement();
        if (element instanceof PsiClass) {
            return JavaUmlElementManager.IconManager.getIconForPsiClass((PsiClass)element, 1);
        }
        return element.getIcon(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
        }
        objectArray[1] = "com/intellij/uml/java/JavaUmlNode";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

