/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl;

import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final Set<String> alwaysSetShortOptions = ContainerUtil.newHashSet((Object[])new String[]{"i", "v", "L"});
    private static final Set<String> alwaysSetLongOptions = ContainerUtil.newHashSet((Object[])new String[]{"verbose", "include", "location", "compressed"});
    private static final Set<String> knownLongOptions = ContainerUtil.newHashSet((Object[])new String[]{"url", "request", "header", "user", "form", "data", "data-raw", "data-binary", "data-ascii", "data-urlencode"});
    private static final Set<Character> knownShortOptions = ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf('X'), Character.valueOf('H'), Character.valueOf('u'), Character.valueOf('F'), Character.valueOf('d')});

    public static boolean isKnownLongOption(@NotNull String longOption) {
        if (longOption == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return knownLongOptions.contains(longOption);
    }

    public static boolean isKnownShortOption(@NotNull String shortOption) {
        if (shortOption == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return shortOption.length() > 0 && knownShortOptions.contains(Character.valueOf(shortOption.charAt(0)));
    }

    public static boolean isAlwaysSetLongOption(@NotNull String longOption) {
        if (longOption == null) {
            Utils.$$$reportNull$$$0(2);
        }
        return alwaysSetLongOptions.contains(longOption);
    }

    public static boolean isAlwaysSetShortOption(@NotNull String shortOption) {
        if (shortOption == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return alwaysSetShortOptions.contains(shortOption);
    }

    public static boolean isLongOption(@NotNull String option) {
        if (option == null) {
            Utils.$$$reportNull$$$0(4);
        }
        return option.length() > 2 && option.startsWith("--");
    }

    public static boolean isShortOption(@NotNull String option) {
        if (option == null) {
            Utils.$$$reportNull$$$0(5);
        }
        return option.length() > 1 && option.startsWith("-") && !Utils.isLongOption(option);
    }

    public static boolean isCurlString(@NotNull String string) {
        int pos;
        if (string == null) {
            Utils.$$$reportNull$$$0(6);
        }
        int len = string.length();
        String correctFirstWord = "curl";
        if (len < 5) {
            return false;
        }
        for (pos = 0; pos < len && string.charAt(pos) <= ' '; ++pos) {
        }
        int correctFirstWordIndex = 0;
        while (pos < len && string.charAt(pos) == "curl".charAt(correctFirstWordIndex)) {
            ++pos;
            if (++correctFirstWordIndex != 4) continue;
            if (pos >= len || string.charAt(pos) > ' ') break;
            return true;
        }
        return false;
    }

    @NotNull
    public static String createCurlStringComment(@NotNull String curlString) {
        if (curlString == null) {
            Utils.$$$reportNull$$$0(7);
        }
        String string = String.format("# %s\n", curlString.trim().replaceAll("\\\\\\s|\\n", "\n#"));
        if (string == null) {
            Utils.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longOption";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortOption";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curlString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/Utils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/Utils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurlStringComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKnownLongOption";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownShortOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysSetLongOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysSetShortOption";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLongOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isShortOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCurlString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCurlStringComment";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

