/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetAsyncIteratorNodeGen;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class GetAsyncIteratorNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode objectNode;
    @Node.Child
    private PropertySetNode setState;
    @Node.Child
    private GetMethodNode getAsyncIteratorMethodNode;
    @Node.Child
    private PropertyGetNode getNextMethodNode;
    private final JSContext context;

    protected GetAsyncIteratorNode(JSContext context, JavaScriptNode objectNode) {
        this.objectNode = objectNode;
        this.context = context;
        this.setState = PropertySetNode.createSetHidden(JSFunction.ASYNC_FROM_SYNC_ITERATOR_KEY, context);
        this.getAsyncIteratorMethodNode = GetMethodNode.create(context, Symbol.SYMBOL_ASYNC_ITERATOR);
        this.getNextMethodNode = PropertyGetNode.create(Strings.NEXT, context);
    }

    @NeverDefault
    public static GetAsyncIteratorNode create(JSContext context, JavaScriptNode iteratedObject) {
        return GetAsyncIteratorNodeGen.create(context, iteratedObject);
    }

    @Specialization
    protected final IteratorRecord doGetIterator(Object iteratedObject, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedConditionProfile asyncToSync) {
        Object method = this.getAsyncIteratorMethodNode.executeWithTarget(iteratedObject);
        if (asyncToSync.profile(this, method == Undefined.instance)) {
            IteratorRecord syncIteratorRecord = getIteratorNode.execute(this, iteratedObject);
            JSObject asyncIterator = this.createAsyncFromSyncIterator(syncIteratorRecord);
            return IteratorRecord.create(asyncIterator, this.getNextMethodNode.getValue(asyncIterator), false);
        }
        return getIteratorNode.execute(this, iteratedObject, method);
    }

    private JSObject createAsyncFromSyncIterator(IteratorRecord syncIteratorRecord) {
        JSDynamicObject syncIterator = syncIteratorRecord.getIterator();
        if (!JSDynamicObject.isJSDynamicObject(syncIterator)) {
            throw Errors.createTypeErrorNotAnObject(syncIterator, this);
        }
        JSObject obj = JSOrdinary.create(this.context, this.context.getAsyncFromSyncIteratorFactory(), this.getRealm());
        this.setState.setValue(obj, syncIteratorRecord);
        return obj;
    }

    @Override
    public abstract IteratorRecord execute(VirtualFrame var1);

    public abstract IteratorRecord execute(Object var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GetAsyncIteratorNodeGen.create(this.context, GetAsyncIteratorNode.cloneUninitialized(this.objectNode, materializedTags));
    }
}

