/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@GenerateUncached
@ImportStatic(value={CompilerDirectives.class, JSConfig.class})
public abstract class JSToObjectNode
extends JavaScriptBaseNode {
    protected JSToObjectNode() {
    }

    public abstract Object execute(Object var1);

    @NeverDefault
    public static JSToObjectNode create() {
        return JSToObjectNodeGen.create();
    }

    @NeverDefault
    public static JSToObjectNode getUncached() {
        return JSToObjectNodeGen.getUncached();
    }

    protected final JSContext getContext() {
        return this.getLanguage().getJSContext();
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doBoolean(boolean value2) {
        return JSBoolean.create(this.getContext(), this.getRealm(), value2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doString(TruffleString value2) {
        return JSString.create(this.getContext(), this.getRealm(), value2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doInt(int value2) {
        return JSNumber.create(this.getContext(), this.getRealm(), value2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doDouble(double value2) {
        return JSNumber.create(this.getContext(), this.getRealm(), value2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doBigInt(BigInt value2) {
        return JSBigInt.create(this.getContext(), this.getRealm(), value2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doSymbol(Symbol value2) {
        return JSSymbol.create(this.getContext(), this.getRealm(), value2);
    }

    @Specialization(guards={"cachedClass != null", "isExact(object, cachedClass)"}, limit="1")
    protected static Object doJSObjectCached(Object object, @Cached(value="getClassIfObject(object)") Class<?> cachedClass) {
        return cachedClass.cast(object);
    }

    static Class<?> getClassIfObject(Object object) {
        if (JSGuards.isJSObject(object)) {
            return object.getClass();
        }
        return null;
    }

    @Specialization(replaces={"doJSObjectCached"})
    protected Object doJSObject(JSObject object) {
        return object;
    }

    @Specialization(guards={"isNullOrUndefined(object)"})
    protected JSDynamicObject doNullOrUndefined(Object object) {
        throw Errors.createTypeErrorNotObjectCoercible(object, this);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObjectOrNumber(value)"}, limit="InteropLibraryLimit")
    protected final Object doForeignObject(Object value2, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value2)) {
            throw Errors.createTypeErrorNotObjectCoercible(value2, this);
        }
        return JSToObjectNode.doForeignObjectNonNull(value2, interop, this);
    }

    static Object doForeignObjectNonNull(Object value2, InteropLibrary interop, JavaScriptBaseNode node) {
        assert (!interop.isNull(value2));
        try {
            if (!interop.hasMembers(value2)) {
                if (interop.isBoolean(value2)) {
                    return JSBoolean.create(JavaScriptLanguage.get(node).getJSContext(), JSRealm.get(node), interop.asBoolean(value2));
                }
                if (interop.isString(value2)) {
                    return JSString.create(JavaScriptLanguage.get(node).getJSContext(), JSRealm.get(node), interop.asTruffleString(value2));
                }
                if (interop.isNumber(value2)) {
                    return JSToObjectNode.doForeignNumber(value2, interop, node);
                }
            }
            assert (value2 instanceof TruffleObject) : value2;
            return value2;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(value2, e, "ToObject", node);
        }
    }

    private static Object doForeignNumber(Object value2, InteropLibrary interop, JavaScriptBaseNode node) throws UnsupportedMessageException {
        Number number;
        if (interop.fitsInInt(value2)) {
            number = interop.asInt(value2);
        } else if (interop.fitsInDouble(value2)) {
            number = interop.asDouble(value2);
        } else if (interop.fitsInLong(value2)) {
            number = interop.asLong(value2);
        } else if (interop.fitsInBigInteger(value2)) {
            number = BigInt.doubleValueOf(interop.asBigInteger(value2));
        } else {
            assert (value2 instanceof TruffleObject && !(value2 instanceof Number)) : value2;
            return value2;
        }
        return JSNumber.create(JavaScriptLanguage.get(node).getJSContext(), JSRealm.get(node), number);
    }

    public static abstract class JSToObjectWrapperNode
    extends JSUnaryNode {
        protected JSToObjectWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JSToObjectWrapperNode createToObject(JavaScriptNode child) {
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(child);
        }

        @Specialization
        protected Object doDefault(Object value2, @Cached JSToObjectNode toObjectNode) {
            return toObjectNode.execute(value2);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(JSToObjectWrapperNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

