/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.TestApplicationManager;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public abstract class FlyIdeaTestCase
extends TestCase {
    private final Disposable myRootDisposable = Disposer.newDisposable();
    private File myTempDir;

    protected void setUp() throws Exception {
        TestApplicationManager.getInstance();
    }

    public File getTempDir() throws IOException {
        if (this.myTempDir == null) {
            this.myTempDir = FileUtil.createTempDirectory((String)this.getName(), (String)((Object)((Object)this)).getClass().getName(), (boolean)false);
        }
        return this.myTempDir;
    }

    public Disposable getRootDisposable() {
        return this.myRootDisposable;
    }

    protected void tearDown() throws Exception {
        try {
            if (this.myTempDir != null) {
                FileUtil.asyncDelete((File)this.myTempDir);
            }
            Disposer.dispose((Disposable)this.myRootDisposable);
        }
        finally {
            super.tearDown();
        }
    }
}

