/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.intellij.lang.annotation.HighlightSeverity;
import com.jetbrains.qodana.sarif.model.Level;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u001b\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0003H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/QodanaSeverity;", "", "myName", "", "weight", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;I)V", "getWeight", "()I", "INFO", "LOW", "MODERATE", "HIGH", "CRITICAL", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "toString", "Companion", "intellij.qodana"})
public final class QodanaSeverity
extends Enum<QodanaSeverity> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String myName;
    private final int weight;
    public static final /* enum */ QodanaSeverity INFO;
    public static final /* enum */ QodanaSeverity LOW;
    public static final /* enum */ QodanaSeverity MODERATE;
    public static final /* enum */ QodanaSeverity HIGH;
    public static final /* enum */ QodanaSeverity CRITICAL;
    private static final /* synthetic */ QodanaSeverity[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private QodanaSeverity(String myName, int weight) {
        this.myName = myName;
        this.weight = weight;
    }

    public final int getWeight() {
        return this.weight;
    }

    @NotNull
    public final Icon getIcon() {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                Icon icon2 = QodanaIcons.Icons.Critical;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Critical");
                break;
            }
            case 2: {
                Icon icon3 = QodanaIcons.Icons.High;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"High");
                break;
            }
            case 3: {
                Icon icon4 = QodanaIcons.Icons.Moderate;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Moderate");
                break;
            }
            case 4: {
                Icon icon5 = QodanaIcons.Icons.Low;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Low");
                break;
            }
            case 5: {
                Icon icon6 = QodanaIcons.Icons.Info;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Info");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @Nls
    @NotNull
    public String toString() {
        return this.myName;
    }

    public static QodanaSeverity[] values() {
        return (QodanaSeverity[])$VALUES.clone();
    }

    public static QodanaSeverity valueOf(String value2) {
        return Enum.valueOf(QodanaSeverity.class, value2);
    }

    @NotNull
    public static EnumEntries<QodanaSeverity> getEntries() {
        return $ENTRIES;
    }

    static {
        INFO = new QodanaSeverity("Info", 0);
        LOW = new QodanaSeverity("Low", 1);
        MODERATE = new QodanaSeverity("Moderate", 2);
        HIGH = new QodanaSeverity("High", 3);
        CRITICAL = new QodanaSeverity("Critical", 4);
        $VALUES = qodanaSeverityArray = new QodanaSeverity[]{QodanaSeverity.INFO, QodanaSeverity.LOW, QodanaSeverity.MODERATE, QodanaSeverity.HIGH, QodanaSeverity.CRITICAL};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/QodanaSeverity$Companion;", "", "<init>", "()V", "fromIdeaSeverity", "Lorg/jetbrains/qodana/staticAnalysis/sarif/QodanaSeverity;", "ideaSeverity", "", "fromSarifLevel", "sarifLevel", "Lcom/jetbrains/qodana/sarif/model/Level;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaSeverity fromIdeaSeverity(@NotNull String ideaSeverity) {
            Intrinsics.checkNotNullParameter((Object)ideaSeverity, (String)"ideaSeverity");
            String string = ideaSeverity;
            return Intrinsics.areEqual((Object)string, (Object)HighlightSeverity.ERROR.getName()) ? CRITICAL : (Intrinsics.areEqual((Object)string, (Object)HighlightSeverity.WARNING.getName()) ? HIGH : (Intrinsics.areEqual((Object)string, (Object)HighlightSeverity.WEAK_WARNING.getName()) ? MODERATE : (Intrinsics.areEqual((Object)string, (Object)"TYPO") ? LOW : INFO)));
        }

        @NotNull
        public final QodanaSeverity fromSarifLevel(@NotNull Level sarifLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)sarifLevel), (String)"sarifLevel");
            String string = SarifKt.toSeverity(sarifLevel).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return this.fromIdeaSeverity(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QodanaSeverity.values().length];
            try {
                nArray[QodanaSeverity.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaSeverity.HIGH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaSeverity.MODERATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaSeverity.LOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QodanaSeverity.INFO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

