/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/packageChecker/java/VulnerableApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "module", "Lcom/intellij/openapi/module/Module;", "inspectionName", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "intellij.packageChecker.java"})
public final class VulnerableApiUsageProcessor
implements ApiUsageProcessor {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final Module module;
    @NotNull
    private final String inspectionName;

    public VulnerableApiUsageProcessor(@NotNull ProblemsHolder holder, @NotNull Module module, @NotNull String inspectionName) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
        this.holder = holder;
        this.module = module;
        this.inspectionName = inspectionName;
    }

    @NlsSafe
    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(target instanceof PsiCompiledElement) || !(target instanceof PsiMethod)) {
            return;
        }
        VulnerableApiService vulnerableApiService = VulnerableApiService.Companion.getInstance(this.module);
        String string = ((PsiMethod)target).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!vulnerableApiService.isSuspiciousMethodName(string)) {
            return;
        }
        PsiElement psiElement = sourceNode.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        String string2 = QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)target));
        if (string2 == null) {
            return;
        }
        String qualifiedName = string2;
        VulnerableApiService.Companion.getInstance(this.module).registerProblemIfVulnerable(qualifiedName, this.holder, sourcePsi, this.inspectionName);
    }
}

