/*
 * Decompiled with CFR 0.152.
 */
package training.statistic;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.wm.ToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import training.FeaturesTrainerIcons;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.statistic.StatisticBase;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"NOTIFICATION_SESSION_COUNTER", "", "showingNotificationIsConsidered", "", "considerNotifyAboutNewLessons", "", "project", "Lcom/intellij/openapi/project/Project;", "notifyAboutNewLessons", "newLessons", "", "Ltraining/learn/course/Lesson;", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLearnProjectStateListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearnProjectStateListener.kt\ntraining/statistic/LearnProjectStateListenerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n774#2:133\n865#2,2:134\n*S KotlinDebug\n*F\n+ 1 LearnProjectStateListener.kt\ntraining/statistic/LearnProjectStateListenerKt\n*L\n109#1:133\n109#1:134,2\n*E\n"})
public final class LearnProjectStateListenerKt {
    @NotNull
    private static final String NOTIFICATION_SESSION_COUNTER = "ift.show.new.lessons.notification.session.counter";
    private static boolean showingNotificationIsConsidered;

    private static final void considerNotifyAboutNewLessons(Project project) {
        if (!PropertiesComponent.getInstance().getBoolean("ift.show.new.lessons.notification", true)) {
            return;
        }
        if (!UtilsKt.getEnableLessonsAndPromoters() || UtilsKt.getLearningPanelWasOpenedInCurrentVersion() || !UtilsKt.getIftPluginIsUsing() || showingNotificationIsConsidered) {
            return;
        }
        showingNotificationIsConsidered = true;
        List<Lesson> newLessons = CourseManager.Companion.getInstance().getNewLessons();
        if (newLessons.isEmpty()) {
            return;
        }
        if (UtilsKt.filterUnseenLessons(newLessons).isEmpty()) {
            return;
        }
        int cooldown = 5;
        int startCounter = 2;
        int sessionCounter = PropertiesComponent.getInstance().getInt(NOTIFICATION_SESSION_COUNTER, startCounter) + 1;
        PropertiesComponent.getInstance().setValue(NOTIFICATION_SESSION_COUNTER, sessionCounter % cooldown, startCounter);
        if (sessionCounter != cooldown) {
            return;
        }
        LearnProjectStateListenerKt.notifyAboutNewLessons(project, newLessons);
    }

    /*
     * WARNING - void declaration
     */
    private static final void notifyAboutNewLessons(Project project, List<? extends Lesson> newLessons) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = newLessons;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lesson it = (Lesson)element$iv$iv;
            boolean bl = false;
            if (!(!it.getPassed$intellij_featuresTrainer())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int newLessonsCount = ((List)destination$iv$iv).size();
        BuildNumber previousOpenedVersion = CourseManager.Companion.getInstance().getPreviousOpenedVersion();
        StatisticBase.INSTANCE.logNewLessonsNotification(newLessonsCount, previousOpenedVersion);
        Notification notification = UtilsKt.getIftNotificationGroup().createNotification(LearnBundle.INSTANCE.message("notification.about.new.lessons", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(FeaturesTrainerIcons.FeatureTrainer);
        object = LearnBundle.INSTANCE.message("notification.show.new.lessons", new Object[0]);
        notification.addAction((AnAction)new NotificationAction(project, newLessonsCount, previousOpenedVersion, (String)object){
            final /* synthetic */ Project $project;
            final /* synthetic */ int $newLessonsCount;
            final /* synthetic */ BuildNumber $previousOpenedVersion;
            {
                this.$project = $project;
                this.$newLessonsCount = $newLessonsCount;
                this.$previousOpenedVersion = $previousOpenedVersion;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification.expire();
                ToolWindow toolWindow = UtilsKt.learningToolWindow(this.$project);
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                StatisticBase.INSTANCE.logShowNewLessonsEvent(this.$newLessonsCount, this.$previousOpenedVersion);
                toolWindow2.show();
            }
        });
        object = LearnBundle.INSTANCE.message("notification.do.not.show.new.lessons.notifications", new Object[0]);
        notification.addAction((AnAction)new NotificationAction(newLessonsCount, previousOpenedVersion, (String)object){
            final /* synthetic */ int $newLessonsCount;
            final /* synthetic */ BuildNumber $previousOpenedVersion;
            {
                this.$newLessonsCount = $newLessonsCount;
                this.$previousOpenedVersion = $previousOpenedVersion;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                PropertiesComponent.getInstance().setValue("ift.show.new.lessons.notification", false, true);
                StatisticBase.INSTANCE.logShowNewLessonsNotificationState(this.$newLessonsCount, this.$previousOpenedVersion, false);
                notification.expire();
            }
        });
        notification.notify(project);
    }

    public static final /* synthetic */ void access$considerNotifyAboutNewLessons(Project project) {
        LearnProjectStateListenerKt.considerNotifyAboutNewLessons(project);
    }
}

