/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.py.remote.vfs.JupyterRemoteVfsUtilKt;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.RemoteToRemoteCopyStrategyBase;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToSameRemoteCopyStrategy;", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToRemoteCopyStrategyBase;", "fileExistsHandler", "Lcom/intellij/jupyter/py/ui/remote/providers/FileExistsHandler;", "<init>", "(Lcom/intellij/jupyter/py/ui/remote/providers/FileExistsHandler;)V", "copyFile", "", "remoteFilePath", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "newRemoteFileName", "", "remoteTargetDir", "intellij.jupyter.py"})
public final class RemoteToSameRemoteCopyStrategy
extends RemoteToRemoteCopyStrategyBase {
    public RemoteToSameRemoteCopyStrategy(@NotNull FileExistsHandler fileExistsHandler) {
        Intrinsics.checkNotNullParameter((Object)fileExistsHandler, (String)"fileExistsHandler");
        super(fileExistsHandler, null);
    }

    @Override
    public void copyFile(@NotNull JupyterRemotePath remoteFilePath, @NotNull String newRemoteFileName, @NotNull JupyterRemotePath remoteTargetDir) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)remoteFilePath, (String)"remoteFilePath");
            Intrinsics.checkNotNullParameter((Object)newRemoteFileName, (String)"newRemoteFileName");
            Intrinsics.checkNotNullParameter((Object)remoteTargetDir, (String)"remoteTargetDir");
            if (!this.getFileExistsHandler().canProceedWithRemoteFile(remoteTargetDir, newRemoteFileName)) {
                return;
            }
            CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi(remoteTargetDir);
            if (cachingFileContentsApi == null) break block1;
            CachingFileContentsApi fileContentsApi = cachingFileContentsApi;
            boolean bl = false;
            ContentsApiModel model = fileContentsApi.copy(remoteFilePath.getJupyterPath(), remoteTargetDir.getJupyterPath());
            String[] stringArray = new String[]{model.getName()};
            String string = remoteTargetDir.resolve(stringArray).getJupyterPath();
            stringArray = new String[]{newRemoteFileName};
            fileContentsApi.rename(string, remoteTargetDir.resolve(stringArray).getJupyterPath());
        }
    }
}

