/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.lexer.EscapeUtilsKt;
import org.toml.lang.lexer.LexerBaseEx;
import org.toml.lang.psi.ElementTypesKt;
import org.toml.lang.psi.TomlElementTypes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0014J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/toml/lang/lexer/TomlEscapeLexer;", "Lorg/toml/lang/lexer/LexerBaseEx;", "defaultToken", "Lcom/intellij/psi/tree/IElementType;", "eol", "", "<init>", "(Lcom/intellij/psi/tree/IElementType;Z)V", "determineTokenType", "isValidUnicodeEscape", "start", "", "end", "locateToken", "unicodeTokenEnd", "expectedLength", "Companion", "intellij.toml.core"})
public final class TomlEscapeLexer
extends LexerBaseEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IElementType defaultToken;
    private final boolean eol;
    @NotNull
    private static final TokenSet ESCAPABLE_LITERALS_TOKEN_SET = ElementTypesKt.getTOML_BASIC_STRINGS();

    private TomlEscapeLexer(IElementType defaultToken, boolean eol) {
        this.defaultToken = defaultToken;
        this.eol = eol;
    }

    @Override
    @Nullable
    protected IElementType determineTokenType() {
        if (this.getTokenStart() >= this.getTokenEnd()) {
            return null;
        }
        if (this.getBufferSequence().charAt(this.getTokenStart()) != '\\') {
            return this.defaultToken;
        }
        if (this.getTokenStart() + 1 >= this.getTokenEnd()) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        return switch (this.getBufferSequence().charAt(this.getTokenStart() + 1)) {
            case 'U', 'u' -> {
                if (this.isValidUnicodeEscape(this.getTokenStart(), this.getTokenEnd())) {
                    yield StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                }
                yield StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            case '\n', '\r' -> EscapeUtilsKt.esc(this.eol);
            case '\"', '\\', 'b', 'f', 'n', 'r', 't' -> StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            default -> StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidUnicodeEscape(int start, int end) {
        try {
            boolean bl;
            int value = Integer.parseInt(((Object)this.getBufferSequence().subSequence(start + 2, end)).toString(), CharsKt.checkRadix((int)16));
            if (0 <= value) {
                if (value < 55296) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (57344 > value) return false;
            if (value >= 0x110000) return false;
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected int locateToken(int start) {
        if (start >= this.getBufferEnd()) {
            return start;
        }
        if (this.getBufferSequence().charAt(start) == '\\') {
            int i = start + 1;
            if (i >= this.getBufferEnd()) {
                return this.getBufferEnd();
            }
            return switch (this.getBufferSequence().charAt(i)) {
                case 'u' -> this.unicodeTokenEnd(i + 1, 4);
                case 'U' -> this.unicodeTokenEnd(i + 1, 8);
                case '\n', '\r' -> {
                    void var3_4;
                    for (int j = i; j < this.getBufferEnd() && EscapeUtilsKt.isWhitespaceChar(this.getBufferSequence().charAt(j)); ++j) {
                    }
                    yield var3_4;
                }
                default -> i + 1;
            };
        }
        int idx = CharArrayUtil.indexOf((CharSequence)this.getBufferSequence(), (CharSequence)"\\", (int)(start + 1), (int)this.getBufferEnd());
        return idx != -1 ? idx : this.getBufferEnd();
    }

    private final int unicodeTokenEnd(int start, int expectedLength) {
        int n = start + expectedLength;
        for (int i = start; i < n; ++i) {
            if (i < this.getBufferEnd() && StringUtil.isHexDigit((char)this.getBufferSequence().charAt(i))) continue;
            return start;
        }
        return start + expectedLength;
    }

    public /* synthetic */ TomlEscapeLexer(IElementType defaultToken, boolean eol, DefaultConstructorMarker $constructor_marker) {
        this(defaultToken, eol);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/toml/lang/lexer/TomlEscapeLexer$Companion;", "", "<init>", "()V", "of", "Lorg/toml/lang/lexer/TomlEscapeLexer;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "ESCAPABLE_LITERALS_TOKEN_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getESCAPABLE_LITERALS_TOKEN_SET", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.toml.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TomlEscapeLexer of(@NotNull IElementType tokenType) {
            TomlEscapeLexer tomlEscapeLexer;
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            IElementType iElementType = tokenType;
            if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.BASIC_STRING)) {
                IElementType iElementType2 = TomlElementTypes.BASIC_STRING;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"BASIC_STRING");
                tomlEscapeLexer = new TomlEscapeLexer(iElementType2, false, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.MULTILINE_BASIC_STRING)) {
                IElementType iElementType3 = TomlElementTypes.MULTILINE_BASIC_STRING;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"MULTILINE_BASIC_STRING");
                tomlEscapeLexer = new TomlEscapeLexer(iElementType3, true, null);
            } else {
                throw new IllegalArgumentException("Unsupported literal type: " + tokenType);
            }
            return tomlEscapeLexer;
        }

        @NotNull
        public final TokenSet getESCAPABLE_LITERALS_TOKEN_SET() {
            return ESCAPABLE_LITERALS_TOKEN_SET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

