/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir;

import com.intellij.openapi.util.UserDataHolderBase;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\rJ\u0015\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00040\u0004H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0011\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001c\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0000J\u0016\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006J\b\u0010 \u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/rml/dfa/ir/IrLocation;", "", "Lcom/intellij/openapi/util/UserDataHolderBase;", "filePath", "", "offset1", "", "offset2", "line", "col", "<init>", "(Ljava/lang/String;IIII)V", "name", "(Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "getOffset1", "()I", "getOffset2", "getLine", "getCol", "toString", "kotlin.jvm.PlatformType", "toLongString", "isStub", "", "compareTo", "other", "equals", "", "contains", "offset", "hashCode", "intellij.rml.dfa"})
public final class IrLocation
extends UserDataHolderBase
implements Comparable<IrLocation> {
    @NotNull
    private final String filePath;
    private final int offset1;
    private final int offset2;
    private final int line;
    private final int col;

    public IrLocation(@NotNull String filePath, int offset1, int offset2, int line, int col) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.offset1 = offset1;
        this.offset2 = offset2;
        this.line = line;
        this.col = col;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final int getOffset1() {
        return this.offset1;
    }

    public final int getOffset2() {
        return this.offset2;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCol() {
        return this.col;
    }

    public IrLocation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, -1, -1, -1, -1);
    }

    public String toString() {
        return this.offset1 == -1 ? new File(this.filePath).getName() : new File(this.filePath).getName() + ":" + this.line + ":" + this.col + "-" + (this.col + this.offset2 - this.offset1);
    }

    @NotNull
    public final String toLongString() {
        return this.offset1 == -1 ? this.filePath : this.filePath + ":" + this.line + ":" + this.col + "-" + (this.col + this.offset2 - this.offset1);
    }

    public final boolean isStub() {
        return this.offset1 == -1;
    }

    @Override
    public int compareTo(@NotNull IrLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int fileComparison = this.filePath.compareTo(other.filePath);
        return fileComparison != 0 ? fileComparison : this.offset1 - other.offset1;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IrLocation && Intrinsics.areEqual((Object)this.filePath, (Object)((IrLocation)other).filePath) && this.offset1 == ((IrLocation)other).offset1 && this.offset2 == ((IrLocation)other).offset2;
    }

    public final boolean contains(@NotNull IrLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.filePath, (Object)other.filePath) && this.offset1 <= other.offset1 && other.offset2 <= this.offset2;
    }

    public final boolean contains(@NotNull String filePath, int offset) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return Intrinsics.areEqual((Object)this.filePath, (Object)filePath) && this.offset1 <= offset && offset <= this.offset2;
    }

    public int hashCode() {
        int result2 = this.filePath.hashCode();
        result2 = 31 * result2 + this.offset1;
        result2 = 31 * result2 + this.offset2;
        return result2;
    }
}

