/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.JsonWriters;
import org.jetbrains.jsonProtocol.OutMessageKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0004J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020 J(\u0010!\u001a\u00020\u000f\"\b\b\u0000\u0010\"*\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\"\u0018\u00010#J\u001e\u0010$\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010%J \u0010&\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0%J\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000J\u0006\u0010*\u001a\u00020\u000fJ\u0018\u0010+\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020,H\u0004J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/jsonProtocol/OutMessage;", "", "<init>", "()V", "buffer", "Lio/netty/buffer/ByteBuf;", "getBuffer", "()Lio/netty/buffer/ByteBuf;", "writer", "Lcom/google/gson/stream/JsonWriter;", "getWriter", "()Lcom/google/gson/stream/JsonWriter;", "finalized", "", "beginArguments", "", "writeMap", "name", "", "value", "", "writeLongArray", "", "writeDoubleArray", "", "writeIntArray", "", "writeIntSet", "Lit/unimi/dsi/fastutil/ints/IntSet;", "writeIntList", "Lit/unimi/dsi/fastutil/ints/IntList;", "writeSingletonIntArray", "", "writeList", "E", "", "writeStringList", "", "writeEnumList", "values", "", "writeMessage", "close", "writeLong", "", "writeString", "writeNullableString", "", "intellij.platform.scriptDebugger.protocolReaderRuntime"})
public class OutMessage {
    @NotNull
    private final ByteBuf buffer;
    @NotNull
    private final JsonWriter writer;
    private boolean finalized;

    public OutMessage() {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        this.buffer = byteBuf;
        this.writer = new JsonWriter((Writer)new ByteBufUtf8Writer(this.buffer));
        this.writer.beginObject();
    }

    @NotNull
    public final ByteBuf getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final JsonWriter getWriter() {
        return this.writer;
    }

    public void beginArguments() {
    }

    public final void writeMap(@NotNull String name, @Nullable Map<String, String> value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginObject();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            String key = entry.getKey();
            String value1 = entry.getValue();
            this.writer.name(key).value(value1);
        }
        this.writer.endObject();
    }

    public static /* synthetic */ void writeMap$default(OutMessage outMessage, String string, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeMap");
        }
        if ((n & 2) != 0) {
            map = null;
        }
        outMessage.writeMap(string, map);
    }

    protected final void writeLongArray(@NotNull String name, @NotNull long[] value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        for (long v : value) {
            this.writer.value(v);
        }
        this.writer.endArray();
    }

    public final void writeDoubleArray(@NotNull String name, @NotNull double[] value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        for (double v : value) {
            this.writer.value(v);
        }
        this.writer.endArray();
    }

    public final void writeIntArray(@NotNull String name, @Nullable int[] value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        for (int v : value) {
            this.writer.value((long)v);
        }
        this.writer.endArray();
    }

    public static /* synthetic */ void writeIntArray$default(OutMessage outMessage, String string, int[] nArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeIntArray");
        }
        if ((n & 2) != 0) {
            nArray = null;
        }
        outMessage.writeIntArray(string, nArray);
    }

    public final void writeIntSet(@NotNull String name, @NotNull IntSet value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        IntIterator intIterator = value.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            this.writer.value((long)iterator.nextInt());
        }
        this.writer.endArray();
    }

    public final void writeIntList(@NotNull String name, @NotNull IntList value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        int n = value.size();
        for (int i = 0; i < n; ++i) {
            this.writer.value((long)value.getInt(i));
        }
        this.writer.endArray();
    }

    public final void writeSingletonIntArray(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        this.writer.value((long)value);
        this.writer.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends OutMessage> void writeList(@NotNull String name, @Nullable List<? extends E> value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection collection = value;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        boolean isNotFirst = false;
        for (OutMessage item : value) {
            try {
                if (isNotFirst) {
                    this.buffer.writeByte(44).writeByte(32);
                } else {
                    isNotFirst = true;
                }
                if (!item.finalized) {
                    item.finalized = true;
                    try {
                        item.writer.endObject();
                    }
                    catch (IllegalStateException e) {
                        if (Intrinsics.areEqual((Object)"Nesting problem.", (Object)e.getMessage())) {
                            throw new RuntimeException(item.buffer.toString(Charsets.UTF_8) + "\nparent:\n" + this.buffer.toString(Charsets.UTF_8), e);
                        }
                        throw e;
                    }
                }
                this.buffer.writeBytes(item.buffer);
            }
            finally {
                if (item.buffer.refCnt() <= 0) continue;
                item.buffer.release();
            }
        }
        this.writer.endArray();
    }

    public final void writeStringList(@NotNull String name, @Nullable Collection<String> value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.beginArguments();
        JsonWriters.INSTANCE.writeStringList(this.writer, name, value);
    }

    public final void writeEnumList(@NotNull String name, @NotNull Collection<? extends Enum<?>> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.beginArguments();
        this.writer.name(name).beginArray();
        for (Enum<?> item : values) {
            this.writer.value(item.toString());
        }
        this.writer.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeMessage(@NotNull String name, @Nullable OutMessage value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        try {
            this.beginArguments();
            OutMessageKt.prepareWriteRaw(this, name);
            if (!value.finalized) {
                value.close();
            }
            this.buffer.writeBytes(value.buffer);
        }
        finally {
            if (value.buffer.refCnt() > 0) {
                value.buffer.release();
            }
        }
    }

    public final void close() {
        boolean bl;
        boolean bl2 = bl = !this.finalized;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.finalized = true;
        this.writer.endObject();
        this.writer.close();
    }

    protected final void writeLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.beginArguments();
        this.writer.name(name).value(value);
    }

    public final void writeString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null) {
            this.writeNullableString(name, value);
        }
    }

    public final void writeNullableString(@NotNull String name, @Nullable CharSequence value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.beginArguments();
        CharSequence charSequence = value;
        this.writer.name(name).value(charSequence != null ? ((Object)charSequence).toString() : null);
    }
}

