/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryServiceImpl;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PopularPackageListGenerator {
    private static final List<String> EXPLICITLY_REQUIRED_PACKAGES = List.of("svelte", "@angular/core", "@angular/material", "react", "@material-ui/core", "react-bootstrap", "ionic", "cordova", "vue", "vuetify", "bootstrap-vue", "quasar", "ember-cli", "react-native", "electron", "express", "gatsby", "next", "graphql", "graphql-relay", "apollo-client", "jest", "enzyme", "mocha", "karma", "protractor", "cucumber", "ava", "eslint", "tslint", "flow-bin", "prettier", "nuxt", "tailwindcss", "snowpack", "alpinejs", "apollo-server", "xstate", "react-relay", "fastify", "cypress", "@storybook/angular", "@storybook/vue", "esbuild", "parcel-bundler", "vite", "playwright", "lit", "@hotwired/stimulus", "solid-js", "strapi", "@redwoodjs/core", "astro", "remix", "@sveltejs/kit", "vitest", "parcel", "rome", "@swc/core", "expo", "@tauri-apps/cli", "turbo", "lerna", "@microsoft/rush", "pnpm", "nx", "standard", "@stencil/core", "c8", "prisma", "@nestjs/core", "mermaid", "vue-pug", "prisma-import", "@mui/material", "@mui/icons-material", "pinia", "bun-types", "@vue/language-server", "@vue/language-plugin-pug", "@astrojs/language-server", "typescript-svelte-plugin", "@angular/language-server", "@tailwindcss/language-server", "@prisma/language-server", "typescript-lit-html-plugin", "ts-graphql-plugin", "graphql-language-service-server", "preact", "vue-property-decorator", "vue-facing-decorator", "@chakra-ui/react", "@reduxjs/toolkit", "zustand", "@storybook/react", "@biomejs/biome", "@vueuse/core", "@ionic/core", "@ionic/angular", "@ionic/vue", "@ionic/react", "tsx", "@microsoft/tsdoc", "prettier-plugin-organize-imports", "@trivago/prettier-plugin-sort-imports", "oxlint");
    private static final int N = 1018;

    public static void main(String[] args) throws IOException {
        List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parseNodeScriptResult();
        PopularPackageListGenerator.addRequiredPackages(infos);
        PopularPackageListGenerator.assertNoDuplicatesAndFull(infos);
        PopularPackageListGenerator.writePackagesWithInfo(infos, PopularPackageListGenerator.getFile("./plugins/JavaScriptLanguage/src/com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/popular-node-packages.json"));
        PopularPackageListGenerator.writeDict(infos, PopularPackageListGenerator.getFile("./plugins/JavaScriptLanguage/src/com/intellij/lang/javascript/highlighting/dictionary/packages.dic"));
    }

    @NotNull
    private static List<NodePackageBasicInfo> parseNodeScriptResult() throws IOException {
        String fileName = "plugins/JavaScriptLanguage/src/com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/query-result.json";
        JsonReader reader = new JsonReader((Reader)new FileReader(fileName, StandardCharsets.UTF_8));
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>(1018);
        reader.beginArray();
        while (reader.peek() == JsonToken.BEGIN_OBJECT) {
            reader.beginObject();
            while (reader.hasNext()) {
                String propName = reader.nextName();
                if (propName.equals("package")) {
                    NodePackageBasicInfo info = NpmRegistryServiceImpl.readPackageInfo(reader);
                    if (info == null) {
                        throw new RuntimeException("Cannot parse query result");
                    }
                    result2.add(new NodePackageBasicInfo(info.getName(), PopularPackageListGenerator.normalizeDescription(info.getDescription())));
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        ArrayList<NodePackageBasicInfo> arrayList = result2;
        ArrayList<NodePackageBasicInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(0);
        }
        return arrayList2;
        finally {
            reader.close();
        }
    }

    private static void assertNoDuplicatesAndFull(List<NodePackageBasicInfo> infos) {
        HashSet names = new HashSet(ContainerUtil.map2Set(infos, NodePackageBasicInfo::getName));
        if (names.size() != infos.size()) {
            HashSet<String> twice = new HashSet<String>();
            for (NodePackageBasicInfo info : infos) {
                if (names.remove(info.getName())) continue;
                twice.add(info.getName());
            }
            throw new RuntimeException("Packages added twice: " + twice);
        }
        if (infos.size() != 1018) {
            throw new RuntimeException("Some packages are missing. Expected: 1000, actual: " + infos.size());
        }
        for (String requiredPackage : EXPLICITLY_REQUIRED_PACKAGES) {
            if (names.contains(requiredPackage)) continue;
            throw new RuntimeException("Explicitly required package " + requiredPackage + " is missing");
        }
    }

    @NotNull
    private static File getFile(@NotNull String relativePath) throws IOException {
        File file;
        File dir;
        if (relativePath == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(1);
        }
        if (!(dir = (file = new File(relativePath)).getParentFile()).isDirectory()) {
            throw new IOException("No such directory " + dir.getAbsolutePath());
        }
        File file2 = file;
        if (file2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(2);
        }
        return file2;
    }

    private static void addRequiredPackages(@NotNull List<NodePackageBasicInfo> result2) {
        if (result2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(3);
        }
        List<NodePackageBasicInfo> notExplicitlyRequiredPackageNames = result2.stream().filter(info -> !EXPLICITLY_REQUIRED_PACKAGES.contains(info.getName())).toList();
        int toRemove = Math.max(0, notExplicitlyRequiredPackageNames.size() + EXPLICITLY_REQUIRED_PACKAGES.size() - 1018);
        result2.removeAll(ContainerUtil.subList(notExplicitlyRequiredPackageNames, (int)(notExplicitlyRequiredPackageNames.size() - toRemove)));
        ArrayList<String> namesToAdd = new ArrayList<String>(EXPLICITLY_REQUIRED_PACKAGES);
        namesToAdd.removeAll(ContainerUtil.map(result2, NodePackageBasicInfo::getName));
        PopularPackageListGenerator.addPackages(result2, namesToAdd);
    }

    private static void addPackages(@NotNull List<NodePackageBasicInfo> result2, @NotNull List<String> namesToAdd) {
        if (result2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(4);
        }
        if (namesToAdd == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(5);
        }
        PopularPackageListGenerator.log("Fetching metadata for " + namesToAdd.size() + " packages...", new Object[0]);
        long startNano = System.nanoTime();
        result2.addAll(ContainerUtil.map(namesToAdd, name -> PopularPackageListGenerator.createInfo(name)));
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNano);
        PopularPackageListGenerator.log((String)(namesToAdd.isEmpty() ? "Done. Nothing to fetch" : "Done in " + durationMillis + " ms (single fetch: " + durationMillis / (long)namesToAdd.size() + " ms)\n"), new Object[0]);
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static NodePackageBasicInfo createInfo(@NotNull String packageName) {
        if (packageName == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(6);
        }
        String metadata = NpmRegistryServiceImpl.fetchPackageMetadataSync(packageName, false);
        JsonReader reader = new JsonReader((Reader)new StringReader(metadata));
        NodePackageBasicInfo info = NpmRegistryServiceImpl.readPackageInfo(reader);
        if (info == null || !info.getName().equals(packageName)) {
            throw new RuntimeException("Cannot parse metadata for " + packageName + ": " + info);
        }
        NodePackageBasicInfo nodePackageBasicInfo = new NodePackageBasicInfo(info.getName(), PopularPackageListGenerator.normalizeDescription(info.getDescription()));
        reader.close();
        NodePackageBasicInfo nodePackageBasicInfo2 = nodePackageBasicInfo;
        if (nodePackageBasicInfo2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(7);
        }
        return nodePackageBasicInfo2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot fetch package info for " + packageName, e);
                }
            }
        }
    }

    private static void log(String format, Object ... args) {
        System.out.printf(format + "\n", args);
    }

    @Nullable
    private static String normalizeDescription(@Nullable String description) {
        if (description == null) {
            return null;
        }
        if (!(description = StringUtil.unescapeXmlEntities((String)description)).contains(". ")) {
            description = StringUtil.trimEnd((String)description, (String)".");
        }
        if (description.startsWith("[![")) {
            return null;
        }
        return description;
    }

    private static void writeDict(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(8);
        }
        if (outputFile == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(9);
        }
        HashSet<String> words = new HashSet<String>();
        for (NodePackageBasicInfo name : names) {
            String[] split;
            for (String s : split = name.getName().split("[/\\-.]")) {
                if ((s = StringUtil.trimStart((String)s, (String)"@")).length() <= 3) continue;
                words.add(s);
            }
        }
        String collect = words.stream().sorted().collect(Collectors.joining("\n"));
        FileUtil.writeToFile((File)outputFile, (String)collect);
        PopularPackageListGenerator.log(words.size() + " names written to " + outputFile.getAbsolutePath(), new Object[0]);
    }

    private static void writePackagesWithInfo(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(10);
        }
        if (outputFile == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(11);
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginArray();
            for (NodePackageBasicInfo info : names) {
                writer.beginArray();
                writer.setIndent("");
                writer.value(info.getName());
                if (info.getDescription() != null) {
                    writer.value(info.getDescription());
                }
                writer.endArray();
                writer.setIndent(" ");
            }
            writer.endArray();
        }
        PopularPackageListGenerator.log(names.size() + " packages are written to " + outputFile.getAbsolutePath(), new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToAdd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNodeScriptResult";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredPackages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeDict";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writePackagesWithInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

