/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JSTagOrGenericFlowParser;
import com.intellij.lang.javascript.parsing.JSTagOrGenericParser;
import com.intellij.lang.javascript.parsing.JSTagOrGenericUtil;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLexerUtil {
    public static final TokenSet SKIP_WORDS_SCAN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.WHITE_SPACE, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.COLON, JSTokenTypes.COLON_COLON, JSTokenTypes.ANY_IDENTIFIER, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.DOT_DOT, JSTokenTypes.DOT_DOT_DOT}), TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.IS_KEYWORD, JSTokenTypes.AS_KEYWORD, JSTokenTypes.IN_KEYWORD}))});

    public static boolean canBeGenericArgumentList(FlexLexer lexer, boolean isFlow) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next == JSTokenTypes.GT || next == JSTokenTypes.COMMA || !isFlow && next == JSTokenTypes.EXTENDS_KEYWORD || isFlow && next == JSTokenTypes.COLON;
    }

    @NotNull
    public static LookAheadOfLtResult lookAheadOfLt(boolean isFlow, FlexLexer lexer) {
        JSTagOrGenericUtil.State state = new JSTagOrGenericUtil.State(lexer);
        if (isFlow) {
            JSTagOrGenericFlowParser.parse_root_(null, state, 0);
        } else {
            JSTagOrGenericParser.parse_root_(null, state, 0);
        }
        LookAheadOfLtResult lookAheadOfLtResult = state.getLastElementType() == JSTagOrGenericUtil.ElementType.GENERICS ? LookAheadOfLtResult.OTHER : (state.getLastElementType() == JSTagOrGenericUtil.ElementType.TAG_OR_GENERICS ? LookAheadOfLtResult.TAG_OR_GENERIC_PARAMETER : LookAheadOfLtResult.TAG);
        if (lookAheadOfLtResult == null) {
            JSLexerUtil.$$$reportNull$$$0(0);
        }
        return lookAheadOfLtResult;
    }

    @Nullable
    public static IElementType skipCommentsAndWhitespaces(FlexLexer lexer) throws IOException {
        if (lexer.yystate() == -1) {
            return null;
        }
        IElementType next = lexer.advance();
        while (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
            next = lexer.advance();
        }
        return next;
    }

    public static boolean advanceBlockStatement(Iterator<? extends IElementType> tokenIterator) {
        IElementType tokenType = tokenIterator.next();
        if (tokenType != JSTokenTypes.LBRACE) {
            return false;
        }
        int pos = 0;
        int balance = 1;
        while (balance > 0) {
            if (pos++ % 1000 == 0) {
                ProgressManager.checkCanceled();
            }
            if (!tokenIterator.hasNext()) {
                return false;
            }
            tokenType = tokenIterator.next();
            if (tokenType == JSTokenTypes.LBRACE) {
                ++balance;
                continue;
            }
            if (tokenType != JSTokenTypes.RBRACE) continue;
            --balance;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLexerUtil", "lookAheadOfLt"));
    }

    public static enum LookAheadOfLtResult {
        TAG,
        TAG_OR_GENERIC_PARAMETER,
        OTHER;

    }
}

