/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocSyntaxHighlightingHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSLinkTypeTextStringBuilder;
import com.intellij.lang.javascript.highlighting.JSHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPresentableTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumLiteralType;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSHtmlHighlightingUtil {
    public static final String TYPE_PLACEHOLDER_PREFIX = "$$Type$$";
    public static final String TYPE_PLACEHOLDER = "$$Type$$Unique";
    public static final String NAME_PLACEHOLDER = "$$Name$$";
    public static final String MORE_MEMBERS_PLACEHOLDER = "$$MoreMembers$$";
    public static final String TYPE_SEPARATOR = ": ";
    public static final String STYLE_ITALIC = "font-style:italic;";
    public static final String STYLE_BOLD = "font-weight:bold;";
    private static final String EXTENDED_PLACEHOLDER = "\n/* $$MoreMembers$$ */";

    @Nullable
    private static String readHtmlText(@Nullable CharSequence text) {
        return text == null ? null : text.toString().replace(STYLE_BOLD, "");
    }

    @Nullable
    public static CharSequence tryGetHtmlHighlighting(@NotNull PsiElement elementOrContext, @NotNull String fakeText, @Nullable TextRange identifierRange, int startOffset, int endOffset) {
        if (elementOrContext == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(0);
        }
        if (fakeText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (DumbService.isDumb((Project)elementOrContext.getProject()) || StringUtil.isEmpty((String)fakeText)) {
            return null;
        }
        @NotNull Language language = JSHtmlHighlightingUtil.getLanguageForHighlighting(elementOrContext);
        try {
            PsiFile fakeFile = PsiFileFactory.getInstance((Project)elementOrContext.getProject()).createFileFromText("dummy", language, (CharSequence)fakeText, false, false);
            ArrayList<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo> holder = new ArrayList<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo>();
            if (identifierRange != null) {
                JSHtmlHighlightingUtil.highlightName(elementOrContext, holder, identifierRange, language);
            }
            JSHtmlHighlightingUtil.highlightSemanticKeywords(fakeFile, holder, language);
            SyntaxInfoBuilder.RangeIterator iterator = JSHtmlHighlightingUtil.createAnnotationsRangeIterator(holder, startOffset, endOffset, EditorColorsManager.getInstance().getGlobalScheme());
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            return JSHtmlHighlightingUtil.readHtmlText(HtmlSyntaxInfoUtil.getHtmlContent((PsiFile)fakeFile, (CharSequence)fakeText, (SyntaxInfoBuilder.RangeIterator)iterator, (EditorColorsScheme)scheme, (int)startOffset, (int)endOffset));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(JSHtmlHighlightingUtil.class).error("Cannot process html highlighting for: " + fakeText, (Throwable)e);
            return null;
        }
    }

    private static void highlightName(@NotNull PsiElement elementOrContext, @NotNull List<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo> holder, @NotNull TextRange identifierRange, @NotNull Language language) {
        JSHighlightDescriptor descriptor;
        JSQualifiedNamedElement initializedElement;
        if (elementOrContext == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(3);
        }
        if (identifierRange == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(4);
        }
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(5);
        }
        JSHighlighter highlighter = JSAnnotatingVisitor.getHighlighter(language);
        if (elementOrContext instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)elementOrContext)) != null) {
            elementOrContext = initializedElement;
        }
        if ((descriptor = JSSemanticHighlightingVisitor.buildHighlightForResolveResult(elementOrContext, elementOrContext)) != null) {
            holder.add(new RangeWithAttributes(identifierRange.getStartOffset(), identifierRange.getEndOffset(), descriptor.getAttributesKey(highlighter)));
        }
    }

    @Nullable
    private static SyntaxInfoBuilder.RangeIterator createAnnotationsRangeIterator(@NotNull List<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo> holder, int startOffset, int endOffset, final EditorColorsScheme colorsScheme) {
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(6);
        }
        if (holder.isEmpty()) {
            return null;
        }
        final List annotations = holder.stream().sorted(Comparator.comparing(el -> el.getStartOffset())).filter(el -> startOffset <= el.getStartOffset() && el.getEndOffset() <= endOffset).collect(Collectors.toList());
        return new SyntaxInfoBuilder.RangeIterator(){
            int index = -1;

            public boolean atEnd() {
                return this.index >= annotations.size() - 1;
            }

            public void advance() {
                ++this.index;
            }

            public int getRangeStart() {
                QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo annotation = this.get();
                return annotation == null ? 0 : annotation.getStartOffset();
            }

            public int getRangeEnd() {
                QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo annotation = this.get();
                return annotation == null ? 0 : annotation.getEndOffset();
            }

            public TextAttributes getTextAttributes() {
                QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo annotation = this.get();
                return annotation == null ? null : annotation.getTextAttributes(colorsScheme);
            }

            private QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo get() {
                return annotations.size() > this.index ? (QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo)annotations.get(this.index) : null;
            }

            public void dispose() {
                annotations.clear();
            }
        };
    }

    static void highlightSemanticKeywords(@NotNull PsiFile fakeFile, @NotNull List<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo> holder, @NotNull Language language) {
        if (fakeFile == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(8);
        }
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(9);
        }
        if (language instanceof JSLanguageDialect) {
            DialectOptionHolder optionHolder = ((JSLanguageDialect)language).getOptionHolder();
            HighlightInfoHolder highlightInfoHolder = new HighlightInfoHolder(fakeFile, new HighlightInfoFilter[0]);
            JSKeywordHighlighterVisitor visitor = JSAnalysisHandlersFactory.forLanguage(language).createKeywordHighlighterVisitor(highlightInfoHolder, optionHolder);
            SyntaxTraverser.psiTraverser((PsiElement)fakeFile).traverse().forEach(it -> it.accept((PsiElementVisitor)visitor));
            for (int i = 0; i < highlightInfoHolder.size(); ++i) {
                HighlightInfo info = highlightInfoHolder.get(i);
                holder.add(new HighlightInfoAdapter(fakeFile, info));
            }
        }
    }

    @NotNull
    public static TextPlaceholder getTypeWithLinksPlaceholder(@Nullable JSType type, boolean hasFiredEvents, @NotNull String placeHolderPrefix) {
        if (placeHolderPrefix == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(10);
        }
        if (type == null) {
            return new TextPlaceholder(){

                @Override
                @NotNull
                public String getHolderText() {
                    return "any";
                }

                @Override
                public CharSequence restoreText(@NotNull CharSequence text) {
                    if (text == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return text;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$2", "restoreText"));
                }
            };
        }
        return JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(type, hasFiredEvents, placeHolderPrefix, true);
    }

    @NotNull
    public static TextPlaceholder getFullTypeWithLinksPlaceholder(@NotNull JSType type) {
        if (type == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(11);
        }
        return JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(type, false, TYPE_PLACEHOLDER, false);
    }

    @NotNull
    private static TextPlaceholder getTypeWithLinksPlaceholder(@NotNull JSType type, final boolean hasFiredEvents, final @NotNull String placeHolderPrefix, boolean limitProcessing) {
        if (type == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(12);
        }
        if (placeHolderPrefix == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(13);
        }
        final HashMap replacements = new HashMap();
        final AtomicInteger counter = new AtomicInteger();
        final JSPresentableTypeTextStringBuilder builder2 = new JSPresentableTypeTextStringBuilder(10, 300, limitProcessing ? "..." : EXTENDED_PLACEHOLDER){

            @Override
            public boolean startProcessType(@NotNull JSType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!this.checkLimit()) {
                    return false;
                }
                if (type instanceof JSTypeImpl || type instanceof TypeScriptEnumLiteralType) {
                    String replacement = placeHolderPrefix + counter.incrementAndGet();
                    replacements.put(replacement, type);
                    this.append(replacement);
                    return false;
                }
                return super.startProcessType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$3", "startProcessType"));
            }
        };
        type.buildTypeText(JSType.TypeTextFormat.PRESENTABLE, builder2);
        return new TextPlaceholder(){

            @Override
            @NotNull
            public String getHolderText() {
                String string = builder2.getResult();
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public CharSequence restoreText(@NotNull CharSequence text) {
                if (text == null) {
                    4.$$$reportNull$$$0(1);
                }
                String result2 = text.toString();
                for (Map.Entry entry : replacements.entrySet()) {
                    String placeholder = (String)entry.getKey();
                    String typeLink = JSHtmlHighlightingUtil.getSimpleTypeWithLinkText((JSType)entry.getValue(), hasFiredEvents);
                    result2 = StringsKt.replaceFirst((String)result2, (String)placeholder, (String)typeLink, (boolean)false);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHolderText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "restoreText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Nullable
    static String tryGetHtmlHighlightingForName(@NotNull PsiElement context2, @NotNull String name) {
        if (context2 == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(15);
        }
        ArrayList<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo> holder = new ArrayList<QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo>();
        TextRange range = new TextRange(0, name.length());
        JSHtmlHighlightingUtil.highlightName(context2, holder, range, JSHtmlHighlightingUtil.getLanguageForHighlighting(context2));
        SyntaxInfoBuilder.RangeIterator iterator = JSHtmlHighlightingUtil.createAnnotationsRangeIterator(holder, 0, name.length(), EditorColorsManager.getInstance().getGlobalScheme());
        if (iterator != null) {
            try {
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                return JSHtmlHighlightingUtil.readHtmlText(HtmlSyntaxInfoUtil.getHtmlContent((CharSequence)name, (SyntaxInfoBuilder.RangeIterator)iterator, (EditorColorsScheme)scheme, (int)name.length()));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(JSHtmlHighlightingUtil.class).error("Cannot process html highlighting for: " + name, (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static TextPlaceholder createSimpleHolder(final @NotNull String originalText, final @NotNull String holder) {
        if (originalText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(17);
        }
        return new TextPlaceholder(){

            @Override
            @NotNull
            public CharSequence getHolderText() {
                String string = holder;
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public CharSequence restoreText(@NotNull CharSequence text) {
                if (text == null) {
                    5.$$$reportNull$$$0(1);
                }
                return JSHtmlHighlightingUtil.replaceSubSequence(text, holder, originalText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHolderText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "restoreText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    private static CharSequence replaceSubSequence(@NotNull CharSequence text, @NotNull String oldText, @NotNull String newText) {
        int index;
        if (text == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(18);
        }
        if (oldText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(19);
        }
        if (newText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(20);
        }
        if ((index = StringUtil.indexOf((CharSequence)text, (CharSequence)oldText)) >= 0) {
            text = StringUtil.replaceSubSequence((CharSequence)text, (int)index, (int)(index + oldText.length()), (CharSequence)newText);
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(21);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getElementHtmlHighlighting(@NotNull PsiElement element, @NotNull String name, @Nullable JSType type) {
        if (element == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(22);
        }
        if (name == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(23);
        }
        if (!DumbService.isDumb((Project)element.getProject()) && StringUtil.isJavaIdentifier((String)name)) {
            TextPlaceholder placeholder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(type, false, TYPE_PLACEHOLDER);
            String prefix = "var ";
            String fakeText = prefix + name + (String)(type == null ? "" : TYPE_SEPARATOR + placeholder.getHolderText());
            int startOffset = prefix.length();
            int endOffset = fakeText.length();
            TextRange range = TextRange.create((int)prefix.length(), (int)(prefix.length() + name.length()));
            CharSequence result2 = JSHtmlHighlightingUtil.tryGetHtmlHighlighting(element = JSHtmlHighlightingUtil.getPreferableContext(element, type), fakeText, range, startOffset, endOffset);
            if (result2 != null) {
                result2 = JSHtmlHighlightingUtil.replaceSubSequence(result2, STYLE_ITALIC, "");
                CharSequence charSequence = placeholder.restoreText(result2);
                if (charSequence == null) {
                    JSHtmlHighlightingUtil.$$$reportNull$$$0(24);
                }
                return charSequence;
            }
        }
        String string = name + TYPE_SEPARATOR + JSHtmlHighlightingUtil.getSimpleTypeWithLinkText(type, false);
        if (string == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Contract(value="!null,_->!null")
    private static PsiElement getPreferableContext(@Nullable PsiElement element, @Nullable JSType type) {
        PsiElement sourceElement;
        if (type != null && !(type instanceof JSPrimitiveType) && (sourceElement = type.getSourceElement()) != null && DialectDetector.isTypeScript(sourceElement)) {
            element = sourceElement;
        }
        return element;
    }

    @NotNull
    public static CharSequence getFunctionHtmlHighlighting(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, boolean hasFunctionKeyword, @NotNull CharSequence modifiers, @NotNull CharSequence argumentsAndReturn, @NotNull List<TextPlaceholder> holders) {
        if (functionItem == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(26);
        }
        if (escapedName == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(27);
        }
        if (modifiers == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(28);
        }
        if (argumentsAndReturn == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(29);
        }
        if (holders == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(30);
        }
        String prefix = hasFunctionKeyword ? "" : "class Foo { ";
        String fakeText = prefix + modifiers + NAME_PLACEHOLDER + argumentsAndReturn;
        int startOffset = prefix.length();
        int endOffset = fakeText.length();
        TextRange range = TextRange.create((int)(prefix.length() + modifiers.length()), (int)(modifiers.length() + prefix.length() + NAME_PLACEHOLDER.length()));
        Object result2 = JSHtmlHighlightingUtil.tryGetHtmlHighlighting((PsiElement)functionItem, fakeText, range, startOffset, endOffset);
        if (result2 != null) {
            result2 = JSHtmlHighlightingUtil.replaceSubSequence((CharSequence)result2, STYLE_ITALIC, "");
            result2 = JSHtmlHighlightingUtil.replaceSubSequence((CharSequence)result2, NAME_PLACEHOLDER, escapedName);
        } else {
            result2 = modifiers + escapedName + argumentsAndReturn;
        }
        for (TextPlaceholder holder : holders) {
            result2 = holder.restoreText((CharSequence)result2);
        }
        Object object = result2;
        if (object == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(31);
        }
        return object;
    }

    @Nullable
    public static JSType parseType(@NotNull String typeText, @NotNull PsiElement context2) {
        PsiElement typePsi;
        if (typeText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(32);
        }
        if (context2 == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(33);
        }
        if ((typePsi = JSChangeUtil.tryCreateTypeElement(typeText, context2)) instanceof JSTypeDeclaration && !PsiUtilCore.hasErrorElementChild((PsiElement)typePsi) && typeText.length() == typePsi.getTextLength()) {
            return ((JSTypeDeclaration)typePsi).getJSType();
        }
        return null;
    }

    @NotNull
    public static CharSequence getTypeWithLinksHtmlHighlighting(@Nullable JSType type, @Nullable PsiElement context2, boolean hasFiredEvents) {
        int endOffset;
        int startOffset;
        if ((context2 = JSHtmlHighlightingUtil.getPreferableContext(context2, type)) == null) {
            return JSHtmlHighlightingUtil.getSimpleTypeWithLinkText(type, hasFiredEvents);
        }
        String prefix = "var $$Name$$: ";
        TextPlaceholder placeholder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(type, false, TYPE_PLACEHOLDER);
        String fakeText = prefix + placeholder.getHolderText();
        CharSequence result2 = JSHtmlHighlightingUtil.tryGetHtmlHighlighting(context2, fakeText, null, startOffset = prefix.length(), endOffset = fakeText.length());
        if (result2 != null) {
            result2 = JSHtmlHighlightingUtil.replaceSubSequence(result2, STYLE_ITALIC, "");
            CharSequence charSequence = placeholder.restoreText(result2);
            if (charSequence == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(34);
            }
            return charSequence;
        }
        return JSHtmlHighlightingUtil.getSimpleTypeWithLinkText(type, hasFiredEvents);
    }

    @NotNull
    public static String getSimpleTypeWithLinkText(@Nullable JSType type, boolean hasFiredEvents) {
        if (type == null) {
            return "any";
        }
        JSLinkTypeTextStringBuilder builder2 = new JSLinkTypeTextStringBuilder(hasFiredEvents);
        type.buildTypeText(JSType.TypeTextFormat.PRESENTABLE, builder2);
        String string = builder2.getResult();
        if (string == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static Language getLanguageForHighlighting(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(36);
        }
        if (DialectDetector.isJavaScript(context2)) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.FLOW_JS;
            if (jSLanguageDialect == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(37);
            }
            return jSLanguageDialect;
        }
        Language language = context2.getLanguage();
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(38);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 24, 25, 31, 34, 35, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementOrContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeText";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierRange";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeFile";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolderPrefix";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsAndReturn";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubSequence";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementHtmlHighlighting";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionHtmlHighlighting";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithLinksHtmlHighlighting";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleTypeWithLinkText";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryGetHtmlHighlighting";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlightName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationsRangeIterator";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "highlightSemanticKeywords";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithLinksPlaceholder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFullTypeWithLinksPlaceholder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryGetHtmlHighlightingForName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleHolder";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementHtmlHighlighting";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionHtmlHighlighting";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForHighlighting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 24, 25, 31, 34, 35, 37, 38 -> new IllegalStateException(string);
        };
    }

    static class RangeWithAttributes
    implements QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo {
        private final int startOffset;
        private final int endOffset;
        private final TextAttributesKey textAttributesKey;

        RangeWithAttributes(int startOffset, int endOffset, TextAttributesKey textAttributesKey) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.textAttributesKey = textAttributesKey;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        @Nullable
        public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                RangeWithAttributes.$$$reportNull$$$0(0);
            }
            return scheme.getAttributes(this.textAttributesKey);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$RangeWithAttributes", "getTextAttributes"));
        }
    }

    static class HighlightInfoAdapter
    implements QuickDocSyntaxHighlightingHandler.QuickDocHighlightInfo {
        private final PsiFile myContext;
        private final HighlightInfo myHighlightInfo;

        HighlightInfoAdapter(@NotNull PsiFile context2, HighlightInfo info) {
            if (context2 == null) {
                HighlightInfoAdapter.$$$reportNull$$$0(0);
            }
            this.myContext = context2;
            this.myHighlightInfo = info;
        }

        public int getStartOffset() {
            return this.myHighlightInfo.getStartOffset();
        }

        public int getEndOffset() {
            return this.myHighlightInfo.getEndOffset();
        }

        @Nullable
        public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                HighlightInfoAdapter.$$$reportNull$$$0(1);
            }
            return this.myHighlightInfo.getTextAttributes((PsiElement)this.myContext, scheme);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$HighlightInfoAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTextAttributes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TextPlaceholder {
        @NotNull
        public CharSequence getHolderText();

        public CharSequence restoreText(@NotNull CharSequence var1);
    }
}

