/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.Strings;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum JavaScriptHighlightDescriptor implements JSHighlightDescriptor
{
    KEYWORD(DefaultLanguageHighlighterColors.KEYWORD, "javascript.keyword"),
    STRING(DefaultLanguageHighlighterColors.STRING, "javascript.string"),
    NUMBER(DefaultLanguageHighlighterColors.NUMBER, "javascript.number"),
    REGEXP(DefaultLanguageHighlighterColors.STRING, "javascript.regexp"),
    LINE_COMMENT(DefaultLanguageHighlighterColors.LINE_COMMENT, "javascript.linecomment"),
    BLOCK_COMMENT(DefaultLanguageHighlighterColors.BLOCK_COMMENT, "javascript.blockcomment"),
    DOC_COMMENT(DefaultLanguageHighlighterColors.DOC_COMMENT, "jsdoc.text"),
    OPERATION_SIGN(DefaultLanguageHighlighterColors.OPERATION_SIGN, "javascript.operation"),
    PARENTHESES(DefaultLanguageHighlighterColors.PARENTHESES, "javascript.parens"),
    BRACKETS(DefaultLanguageHighlighterColors.BRACKETS, "javascript.brackets"),
    BRACES(DefaultLanguageHighlighterColors.BRACES, "javascript.braces"),
    COMMA(DefaultLanguageHighlighterColors.COMMA, "javascript.comma"),
    DOT(DefaultLanguageHighlighterColors.DOT, "javascript.dot"),
    SEMICOLON(DefaultLanguageHighlighterColors.SEMICOLON, "javascript.semicolon"),
    BAD_CHARACTER(HighlighterColors.BAD_CHARACTER, "javascript.badcharacter"),
    DOC_TAG(DefaultLanguageHighlighterColors.DOC_COMMENT_TAG, "jsdoc.tag"),
    DOC_TAG_NAMEPATH(DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE, "jsdoc.tag.namepath"),
    DOC_TYPE(DOC_TAG_NAMEPATH, "jsdoc.type"),
    VALID_STRING_ESCAPE(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE, "javascript.valid.string.escape"),
    INVALID_STRING_ESCAPE(DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE, "javascript.invalid.string.escape"),
    LOCAL_VARIABLE(DefaultLanguageHighlighterColors.LOCAL_VARIABLE, "javascript.local.variable"),
    PARAMETER(DefaultLanguageHighlighterColors.PARAMETER, "javascript.parameter"),
    INSTANCE_MEMBER_VARIABLE(DefaultLanguageHighlighterColors.INSTANCE_FIELD, "javascript.instance.member.variable"),
    STATIC_MEMBER_VARIABLE(DefaultLanguageHighlighterColors.STATIC_FIELD, "javascript.static.member.variable"),
    GLOBAL_VARIABLE(DefaultLanguageHighlighterColors.GLOBAL_VARIABLE, "javascript.global.variable"),
    GLOBAL_FUNCTION(DefaultLanguageHighlighterColors.FUNCTION_DECLARATION, "javascript.global.function"),
    LOCAL_FUNCTION(DefaultLanguageHighlighterColors.FUNCTION_DECLARATION, "javascript.local.function"),
    DECORATOR(DefaultLanguageHighlighterColors.METADATA, "javascript.global.decorator"),
    STATIC_MEMBER_FUNCTION(DefaultLanguageHighlighterColors.STATIC_METHOD, "javascript.static.member.function"),
    INSTANCE_MEMBER_FUNCTION(DefaultLanguageHighlighterColors.INSTANCE_METHOD, "javascript.instance.member.function"),
    CLASS(DefaultLanguageHighlighterColors.CLASS_NAME, "javascript.class"),
    INTERFACE(DefaultLanguageHighlighterColors.INTERFACE_NAME, "javascript.interface"),
    TYPE_ALIAS(INTERFACE, "typescript.type.alias.name"),
    LABEL(DefaultLanguageHighlighterColors.LABEL, "javascript.label"),
    MODULE_NAME(DefaultLanguageHighlighterColors.IDENTIFIER, "javascript.module.name"),
    FUNCTION_ARROW(DefaultLanguageHighlighterColors.OPERATION_SIGN, "javascript.function.arrow"),
    PRIMITIVE_TYPE(KEYWORD, "typescript.primitive.types.name"),
    EXPORTED_VARIABLE(GLOBAL_VARIABLE, "javascript.exported.variable"),
    EXPORTED_FUNCTION(GLOBAL_FUNCTION, "javascript.exported.function"),
    EXPORTED_CLASS(CLASS, "javascript.exported.class"),
    JSX_CLIENT_COMPONENT(XmlHighlighterColors.XML_CUSTOM_TAG_NAME, "javascript.jsx.client.component"),
    TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS(DefaultLanguageHighlighterColors.BRACES, "javascript.template.literal.placeholder.delimiters");

    @Nullable
    private TextAttributesKey myBaseKey;
    @Nullable
    private final JavaScriptHighlightDescriptor myBaseDescriptor;
    @NotNull
    @PropertyKey(resourceBundle="messages.JavaScriptBundle")
    private final @NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String myMessageKey;

    private JavaScriptHighlightDescriptor(JavaScriptHighlightDescriptor baseDescriptor, String messageKey) {
        if (baseDescriptor == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(0);
        }
        if (messageKey == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(1);
        }
        this.myBaseKey = null;
        this.myBaseDescriptor = baseDescriptor;
        this.myMessageKey = messageKey;
    }

    private JavaScriptHighlightDescriptor(TextAttributesKey baseKey, String messageKey) {
        if (baseKey == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(2);
        }
        if (messageKey == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(3);
        }
        this.myBaseKey = baseKey;
        this.myBaseDescriptor = null;
        this.myMessageKey = messageKey;
    }

    @NotNull
    public TextAttributesKey getOrCreateTextAttributesKey() {
        TextAttributesKey baseKey = this.myBaseKey;
        if (baseKey == null) {
            this.myBaseKey = baseKey = Objects.requireNonNull(this.myBaseDescriptor).getOrCreateTextAttributesKey();
        }
        String externalIdSuffix = switch (this) {
            case BAD_CHARACTER -> "BADCHARACTER";
            case PARENTHESES -> "PARENTHS";
            case PRIMITIVE_TYPE -> "PRIMITIVE.TYPE";
            case EXPORTED_VARIABLE -> "EXPORTED.VARIABLE";
            case EXPORTED_FUNCTION -> "EXPORTED.FUNCTION";
            case EXPORTED_CLASS -> "EXPORTED.CLASS";
            default -> this.toString();
        };
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)("JS." + externalIdSuffix), (TextAttributesKey)baseKey);
        if (textAttributesKey == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(4);
        }
        return textAttributesKey;
    }

    @NotNull
    public @PropertyKey(resourceBundle="messages.JavaScriptBundle") String getMessageKey() {
        String string = this.myMessageKey;
        if (string == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDebugName() {
        if (this == INSTANCE_MEMBER_FUNCTION) {
            return "instance method";
        }
        if (this == INSTANCE_MEMBER_VARIABLE) {
            return "instance field";
        }
        if (this == STATIC_MEMBER_FUNCTION) {
            return "static method";
        }
        if (this == STATIC_MEMBER_VARIABLE) {
            return "static field";
        }
        String string = Strings.toLowerCase((String)JavaScriptBundle.message(this.myMessageKey, new Object[0]));
        if (string == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public TextAttributesKey getAttributesKey(@NotNull JSHighlighter highlighter) {
        if (highlighter == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(7);
        }
        TextAttributesKey textAttributesKey = highlighter.getMappedKey(this.getOrCreateTextAttributesKey());
        if (textAttributesKey == null) {
            JavaScriptHighlightDescriptor.$$$reportNull$$$0(8);
        }
        return textAttributesKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDescriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseKey";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JavaScriptHighlightDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JavaScriptHighlightDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTextAttributesKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

