/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.MessageStreamLogger;
import com.intellij.lang.javascript.service.MessageStreamLoggerService;
import com.intellij.lang.javascript.service.MessageStreamLoggerServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/service/LoggerBucket;", "", "fileName", "", "<init>", "(Ljava/lang/String;)V", "lock", "Ljava/lang/Object;", "activeLoggers", "", "Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "connect", "cleanup", "", "millisToPrintableTime", "millis", "", "containsLogger", "", "logger", "disconnect", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nMessageStreamLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/LoggerBucket\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n14#2:126\n14#2:132\n1755#3,3:127\n1863#3,2:130\n1755#3,3:133\n*S KotlinDebug\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/LoggerBucket\n*L\n49#1:126\n115#1:132\n56#1:127,3\n95#1:130,2\n85#1:133,3\n*E\n"})
final class LoggerBucket {
    @NotNull
    private final String fileName;
    @NotNull
    private final Object lock;
    @NotNull
    private final List<MessageStreamLogger> activeLoggers;

    public LoggerBucket(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.lock = new Object();
        this.activeLoggers = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final MessageStreamLogger connect() {
        Object object = this.lock;
        synchronized (object) {
            block9: {
                boolean bl = false;
                if (this.activeLoggers.size() < 5) break block9;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(LoggerBucket.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot create a logger for " + this.fileName + ", too many active loggers");
                MessageStreamLogger messageStreamLogger = null;
                return messageStreamLogger;
            }
            long currentTimeMillis = System.currentTimeMillis();
            String newFileName = null;
            while (true) {
                boolean bl;
                block10: {
                    newFileName = this.fileName + "-" + this.millisToPrintableTime(currentTimeMillis) + ".log";
                    Iterable $this$any$iv = this.activeLoggers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MessageStreamLogger it = (MessageStreamLogger)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)((Object)it.getLogPath$intellij_javascript_impl().getFileName()).toString(), (Object)newFileName)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    Path path2 = MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p().resolve(newFileName);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    if (!Files.exists(path2, new LinkOption[0])) break;
                }
                long l = currentTimeMillis;
                currentTimeMillis = l + 1L;
            }
            Files.createDirectories(MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p(), new FileAttribute[0]);
            Path path3 = MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p().resolve(newFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path logPath = path3;
            MessageStreamLogger logger = new MessageStreamLogger(logPath);
            this.activeLoggers.add(logger);
            ApplicationKt.getApplication().executeOnPooledThread(() -> LoggerBucket.connect$lambda$2$lambda$1(this));
            MessageStreamLogger messageStreamLogger = logger;
            return messageStreamLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        Regex fileNamePattern = new Regex(this.fileName + "-\\d{8}-\\d{6}-\\d{3}\\.log");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            List<Object> files = Files.list(MessageStreamLoggerServiceKt.access$getLOG_PATH_DIR$p()).filter(arg_0 -> LoggerBucket.cleanup$lambda$7$lambda$5(arg_0 -> LoggerBucket.cleanup$lambda$7$lambda$4(fileNamePattern, this, arg_0), arg_0)).sorted().toList();
            int toKeep = 5 - this.activeLoggers.size();
            if (toKeep >= files.size()) {
                return;
            }
            int toRemove = Math.min(files.size(), files.size() - toKeep);
            Intrinsics.checkNotNull(files);
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)files, (int)toRemove);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                Files.deleteIfExists(it);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String millisToPrintableTime(long millis) {
        String string = MessageStreamLoggerServiceKt.access$getLOG_FILENAME_SUFFIX_FORMAT$p().format(MessageStreamLoggerServiceKt.millisToDate(millis));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsLogger(@NotNull MessageStreamLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.activeLoggers.contains(logger);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect(@NotNull MessageStreamLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.close$intellij_javascript_impl();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.activeLoggers.remove(logger)) {
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(MessageStreamLoggerService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.error("Logger " + logger.getLogPath$intellij_javascript_impl().getFileName() + " was not registered.");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void connect$lambda$2$lambda$1(LoggerBucket this$0) {
        this$0.cleanup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean cleanup$lambda$7$lambda$4(Regex $fileNamePattern, LoggerBucket this$0, Path it) {
        MessageStreamLogger activeLogger;
        String fileName = ((Object)it.getFileName()).toString();
        if (!$fileNamePattern.matches((CharSequence)fileName)) return false;
        Iterable $this$any$iv = this$0.activeLoggers;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            activeLogger = (MessageStreamLogger)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)((Object)activeLogger.getLogPath$intellij_javascript_impl().getFileName()).toString(), (Object)fileName));
        return false;
    }

    private static final boolean cleanup$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

