/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action.before;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.before.TypeScriptCompileBeforeRunTask;
import com.intellij.lang.typescript.compiler.action.before.TypeScriptCompileBeforeTaskDialog;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileBeforeRunTaskProvider
extends BeforeRunTaskProvider<TypeScriptCompileBeforeRunTask>
implements DumbAware {
    public static final Key<TypeScriptCompileBeforeRunTask> ID = Key.create((String)"TypeScript.Before.Run");

    public Key<TypeScriptCompileBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Typescript.CompileTypeScript;
    }

    public String getName() {
        return JavaScriptBundle.message("typescript.compiler.before.run", new Object[0]);
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public TypeScriptCompileBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Project project;
        if (runConfiguration == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        if ((project = runConfiguration.getProject()) == null || project.isDefault()) {
            return null;
        }
        if (!TypeScriptCompileBeforeRunTaskProvider.isServiceOrCompilerEnabled(project)) {
            return null;
        }
        return new TypeScriptCompileBeforeRunTask();
    }

    private static boolean isServiceOrCompilerEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.useService();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull TypeScriptCompileBeforeRunTask task) {
        Project project;
        TypeScriptCompileBeforeTaskDialog dialog;
        if (runConfiguration == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (task == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if ((dialog = new TypeScriptCompileBeforeTaskDialog(project = runConfiguration.getProject(), task.isFailOnError(), task.getConfigPath())).showAndGet()) {
            task.setFailOnError(dialog.isFailOnError());
            task.setConfigPath(dialog.getConfigPath());
            return true;
        }
        return false;
    }

    public boolean executeTask(final @NotNull DataContext context2, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull TypeScriptCompileBeforeRunTask task) {
        VirtualFile configFile;
        Project project;
        if (context2 == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (env == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (task == null) {
            TypeScriptCompileBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if ((project = configuration.getProject()) == null) {
            return true;
        }
        if (!TypeScriptCompileBeforeRunTaskProvider.isServiceOrCompilerEnabled(project)) {
            return true;
        }
        String path2 = task.getConfigPath();
        boolean isEmptyPath = StringUtil.isEmptyOrSpaces((String)path2);
        VirtualFile virtualFile = configFile = isEmptyPath ? null : LocalFileSystem.getInstance().findFileByPath(path2);
        if (!(isEmptyPath || configFile != null && configFile.getFileType() instanceof TypeScriptConfigFileType)) {
            ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)"Run", (String)"Compile TypeScript", (Throwable)new ExecutionException(JavaScriptBundle.message("dialog.message.cannot.compile.typescript.config.file.incorrect", new Object[0])));
            return false;
        }
        final Ref hasErrors = Ref.create((Object)false);
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                new TypeScriptCompileAllAction(){

                    @Override
                    @NotNull
                    protected Collection<VirtualFile> getConfigsForProcessing(Project project) {
                        ApplicationManager.getApplication().assertReadAccessAllowed();
                        if (configFile != null) {
                            List list = ContainerUtil.createMaybeSingletonList((Object)configFile);
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return list;
                        }
                        Collection<VirtualFile> collection = super.getConfigsForProcessing(project);
                        if (collection == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return collection;
                    }

                    @Override
                    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
                        if (project == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return configFile != null || super.canUseOnlyConfigs(project, settings);
                    }

                    @Override
                    protected void release() {
                        targetDone.up();
                    }

                    @Override
                    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<? extends JSAnnotationError> infos) {
                        if (manager == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (infos == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        manager.logProjectErrors(new ArrayList<JSAnnotationError>(infos), (Boolean)hasErrors.get());
                    }

                    @Override
                    protected void logErrors(Project project, Collection<? extends JSAnnotationError> infos) {
                        if (!infos.isEmpty()) {
                            for (JSAnnotationError jSAnnotationError : infos) {
                                if (!"error".equalsIgnoreCase(jSAnnotationError.getCategory())) continue;
                                hasErrors.set((Object)true);
                                break;
                            }
                        }
                        super.logErrors(project, infos);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 2, 3, 4 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "manager";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "infos";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getConfigsForProcessing";
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "canUseOnlyConfigs";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray;
                                objectArray[2] = "logErrors";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 2, 3, 4 -> new IllegalArgumentException(string);
                        };
                    }
                }.runCompile(project, context2);
            }
        }, ModalityState.nonModal());
        targetDone.waitFor(TimeUnit.SECONDS.toMillis(40L));
        return !task.isFailOnError() || (Boolean)hasErrors.get() == false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

