/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructure;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructureBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeunitTestLocationProvider
implements SMTestLocator {
    private static final Logger LOG = Logger.getInstance(NodeunitTestLocationProvider.class);
    private static final String PROTOCOL = "nodeunit";
    private final File myWorkingDirectory;

    public NodeunitTestLocationProvider(@NotNull File workingDirectory) {
        if (workingDirectory == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(0);
        }
        this.myWorkingDirectory = workingDirectory;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (path == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(4);
        }
        if (!PROTOCOL.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                NodeunitTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> parts = NodeunitTestLocationProvider.decodePath(path);
        if (parts.isEmpty()) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                NodeunitTestLocationProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        JSFile jsFile = this.findJSFile(project, parts.get(0));
        if (jsFile == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                NodeunitTestLocationProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        ExportsTestFileStructure structure = (ExportsTestFileStructure)ExportsTestFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        PsiElement testPsiElement = structure.findPsiElement(parts.subList(1, parts.size()));
        PsiElement navResult = (PsiElement)ObjectUtils.notNull((Object)testPsiElement, (Object)jsFile);
        Location psiLocation = PsiLocation.fromPsiElement((PsiElement)navResult);
        List<Location> list = Collections.singletonList(psiLocation);
        if (list == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private JSFile findJSFile(@NotNull Project project, @NotNull String moduleName) {
        File file;
        if (project == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (moduleName == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(10);
        }
        if (!((String)moduleName).endsWith(".js")) {
            moduleName = (String)moduleName + ".js";
        }
        if ((file = new File(this.myWorkingDirectory, (String)moduleName)).isFile()) {
            VirtualFile jsVFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (jsVFile == null || !jsVFile.exists()) {
                jsVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            }
            if (jsVFile != null && jsVFile.exists()) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                PsiFile psiFile = psiManager.findFile(jsVFile);
                return (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
            }
        }
        return null;
    }

    private static List<String> decodePath(@NotNull String s) {
        if (s == null) {
            NodeunitTestLocationProvider.$$$reportNull$$$0(11);
        }
        ArrayList<String> path = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ':') {
                char nextChar;
                int j = i + 1;
                boolean ok = false;
                if (j < s.length() && ((nextChar = s.charAt(j)) == ',' || nextChar == ':')) {
                    builder.append(nextChar);
                    ++i;
                    ok = true;
                }
                if (ok) continue;
                LOG.warn("Found malformed nodeunit locationHint data '" + s + "' at index " + i + ".");
                return Collections.emptyList();
            }
            if (ch == ',') {
                path.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(ch);
        }
        path.add(builder.toString());
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findJSFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "decodePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

