/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import git4idea.DialogManager;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GHLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHLoginModel;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.GHPluginProjectScopeProvider;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a:\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\n0\u000e\u00a2\u0006\u0002\b\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a(\u0010\u0012\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a(\u0010\u0017\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a(\u0010\u0018\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "getAccountManager", "()Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "configure", "", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "dialog", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "scopedDialog", "D", "project", "Lcom/intellij/openapi/project/Project;", "dialogConstructor", "Lkotlin/Function1;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "loginWithToken", "model", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;", "parentComponent", "Ljava/awt/Component;", "loginWithOAuth", "loginWithOAuthOrToken", "promptOAuthLogin", "", "request", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHAccountsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHAccountsUtil.kt\norg/jetbrains/plugins/github/authentication/GHAccountsUtilKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,298:1\n40#2,3:299\n1#3:302\n31#4,2:303\n*S KotlinDebug\n*F\n+ 1 GHAccountsUtil.kt\norg/jetbrains/plugins/github/authentication/GHAccountsUtilKt\n*L\n39#1:299,3\n216#1:303,2\n*E\n"})
public final class GHAccountsUtilKt {
    private static final GHAccountManager getAccountManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (GHAccountManager)((Object)object);
    }

    private static final void configure(GHLoginRequest $this$configure, GHLoginDialog dialog) {
        block2: {
            Object it;
            Throwable throwable = $this$configure.getError();
            if (throwable != null) {
                it = throwable;
                boolean bl = false;
                dialog.setError((Throwable)it);
            }
            GithubServerPath githubServerPath = $this$configure.getServer();
            if (githubServerPath != null) {
                it = githubServerPath;
                boolean bl = false;
                String string = ((GithubServerPath)it).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                dialog.setServer(string, $this$configure.isServerEditable());
            }
            String string = $this$configure.getLogin();
            if (string == null) break block2;
            it = string;
            boolean bl = false;
            dialog.setLogin((String)it, $this$configure.isLoginEditable());
        }
    }

    private static final <D extends GHLoginDialog> D scopedDialog(Project project, Function1<? super CoroutineScope, ? extends D> dialogConstructor) {
        if (project != null) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GHPluginProjectScopeProvider> serviceClass$iv = GHPluginProjectScopeProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (D)((Object)((GHLoginDialog)((GHPluginProjectScopeProvider)((Object)object)).constructDialog("GitHub login dialog", dialogConstructor)));
        }
        CoroutineScope coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        String string = GHLoginDialog.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CoroutineScope cs = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
        GHLoginDialog dialog = (GHLoginDialog)((Object)dialogConstructor.invoke((Object)cs));
        Disposable disposable = ((DialogWrapper)dialog).getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        CoroutineUtilKt.cancelledWith((CoroutineScope)cs, (Disposable)disposable);
        return (D)((Object)dialog);
    }

    private static final void loginWithToken(GHLoginRequest $this$loginWithToken, GHLoginModel model2, Project project, Component parentComponent) {
        GHLoginDialog.Token dialog = (GHLoginDialog.Token)((Object)GHAccountsUtilKt.scopedDialog(project, arg_0 -> GHAccountsUtilKt.loginWithToken$lambda$4(model2, project, parentComponent, $this$loginWithToken, arg_0)));
        DialogManager.show((DialogWrapper)dialog);
    }

    private static final void loginWithOAuth(GHLoginRequest $this$loginWithOAuth, GHLoginModel model2, Project project, Component parentComponent) {
        GHLoginDialog.OAuth dialog = (GHLoginDialog.OAuth)((Object)GHAccountsUtilKt.scopedDialog(project, arg_0 -> GHAccountsUtilKt.loginWithOAuth$lambda$6(model2, project, parentComponent, $this$loginWithOAuth, arg_0)));
        DialogManager.show((DialogWrapper)dialog);
    }

    private static final void loginWithOAuthOrToken(GHLoginRequest $this$loginWithOAuthOrToken, GHLoginModel model2, Project project, Component parentComponent) {
        switch (GHAccountsUtilKt.promptOAuthLogin($this$loginWithOAuthOrToken, project, parentComponent)) {
            case 0: {
                GHAccountsUtilKt.loginWithOAuth($this$loginWithOAuthOrToken, model2, project, parentComponent);
                break;
            }
            case 1: {
                GHAccountsUtilKt.loginWithToken($this$loginWithOAuthOrToken, model2, project, parentComponent);
            }
        }
    }

    private static final int promptOAuthLogin(GHLoginRequest request2, Project project, Component parentComponent) {
        String string;
        if (PasswordSafe.Companion.getInstance().isMemoryOnly()) {
            string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().addText(CollaborationToolsBundle.message((String)"accounts.error.password-not-saved", (Object[])new Object[0]))).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.p().addText(CollaborationToolsBundle.message((String)"accounts.error.password-not-saved.solution", (Object[])new Object[0]))).toString();
        } else {
            string = request2.getText();
            if (string == null) {
                String string2 = GithubBundle.message("dialog.message.login.to.continue", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String message2 = string3;
        String string4 = GithubBundle.message("login.to.github", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        MessageDialogBuilder.YesNoCancel yesNoCancel = MessageDialogBuilder.Companion.yesNoCancel(string4, message2);
        String string5 = GithubBundle.message("login.via.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string5);
        String string6 = GithubBundle.message("button.use.token", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        MessageDialogBuilder.YesNoCancel builder = (MessageDialogBuilder.YesNoCancel)yesNoCancel2.noText(string6);
        if (PasswordSafe.Companion.getInstance().isMemoryOnly()) {
            builder.asWarning();
        }
        if (parentComponent != null) {
            return builder.show(parentComponent);
        }
        return builder.show(project);
    }

    private static final GHLoginDialog.Token loginWithToken$lambda$4(GHLoginModel $model, Project $project, Component $parentComponent, GHLoginRequest $this_loginWithToken, CoroutineScope $this$scopedDialog) {
        GHLoginDialog.Token token2;
        Intrinsics.checkNotNullParameter((Object)$this$scopedDialog, (String)"$this$scopedDialog");
        GHLoginDialog.Token it = token2 = new GHLoginDialog.Token($model, $project, $this$scopedDialog, $parentComponent);
        boolean bl = false;
        GHAccountsUtilKt.configure($this_loginWithToken, it);
        return token2;
    }

    private static final GHLoginDialog.OAuth loginWithOAuth$lambda$6(GHLoginModel $model, Project $project, Component $parentComponent, GHLoginRequest $this_loginWithOAuth, CoroutineScope $this$scopedDialog) {
        GHLoginDialog.OAuth oAuth;
        Intrinsics.checkNotNullParameter((Object)$this$scopedDialog, (String)"$this$scopedDialog");
        GHLoginDialog.OAuth it = oAuth = new GHLoginDialog.OAuth($model, $project, $this$scopedDialog, $parentComponent);
        boolean bl = false;
        GHAccountsUtilKt.configure($this_loginWithOAuth, it);
        return oAuth;
    }

    public static final /* synthetic */ GHAccountManager access$getAccountManager() {
        return GHAccountsUtilKt.getAccountManager();
    }

    public static final /* synthetic */ void access$loginWithToken(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithToken($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$loginWithOAuth(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithOAuth($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$loginWithOAuthOrToken(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithOAuthOrToken($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ GHLoginDialog access$scopedDialog(Project project, Function1 dialogConstructor) {
        return GHAccountsUtilKt.scopedDialog(project, dialogConstructor);
    }
}

