/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.diagnostic.JdbcLogSettings;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.text.StringKt;
import java.util.logging.Level;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/actions/diagnostic/JdbcLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getTarget", "Lcom/intellij/database/dataSource/LocalDataSource;", "actionPerformed", "editSettings", "Lcom/intellij/database/actions/diagnostic/JdbcLogSettings;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "createPresetGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "configArea", "Lcom/intellij/ui/components/JBTextArea;", "getLogLevels", "", "Ljava/util/logging/Level;", "()[Ljava/util/logging/Level;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nJdbcLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcLogAction.kt\ncom/intellij/database/actions/diagnostic/JdbcLogAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class JdbcLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LocalDataSource ds = this.getTarget(e);
        e.getPresentation().setEnabledAndVisible(ds != null);
    }

    private final LocalDataSource getTarget(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return (LocalDataSource)DatabaseContextFun.getSelectedDataSources(dataContext).filterMap(arg_0 -> JdbcLogAction.getTarget$lambda$1(JdbcLogAction::getTarget$lambda$0, arg_0)).single();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block2: {
            JdbcLogSettings jdbcLogSettings;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            LocalDataSource localDataSource = this.getTarget(e);
            if (localDataSource == null) {
                return;
            }
            LocalDataSource ds = localDataSource;
            JdbcLogSettings settings = new JdbcLogSettings(false, null, null, null, null, false, 63, null);
            settings.load(ds);
            JdbcLogSettings jdbcLogSettings2 = this.editSettings(project2, settings);
            if (jdbcLogSettings2 == null) break block2;
            JdbcLogSettings $this$actionPerformed_u24lambda_u242 = jdbcLogSettings = jdbcLogSettings2;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u242.save(ds);
            SessionsUtil.deactivateDataSourceAsync$default(project2, ds, null, 4, null);
        }
    }

    private final JdbcLogSettings editSettings(Project project, JdbcLogSettings settings) {
        JdbcLogSettings newSettings = JdbcLogSettings.copy$default(settings, false, null, null, null, null, false, 63, null);
        JBTextArea configArea = new JBTextArea(settings.getConfig());
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> JdbcLogAction.editSettings$lambda$20(newSettings, this, project, configArea, arg_0));
        DialogBuilder dialog = new DialogBuilder();
        dialog.setCenterPanel((JComponent)panel2);
        dialog.setTitle(DatabaseBundle.message("dialog.title.jdbc.log.settings", new Object[0]));
        if (!dialog.showAndGet()) {
            return null;
        }
        String string = configArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        newSettings.setConfig(((Object)StringsKt.trim((CharSequence)string)).toString());
        return newSettings;
    }

    private final DefaultActionGroup createPresetGroup(JBTextArea configArea) {
        DefaultActionGroup predef = new DefaultActionGroup(DatabaseBundle.message("action.log.presets.text", new Object[0]), null, AllIcons.Actions.AddFile);
        predef.setPopup(true);
        String string = DatabaseBundle.message("action.log.to.file.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        predef.add((AnAction)JdbcLogAction.createPresetGroup$createPresetAction(configArea, string, "handlers=java.util.logging.FileHandler\njava.util.logging.FileHandler.level=ALL\njava.util.logging.FileHandler.pattern=%t/jdbc-%u-%g.log\njava.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter"));
        String string2 = DatabaseBundle.message("action.log.to.idea.log.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        predef.add((AnAction)JdbcLogAction.createPresetGroup$createPresetAction(configArea, string2, "handlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.level=ALL"));
        return predef;
    }

    private final Level[] getLogLevels() {
        Level[] levelArray = new Level[]{Level.ALL, Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, null};
        return levelArray;
    }

    private static final LocalDataSource getTarget$lambda$0(RawDataSource it) {
        return it instanceof LocalDataSource ? (LocalDataSource)it : null;
    }

    private static final LocalDataSource getTarget$lambda$1(Function1 $tmp0, Object p0) {
        return (LocalDataSource)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit editSettings$lambda$20$lambda$9$lambda$4(JBLabel label, String value, int n) {
        void it;
        String string;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        String string2 = string = value;
        JBLabel jBLabel = label;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        boolean bl2 = ((CharSequence)it).length() > 0;
        String string3 = bl2 ? string : null;
        if (string3 == null) {
            String string4 = DatabaseBundle.message("label.disabled", new Object[0]);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        jBLabel.setText(string3);
        return Unit.INSTANCE;
    }

    private static final void editSettings$lambda$20$lambda$9$lambda$5(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final Unit editSettings$lambda$20$lambda$9$lambda$6(JdbcLogSettings $newSettings, String it) {
        String string = it;
        if (string == null) {
            string = "";
        }
        $newSettings.setDebugSsl(string);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit editSettings$lambda$20$lambda$9(JdbcLogSettings $newSettings, Row $this$row) {
        void $this$editSettings_u24lambda_u2420_u24lambda_u249_u24lambda_u248_u24lambda_u247;
        FixedComboBoxEditor fixedComboBoxEditor;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = new Cell[]{"", "all", "ssl", "ssl:handshake"};
        Cell $this$editSettings_u24lambda_u2420_u24lambda_u249_u24lambda_u248 = cell = ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)new DefaultComboBoxModel<String>((E[])cell), (ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> JdbcLogAction.editSettings$lambda$20$lambda$9$lambda$5(JdbcLogAction::editSettings$lambda$20$lambda$9$lambda$4, arg_0, arg_1, arg_2))), (Function0)((Function0)new MutablePropertyReference0Impl($newSettings){

            public Object get() {
                return ((JdbcLogSettings)this.receiver).getDebugSsl();
            }

            public void set(Object value) {
                ((JdbcLogSettings)this.receiver).setDebugSsl((String)value);
            }
        }), arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$9$lambda$6($newSettings, arg_0));
        boolean bl = false;
        ((ComboBox)$this$editSettings_u24lambda_u2420_u24lambda_u249_u24lambda_u248.getComponent()).setEditable(true);
        FixedComboBoxEditor fixedComboBoxEditor2 = fixedComboBoxEditor = new FixedComboBoxEditor();
        ComboBox comboBox = (ComboBox)$this$editSettings_u24lambda_u2420_u24lambda_u249_u24lambda_u248.getComponent();
        boolean bl2 = false;
        $this$editSettings_u24lambda_u2420_u24lambda_u249_u24lambda_u248_u24lambda_u247.getField().getEmptyText().setText(DatabaseBundle.message("label.disabled", new Object[0]));
        comboBox.setEditor((ComboBoxEditor)fixedComboBoxEditor);
        ((ComboBox)$this$editSettings_u24lambda_u2420_u24lambda_u249_u24lambda_u248.getComponent()).setSelectedItem((Object)$newSettings.getDebugSsl());
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20$lambda$10(JdbcLogSettings $newSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("checkbox.enabled", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($newSettings){

            public Object get() {
                return ((JdbcLogSettings)this.receiver).getEnabled();
            }

            public void set(Object value) {
                ((JdbcLogSettings)this.receiver).setEnabled((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20$lambda$11(JdbcLogSettings $newSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("checkbox.capture.output.to.log", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($newSettings){

            public Object get() {
                return ((JdbcLogSettings)this.receiver).getCaptureStdout();
            }

            public void set(Object value) {
                ((JdbcLogSettings)this.receiver).setCaptureStdout((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20$lambda$14$lambda$12(JBLabel label, Level value, int n) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Object object = value;
        if (object == null || (object = ((Level)object).getName()) == null) {
            String string = DatabaseBundle.message("do.not.set", new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        label.setText((String)object);
        return Unit.INSTANCE;
    }

    private static final void editSettings$lambda$20$lambda$14$lambda$13(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final Unit editSettings$lambda$20$lambda$14(JdbcLogAction this$0, JdbcLogSettings $newSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)new DefaultComboBoxModel<Level>(this$0.getLogLevels()), (ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> JdbcLogAction.editSettings$lambda$20$lambda$14$lambda$13(JdbcLogAction::editSettings$lambda$20$lambda$14$lambda$12, arg_0, arg_1, arg_2))), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($newSettings){

            public Object get() {
                return ((JdbcLogSettings)this.receiver).getJdbcLevel();
            }

            public void set(Object value) {
                ((JdbcLogSettings)this.receiver).setJdbcLevel((Level)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final String editSettings$lambda$20$lambda$17$lambda$15(JdbcLogSettings $newSettings) {
        String string = $newSettings.getPath();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final Unit editSettings$lambda$20$lambda$17$lambda$16(JdbcLogSettings $newSettings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $newSettings.setPath(StringKt.nullize$default((String)it, (boolean)false, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20$lambda$17(Project $project, JdbcLogSettings $newSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DatabaseBundle.message("dialog.title.log.files.location", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, (Project)$project, null, (int)4, null).align((Align)AlignX.FILL.INSTANCE), () -> JdbcLogAction.editSettings$lambda$20$lambda$17$lambda$15($newSettings), arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$17$lambda$16($newSettings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20$lambda$18(JBTextArea $configArea, JdbcLogAction this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AnAction[] anActionArray = new AnAction[]{this$0.createPresetGroup($configArea)};
        $this$row.cell(ActionUtil.createToolbarComponent((JComponent)((JComponent)$configArea), (String)"toolbar", (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (boolean)true));
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20$lambda$19(JBTextArea $configArea, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextAreaKt.columns((Cell)TextAreaKt.rows((Cell)$this$row.scrollCell((JComponent)$configArea).align(Align.FILL), (int)8), (int)50);
        return Unit.INSTANCE;
    }

    private static final Unit editSettings$lambda$20(JdbcLogSettings $newSettings, JdbcLogAction this$0, Project $project, JBTextArea $configArea, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = DatabaseBundle.message("ssl.logging", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$9($newSettings, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$10($newSettings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$11($newSettings, arg_0), (int)1, null);
        String string2 = DatabaseBundle.message("driver.log.level", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$14(this$0, $newSettings, arg_0));
        String string3 = DatabaseBundle.message("driver.log.extra.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$17($project, $newSettings, arg_0));
        String string4 = DatabaseBundle.message("custom.configuration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$18($configArea, this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JdbcLogAction.editSettings$lambda$20$lambda$19($configArea, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createPresetGroup$createPresetAction$lambda$21(JBTextArea $configArea, String $text, AnActionEvent it) {
        $configArea.setText($text);
        return Unit.INSTANCE;
    }

    private static final void createPresetGroup$createPresetAction$lambda$22(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final DumbAwareAction createPresetGroup$createPresetAction(JBTextArea $configArea, String name2, String text) {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)name2, arg_0 -> JdbcLogAction.createPresetGroup$createPresetAction$lambda$22(arg_0 -> JdbcLogAction.createPresetGroup$createPresetAction$lambda$21($configArea, text, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return dumbAwareAction;
    }
}

