/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dbimport.ErrorTaskInfo;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettingsComponent
implements ImportComponent<ImportSettingsComponentInfo, Object> {
    protected static final int GAP = JBUIScale.scale((int)5);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss");
    protected final JCheckBox myHandleErrorCheckBox;
    protected final TextFieldWithBrowseButton myErrorOutput;
    private final JCheckBox myModalityStateCheckBox;
    private boolean myModalityStateCheckBoxState = ImportSettings.getImportModality();
    private final JCheckBox myInsertAsNullCheckBox;
    private String myCurrentTableName;
    private final JPanel myPanel = new JPanel((LayoutManager)new VerticalStackLayout());

    public ImportSettingsComponent(@Nullable String initialTargetTableName) {
        this.myHandleErrorCheckBox = new JBCheckBox(DatabaseBundle.message("checkbox.write.errors.to.file", new Object[0]));
        this.myModalityStateCheckBox = new JBCheckBox(DatabaseBundle.message("checkbox.disable.indexes.triggers.lock.table.may.be.faster", new Object[0]));
        this.myInsertAsNullCheckBox = new JBCheckBox(DatabaseBundle.message("checkbox.insert.inconvertible.values.as.null", new Object[0]));
        this.myErrorOutput = new TextFieldWithBrowseButton();
        this.myCurrentTableName = initialTargetTableName;
        this.myErrorOutput.setText(this.getDefaultText((String)ObjectUtils.chooseNotNull((Object)ImportSettings.getErrorDirectory(), (Object)SystemProperties.getUserHome())));
        this.configureComponents();
        this.addComponents();
    }

    @Nullable
    public String getErrorOutputFilePath() {
        return this.myErrorOutput.isEnabled() ? ImportSettingsComponent.sanitize(this.myErrorOutput.getText()) : null;
    }

    protected void addComponents() {
        ImportSettingsComponent.addStrut(this.myPanel);
        JPanel errorOutputPanel = this.createErrorOutputSettingsPanel();
        this.myPanel.add(errorOutputPanel);
        ImportSettingsComponent.addStrut(this.myPanel);
        this.myPanel.add(this.myInsertAsNullCheckBox);
        ImportSettingsComponent.addStrut(this.myPanel);
        this.myPanel.add(this.myModalityStateCheckBox);
    }

    @NotNull
    protected JPanel createErrorOutputSettingsPanel() {
        JPanel errorOutputPanel = new JPanel(new BorderLayout());
        errorOutputPanel.add((Component)this.myHandleErrorCheckBox, "West");
        errorOutputPanel.add((Component)this.myErrorOutput, "Center");
        JPanel jPanel = errorOutputPanel;
        if (jPanel == null) {
            ImportSettingsComponent.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ImportSettingsComponent.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder, @NotNull ImportEditorContext context) {
        if (builder == null) {
            ImportSettingsComponent.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ImportSettingsComponent.$$$reportNull$$$0(3);
        }
        String path = this.getErrorOutputFilePath();
        builder.errorTaskInfo(new ErrorTaskInfo((ThrowableComputable<Writer, IOException>)((ThrowableComputable)() -> path == null ? null : new FileWriter(path, StandardCharsets.UTF_8)), path)).insertAsNull(this.myInsertAsNullCheckBox.isSelected()).lockTable(this.myModalityStateCheckBox.isSelected());
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            ImportSettingsComponent.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            ImportSettingsComponent.$$$reportNull$$$0(5);
        }
    }

    @Override
    @NotNull
    public CompletionStage<Object> notifyChanged(@NotNull ImportSettingsComponentInfo object) {
        boolean modalityChanges;
        if (object == null) {
            ImportSettingsComponent.$$$reportNull$$$0(6);
        }
        boolean supportsFastMode = object.myContext.getImportType(object.myTableName).tableExists() && object.myContext.getManager().isSupportFastMode();
        boolean bl = modalityChanges = supportsFastMode != this.myModalityStateCheckBox.isEnabled();
        if (modalityChanges) {
            this.myModalityStateCheckBox.setEnabled(supportsFastMode);
            if (supportsFastMode) {
                this.myModalityStateCheckBox.setSelected(this.myModalityStateCheckBoxState);
            } else {
                this.myModalityStateCheckBoxState = this.myModalityStateCheckBox.isSelected();
                this.myModalityStateCheckBox.setSelected(false);
            }
        }
        this.myCurrentTableName = object.myTableName;
        this.updateFileName();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            ImportSettingsComponent.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    private void updateFileName() {
        String directory = ImportSettings.getErrorDirectory(this.myErrorOutput.getText());
        this.myErrorOutput.setText(this.getDefaultText(directory));
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            ImportSettingsComponent.$$$reportNull$$$0(8);
        }
        return false;
    }

    public static void addStrut(@NotNull JPanel panel2) {
        if (panel2 == null) {
            ImportSettingsComponent.$$$reportNull$$$0(9);
        }
        panel2.add(Box.createVerticalStrut(GAP));
    }

    protected void configureComponents() {
        boolean errors = ImportSettings.getWriteErrors();
        this.myErrorOutput.setEnabled(errors);
        this.myErrorOutput.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(true, true, false, false, false, false)){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (chosenFile.isDirectory()) {
                    ImportSettingsComponent.this.myErrorOutput.setText(ImportSettingsComponent.this.getDefaultText(chosenFile.getPath()));
                    return;
                }
                ImportSettingsComponent.this.myErrorOutput.setText(chosenFile.getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/database/dbimport/ui/ImportSettingsComponent$1", "onFileChosen"));
            }
        });
        this.myHandleErrorCheckBox.setSelected(errors);
        this.myInsertAsNullCheckBox.setSelected(ImportSettings.getInsertAsNull());
        this.myHandleErrorCheckBox.addItemListener(e -> this.myErrorOutput.setEnabled(this.myHandleErrorCheckBox.isSelected()));
    }

    @NotNull
    private String getDefaultText(@NotNull String directory) {
        if (directory == null) {
            ImportSettingsComponent.$$$reportNull$$$0(10);
        }
        String string = directory + File.separator + (String)(this.myCurrentTableName == null ? "" : this.myCurrentTableName + "_") + DATE_FORMAT.format(LocalDateTime.now()) + ".txt";
        if (string == null) {
            ImportSettingsComponent.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static String sanitize(@Nullable String path) {
        if (path == null) {
            return null;
        }
        String parent = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        String extension = FileUtilRt.getExtension((String)fileName);
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)fileName);
        return parent + File.separator + FileUtil.sanitizeFileName((String)nameWithoutExtension) + (String)(StringUtil.isEmpty((String)extension) ? "" : "." + FileUtil.sanitizeFileName((String)extension));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/ImportSettingsComponent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorOutputSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/ImportSettingsComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addStrut";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    public static class ImportSettingsComponentInfo {
        final String myTableName;
        final ImportEditorContext myContext;

        public ImportSettingsComponentInfo(@NotNull String tableName, @NotNull ImportEditorContext context) {
            if (tableName == null) {
                ImportSettingsComponentInfo.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ImportSettingsComponentInfo.$$$reportNull$$$0(1);
            }
            this.myTableName = tableName;
            this.myContext = context;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tableName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ui/ImportSettingsComponent$ImportSettingsComponentInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

