/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"calculateLineOffsets", "", "text", "", "createVirtualFilePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "intellij.database.impl"})
public final class SqlProgramSourceKt {
    @NotNull
    public static final int[] calculateLineOffsets(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        IntArrayList buf = new IntArrayList();
        buf.add(0);
        int n = text.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (text.charAt(i2) != '\n') continue;
            buf.add(i2 + 1);
        }
        int[] nArray = buf.toIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
        return nArray;
    }

    @NotNull
    public static final XSourcePosition createVirtualFilePosition(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPosition(file, line);
        Intrinsics.checkNotNull((Object)xSourcePosition);
        return xSourcePosition;
    }
}

