/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.ui.DbmsOutputOptionProvider;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.Db2DbmsOutputHandler;
import com.intellij.database.dialects.base.DbmsOutputHandler;
import com.intellij.database.dialects.base.DumbDbmsOutputNothingDoer;
import com.intellij.database.dialects.base.OracleDbmsOutputHandler;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000bH\u0002R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u000b*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "initStateFor", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "updateStateFor", "sessionIfSupported", "getSessionIfSupported", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/database/console/session/DatabaseSession;", "ifSupported", "getIfSupported", "(Lcom/intellij/database/console/session/DatabaseSession;)Lcom/intellij/database/console/session/DatabaseSession;", "dbmsOutputState", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getDbmsOutputState", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)Z", "Companion", "MyDataAuditor", "intellij.database.dialects.base.ex"})
@SourceDebugExtension(value={"SMAP\nProcessDbmsOutputAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1863#2:239\n1864#2:241\n1#3:240\n*S KotlinDebug\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction\n*L\n39#1:239\n39#1:241\n*E\n"})
public final class ProcessDbmsOutputAction
extends ToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<MyDataAuditor> DBMS_LISTENER;

    public ProcessDbmsOutputAction() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            Iterable $this$forEach$iv = DatabaseSessionManager.getSessions(project2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseSession it;
                DatabaseSession session = (DatabaseSession)element$iv;
                boolean bl = false;
                if (this.getIfSupported(session) == null) continue;
                boolean bl2 = false;
                this.initStateFor(it);
            }
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DatabaseSession.Companion.getTopic(), (Object)new DatabaseSessionStateListener.Adapter(){

            @Override
            public void stateChanged(DatabaseSessionStateListener.ChangeEvent session) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    if (session.getType() != DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED) break block1;
                    DatabaseSession databaseSession = session.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)databaseSession, (String)"getSession(...)");
                    DatabaseSession databaseSession2 = this.getIfSupported(databaseSession);
                    if (databaseSession2 != null) {
                        DatabaseSession databaseSession3 = databaseSession2;
                        ProcessDbmsOutputAction processDbmsOutputAction = this;
                        DatabaseSession it = databaseSession3;
                        boolean bl = false;
                        processDbmsOutputAction.initStateFor(it);
                    }
                }
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DatabaseSession session = this.getSessionIfSupported(e);
        e.getPresentation().setEnabledAndVisible(session != null);
        if (session != null) {
            super.update(e);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DatabaseSession databaseSession = this.getSessionIfSupported(e);
        return (databaseSession != null ? (MyDataAuditor)databaseSession.getUserData(DBMS_LISTENER) : null) != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DatabaseSession databaseSession = this.getSessionIfSupported(e);
            if (databaseSession == null) break block0;
            DatabaseSession it = databaseSession;
            boolean bl = false;
            this.updateStateFor(it, state);
        }
    }

    private final void initStateFor(DatabaseSession session) {
        Object object = session.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTarget(...)");
        if (this.getDbmsOutputState((DatabaseConnectionPoint)object)) {
            this.updateStateFor(session, true);
        }
    }

    private final void updateStateFor(DatabaseSession session, boolean state) {
        block1: {
            block0: {
                if (!state) break block0;
                MyDataAuditor listener2 = new MyDataAuditor(session);
                Disposer.register((Disposable)session, (Disposable)listener2);
                session.getMessageBus().addAuditor(listener2);
                session.putUserData(DBMS_LISTENER, listener2);
                break block1;
            }
            MyDataAuditor myDataAuditor = (MyDataAuditor)session.getUserData(DBMS_LISTENER);
            if (myDataAuditor == null) break block1;
            MyDataAuditor listener3 = myDataAuditor;
            boolean bl = false;
            session.putUserData(DBMS_LISTENER, null);
            Disposer.dispose((Disposable)listener3);
        }
    }

    private final DatabaseSession getSessionIfSupported(AnActionEvent $this$sessionIfSupported) {
        DatabaseSession databaseSession = DatabaseSessionManager.findSession($this$sessionIfSupported);
        return databaseSession != null ? this.getIfSupported(databaseSession) : null;
    }

    private final DatabaseSession getIfSupported(DatabaseSession $this$ifSupported) {
        DatabaseSession databaseSession;
        DatabaseSession it = databaseSession = $this$ifSupported;
        boolean bl = false;
        return DbImplUtil.supportsDbmsOutput(((DatabaseConnectionPoint)$this$ifSupported.getTarget()).getDbms()) ? databaseSession : null;
    }

    private final boolean getDbmsOutputState(DatabaseConnectionPoint $this$dbmsOutputState) {
        return Intrinsics.areEqual(DbOptionProvider.getOptionValue($this$dbmsOutputState, DbmsOutputOptionProvider.class), (Object)true);
    }

    static {
        Key key2 = Key.create((String)"DBMS_LISTENER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        DBMS_LISTENER = key2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$Companion;", "", "<init>", "()V", "DBMS_LISTENER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getConnection", "(Lcom/intellij/database/datagrid/DataRequest$Context;)Lcom/intellij/database/dataSource/DatabaseConnection;", "intellij.database.dialects.base.ex"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DatabaseConnection getConnection(@NotNull DataRequest.Context $this$connection) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$connection), (String)"<this>");
            DataProducer dataProducer = $this$connection.producer;
            JdbcEngine jdbcEngine = dataProducer instanceof JdbcEngine ? (JdbcEngine)dataProducer : null;
            return jdbcEngine != null ? jdbcEngine.getCurrentConnectionIfReady() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0082\bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "Lcom/intellij/database/datagrid/DataAuditor;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "helper", "Lcom/intellij/database/dialects/base/DbmsOutputHandler;", "handle", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "call", "Lkotlin/Function0;", "beforeStatement", "requestFinished", "dispose", "intellij.database.dialects.base.ex"})
    @SourceDebugExtension(value={"SMAP\nProcessDbmsOutputAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor\n*L\n1#1,238:1\n62#1,7:239\n62#1,7:246\n*S KotlinDebug\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor\n*L\n72#1:239,7\n86#1:246,7\n*E\n"})
    private static final class MyDataAuditor
    implements DataAuditor,
    Disposable {
        @NotNull
        private final DatabaseSession session;
        @NotNull
        private final DbmsOutputHandler helper;

        public MyDataAuditor(@NotNull DatabaseSession session) {
            DbmsOutputHandler dbmsOutputHandler;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
            Dbms dbms = ((DatabaseConnectionPoint)this.session.getTarget()).getDbms();
            if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.ORACLE)) {
                dbmsOutputHandler = new OracleDbmsOutputHandler();
            } else if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.DB2_LUW)) {
                Dbms dbms2 = ((DatabaseConnectionPoint)this.session.getTarget()).getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
                dbmsOutputHandler = new Db2DbmsOutputHandler(dbms2);
            } else {
                dbmsOutputHandler = DumbDbmsOutputNothingDoer.INSTANCE;
            }
            this.helper = dbmsOutputHandler;
        }

        private final void handle(DataRequest.Context context, Function0<Unit> call) {
            boolean $i$f$handle = false;
            try {
                call.invoke();
            }
            catch (Exception e) {
                context.error(e);
            }
        }

        @Override
        public void beforeStatement(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection2 = databaseConnection;
            MyDataAuditor this_$iv = this;
            boolean $i$f$handle = false;
            try {
                boolean bl = false;
                DbmsOutputHandler.enable$default(this.helper, connection2, 0, 2, null);
            }
            catch (Exception e$iv) {
                context.error(e$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection2 = databaseConnection;
            try {
                this.helper.processOutput(connection2, (Function1<? super String, Unit>)((Function1)arg_0 -> MyDataAuditor.requestFinished$lambda$1(context, arg_0)));
            }
            catch (SQLException this_$iv) {
            }
            catch (Exception e) {
                context.error(e);
            }
            finally {
                MyDataAuditor this_$iv = this;
                boolean $i$f$handle = false;
                try {
                    boolean bl = false;
                    this.helper.disable(connection2);
                }
                catch (Exception e$iv) {
                    context.error(e$iv);
                }
            }
        }

        public void dispose() {
        }

        private static final Unit requestFinished$lambda$1(DataRequest.Context $context, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            $context.warn(line, true);
            return Unit.INSTANCE;
        }
    }
}

