/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JdbcSourceLoader {
    public static final DbmsExtension<JdbcSourceLoader> EP = new DbmsExtension("com.intellij.database.jdbcSourceLoader");
    private static final Logger LOG = Logger.getInstance(JdbcSourceLoader.class);
    protected final Dbms myDbms;

    protected JdbcSourceLoader(@NotNull Dbms dbms) {
        if (dbms == null) {
            JdbcSourceLoader.$$$reportNull$$$0(0);
        }
        this.myDbms = dbms;
    }

    public void loadSources(@NotNull Iterable<BasicModSourceAware> objects, @NotNull DatabaseConnectionCore connection2) {
        if (objects == null) {
            JdbcSourceLoader.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            JdbcSourceLoader.$$$reportNull$$$0(2);
        }
        Exception first2 = null;
        Exception last = null;
        int count = 0;
        BasicModSourceAware any = (BasicModSourceAware)Iterables.getFirst(objects, null);
        if (any == null) {
            return;
        }
        for (BasicModSourceAware object : objects) {
            try {
                this.loadSource(object, connection2);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                object.setSourceText(null);
                if (first2 == null) {
                    first2 = e;
                } else {
                    last = e;
                }
                ++count;
            }
        }
        if (count != 0) {
            LOG.warn("Failed to load: " + count + " sources.\nFirst exception:\n" + ExceptionUtil.getUserStackTrace(first2, (Logger)LOG) + (last == null ? null : "Last exception:\n" + ExceptionUtil.getUserStackTrace(last, (Logger)LOG)));
        }
    }

    public void loadSource(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (object == null) {
            JdbcSourceLoader.$$$reportNull$$$0(3);
        }
        if (connection2 == null) {
            JdbcSourceLoader.$$$reportNull$$$0(4);
        }
        Dbms dbms = connection2.getDbms();
        ObjectKind k = object.getKind();
        ObjectKind p2 = DasUtil.getKind(object.getParent());
        boolean wasSet = false;
        if (p2 == ObjectKind.PACKAGE && k == ObjectKind.BODY) {
            wasSet = this.loadPackage(object, connection2, true);
        } else if (k == ObjectKind.PACKAGE) {
            wasSet = this.loadPackage(object, connection2, false);
        } else if ((p2 == ObjectKind.SCHEMA || dbms.isSybase() && p2 == ObjectKind.PACKAGE) && k == ObjectKind.ROUTINE) {
            wasSet = this.loadRoutine(object, connection2);
        } else if (p2 == ObjectKind.SCHEMA && k == ObjectKind.VIEW) {
            wasSet = this.loadView(object, connection2);
        }
        if (!wasSet) {
            JdbcSourceLoader.applySourceText(object, null, false);
        }
    }

    protected boolean loadView(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws SQLException {
        if (object == null) {
            JdbcSourceLoader.$$$reportNull$$$0(5);
        }
        if (connection2 == null) {
            JdbcSourceLoader.$$$reportNull$$$0(6);
        }
        if (!this.supportsViewDefinition() || !(object instanceof DasTable)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtilCore.ConcatenationProps> query = this.sqlViewDefinition(object);
        if (query == null) {
            return false;
        }
        StringBuilder res2 = new StringBuilder();
        DbImplUtilCore.concatStringResults(connection2, dbms, 0, (String)query.first, res2, (DbImplUtilCore.ConcatenationProps)query.second);
        if (res2.length() == 0) {
            return false;
        }
        JdbcSourceLoader.applySourceText(object, res2, dbms.isMysql() || dbms.isH2() || dbms.isHsqldb() || dbms.isPostgres());
        return true;
    }

    public abstract boolean supportsViewDefinition();

    @Nullable
    public abstract Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject var1);

    protected boolean loadRoutine(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (object == null) {
            JdbcSourceLoader.$$$reportNull$$$0(7);
        }
        if (connection2 == null) {
            JdbcSourceLoader.$$$reportNull$$$0(8);
        }
        if (!this.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        String source = this.tryToLoadProcedureDefinition((DasRoutine)((Object)object), connection2);
        if (StringUtil.isNotEmpty((String)source)) {
            JdbcSourceLoader.applySourceText(object, source, dbms.isHsqldb());
            return true;
        }
        Pair<String, DbImplUtilCore.ConcatenationProps> query = this.sqlProcedureDefinition((DasRoutine)((Object)object));
        StringBuilder res2 = new StringBuilder();
        int length = res2.length();
        if ((res2 = DbImplUtilCore.concatStringResults(connection2, dbms, (String)query.first, 0, res2, (DbImplUtilCore.ConcatenationProps)query.second)).length() == length) {
            return false;
        }
        JdbcSourceLoader.applySourceText(object, res2, dbms.isHsqldb());
        return true;
    }

    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (proc == null) {
            JdbcSourceLoader.$$$reportNull$$$0(9);
        }
        if (connection2 == null) {
            JdbcSourceLoader.$$$reportNull$$$0(10);
        }
        return "";
    }

    protected abstract boolean supportsProcedureDefinition();

    private boolean loadPackage(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2, boolean body2) throws SQLException {
        if (object == null) {
            JdbcSourceLoader.$$$reportNull$$$0(11);
        }
        if (connection2 == null) {
            JdbcSourceLoader.$$$reportNull$$$0(12);
        }
        if (!this.supportsPackageDefinition()) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtilCore.ConcatenationProps> query = body2 ? this.sqlPackageBodyDefinition(object) : this.sqlPackageDefinition(object);
        StringBuilder res2 = new StringBuilder("CREATE ");
        int length = res2.length();
        if (length == (res2 = DbImplUtilCore.concatStringResults(connection2, dbms, (String)query.first, 0, res2, (DbImplUtilCore.ConcatenationProps)query.second)).length()) {
            return false;
        }
        JdbcSourceLoader.applySourceText(object, res2, false);
        return true;
    }

    public boolean supportsPackageDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            JdbcSourceLoader.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("Package body definition is not supported");
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            JdbcSourceLoader.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException("Package definition is not supported");
    }

    @NotNull
    public abstract Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine var1);

    protected static void applySourceText(@NotNull BasicModSourceAware object, CharSequence text, boolean format) {
        if (object == null) {
            JdbcSourceLoader.$$$reportNull$$$0(15);
        }
        if (text != null && text.length() > 0) {
            SimpleCompositeText ct = new SimpleCompositeText(text, format ? CompositeText.Kind.DECOMPILED_TEXT : CompositeText.Kind.ORIGINAL_TEXT);
            object.setSourceText(ct);
        } else {
            object.setSourceText(null);
        }
    }

    @NotNull
    public static String str(@Nullable String s) {
        Object object = s == null ? "NULL" : "'" + s.replace("'", "''") + "'";
        if (object == null) {
            JdbcSourceLoader.$$$reportNull$$$0(16);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcSourceLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcSourceLoader";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadSources";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadView";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadRoutine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadPackage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applySourceText";
                break;
            }
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

