/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanRenderers;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlanView
implements Disposable {
    public static final ColumnInfo<?, ?> OPERATION_COLUMN = new NlsTreeColumnInfo(DatabaseBundle.messagePointer("PlanView.column.name.operation", new Object[0]));
    public static final MyColumnInfo<?> PARAMS_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.params", new Object[0]), PlanModel.GenericNode::getExtraInfo);
    public static final MyColumnInfo<? extends Number> NUM_ROWS_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.rows", new Object[0]), PlanModel.GenericNode::getPlanNumRows);
    public static final MyColumnInfo<? extends Number> ACTUAL_NUM_ROWS_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.actual.rows", new Object[0]), PlanModel.GenericNode::getActualNumRows);
    public static final MyColumnInfo<? extends Number> TOTAL_COST_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.total.cost", new Object[0]), PlanModel.GenericNode::getTotalCost);
    public static final MyColumnInfo<? extends Number> ACTUAL_TOTAL_TIME_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.actual.total.time", new Object[0]), PlanModel.GenericNode::getActualTotalTime);
    public static final MyColumnInfo<? extends Number> STARTUP_COST_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.startup.cost", new Object[0]), PlanModel.GenericNode::getStartupCost);
    public static final MyColumnInfo<? extends Number> ACTUAL_STARTUP_TIME_COLUMN = PlanView.col(DatabaseBundle.messagePointer("PlanView.column.name.actual.startup.time", new Object[0]), PlanModel.GenericNode::getActualStartupTime);
    public static final ColumnInfo<?, ?> RAW_DESC_COLUMN = new NlsColumnInfo<PlanTreeNode, String>(DatabaseBundle.messagePointer("PlanView.column.name.raw.desc", new Object[0])){

        @NotNull
        public String valueOf(PlanTreeNode node) {
            String string = node.getNode().getRawDescription();
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isCellEditable(PlanTreeNode node) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView$1", "valueOf"));
        }
    };
    private TreeTableView myTable;
    private final JScrollPane myScrollPane;
    private final TabbedPane myTabs;
    private final JComponent myPanel;
    private final Map<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>> myCharts;
    private final Project myProject;
    private final PlanRenderers.ActionRenderer myTreeRenderer;
    private final ActionToolbarImpl myToolbar;

    private static <T> MyColumnInfo<T> col(@NotNull Supplier<@NlsContexts.ColumnName String> title, @NotNull Function<PlanModel.GenericNode, T> value) {
        if (title == null) {
            PlanView.$$$reportNull$$$0(0);
        }
        if (value == null) {
            PlanView.$$$reportNull$$$0(1);
        }
        return new MyColumnInfo<T>(title, value);
    }

    public static ColumnInfo<?, ?>[] columnsFor(@NotNull PlanModel model) {
        if (model == null) {
            PlanView.$$$reportNull$$$0(2);
        }
        ArrayList<Object> res2 = new ArrayList<Object>();
        res2.add(OPERATION_COLUMN);
        res2.add(PARAMS_COLUMN);
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.NUM_ROWS)) {
            res2.add(NUM_ROWS_COLUMN);
            if (model.isActual()) {
                res2.add(ACTUAL_NUM_ROWS_COLUMN);
            }
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.TOTAL_COST)) {
            res2.add(TOTAL_COST_COLUMN);
            if (model.isActual()) {
                res2.add(ACTUAL_TOTAL_TIME_COLUMN);
            }
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.STARTUP_COST)) {
            res2.add(STARTUP_COST_COLUMN);
            if (model.isActual()) {
                res2.add(ACTUAL_STARTUP_TIME_COLUMN);
            }
        }
        res2.add(RAW_DESC_COLUMN);
        return res2.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    private PlanView(@NotNull Project project) {
        if (project == null) {
            PlanView.$$$reportNull$$$0(3);
        }
        this.myCharts = new HashMap<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>>();
        this.myProject = project;
        this.myTreeRenderer = new PlanRenderers.ActionRenderer(this.myProject);
        this.myScrollPane = ScrollPaneFactory.createScrollPane();
        this.myTabs = new JBTabsPaneImpl(project, 3, (Disposable)this);
        ActionGroup group = (ActionGroup)ActionManagerEx.getInstanceEx().getAction("PlanViewGroup");
        this.myToolbar = new ActionToolbarImpl("toolbar", group, false);
        this.myToolbar.setTargetComponent(this.myTabs.getComponent());
        BorderLayoutPanel panel2 = new BorderLayoutPanel();
        panel2.addToCenter((Component)this.myTabs.getComponent());
        this.myTabs.insertTab(DatabaseBundle.message("PlanView.tab.title.operations.tree", new Object[0]), null, (Component)this.myScrollPane, null, 0);
        panel2.addToLeft((Component)this.myToolbar);
        this.myToolbar.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)0, (int)1));
        this.myPanel = UiDataProvider.wrapComponent((JComponent)panel2, sink -> this.uiDataSnapshot(sink));
    }

    public void dispose() {
    }

    private static double getRendererWidth(JTable table, boolean header, int i2, int j) {
        TableCellRenderer renderer2;
        TableCellRenderer tableCellRenderer = renderer2 = header ? table.getColumnModel().getColumn(j).getHeaderRenderer() : table.getCellRenderer(i2, j);
        if (renderer2 == null && header) {
            renderer2 = table.getTableHeader().getDefaultRenderer();
        }
        if (renderer2 == null) {
            return 0.0;
        }
        Object value = header ? table.getColumnModel().getColumn(j).getHeaderValue() : table.getModel().getValueAt(i2, j);
        return renderer2.getTableCellRendererComponent(table, value, false, false, i2, j).getPreferredSize().getWidth();
    }

    public void setModel(@Nullable PlanModel model) {
        if (model != null) {
            Object[] columns = PlanView.columnsFor(model);
            this.myTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)PlanTreeNode.create(model.getRoot()), columns)){
                {
                    this.addMouseMotionListener(new MouseMotionAdapter(){

                        @Override
                        public void mouseMoved(MouseEvent e) {
                            this.dispatchByTree(e);
                        }
                    });
                    this.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            this.dispatchByTree(e);
                        }
                    });
                }

                public void setTableModel(TreeTableModel treeTableModel) {
                    super.setTableModel(treeTableModel);
                    final TreeTableTree tree2 = this.getTree();
                    tree2.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                        @Override
                        public void mouseMoved(MouseEvent e) {
                            int row = this.rowAtPoint(e.getPoint());
                            int col = this.columnAtPoint(e.getPoint());
                            if (row != -1 && col != -1) {
                                Rectangle rect = this.getCellRect(row, col, false);
                                this.repaint(rect);
                            }
                        }
                    });
                    tree2.addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            PlanView.dispatchMouseEventByTreeCell(e, tree2);
                        }
                    });
                }

                private void dispatchByTree(MouseEvent e) {
                    TreeTableTree tree2 = this.getTree();
                    int y = e.getY();
                    int row = this.rowAtPoint(e.getPoint());
                    int column2 = this.columnAtPoint(e.getPoint());
                    if (this.getRowHeight() != tree2.getRowHeight()) {
                        Rectangle tableCellRect = this.getCellRect(row, column2, true);
                        y = Math.min(y - tableCellRect.y, tree2.getRowHeight() - 1) + row * tree2.getRowHeight();
                    }
                    int x = e.getX() - this.getCellRect((int)0, (int)column2, (boolean)true).x;
                    tree2.dispatchEvent((AWTEvent)new MouseEvent((Component)tree2, e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            };
            this.myTable.getTree().addMouseListener((MouseListener)new MouseAdapter(){});
            this.myTable.putClientProperty(PlanView.class, (Object)this);
            this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        int row = PlanView.this.myTable.rowAtPoint(e.getPoint());
                        int col = PlanView.this.myTable.columnAtPoint(e.getPoint());
                        if (row >= 0 && col >= 0) {
                            PlanView.this.myTable.changeSelection(row, col, false, false);
                        }
                    }
                }
            });
            this.myTable.setTreeCellRenderer((TreeCellRenderer)this.myTreeRenderer);
            this.myTable.setRootVisible(false);
            this.myScrollPane.setViewportView((Component)this.myTable);
            this.myToolbar.setTargetComponent(this.myTabs.getComponent());
            TreeUtil.expandAll((JTree)this.myTable.getTree());
            FontMetrics metrics = this.myTable.getFontMetrics(this.myTable.getFont());
            int minWidth = metrics.stringWidth("XXXX");
            int spacing = metrics.stringWidth("X");
            for (int i2 = 0; i2 < columns.length; ++i2) {
                double size;
                if (columns[i2] == RAW_DESC_COLUMN) {
                    size = metrics.stringWidth("XXXXXXXXXXXX");
                } else {
                    size = this.myTable.getColumnModel().getColumn(i2).getMinWidth();
                    int count = this.myTable.getRowCount();
                    for (int j = 0; j != count; ++j) {
                        size = Math.max(size, PlanView.getRendererWidth((JTable)this.myTable, false, j, i2));
                    }
                    size = Math.max(size, PlanView.getRendererWidth((JTable)this.myTable, true, -1, i2) + (double)spacing);
                }
                this.myTable.getColumnModel().getColumn(i2).setPreferredWidth((int)size);
                this.myTable.getColumnModel().getColumn(i2).setMinWidth(minWidth);
            }
            this.myTable.revalidate();
            ActionManager actionManager = ActionManager.getInstance();
            ShowFullAction.INSTANCE.registerCustomShortcutSet(actionManager.getAction("ViewSource").getShortcutSet(), (JComponent)this.myTable);
            PopupHandler.installPopupMenu((JComponent)this.myTable, (ActionGroup)new DefaultActionGroup(new AnAction[]{ShowFullAction.INSTANCE}), (String)"QueryPlanTablePopup");
            Iterator<Map.Entry<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>>> it = this.myCharts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>> e = it.next();
                if (ArrayUtil.contains((Object)e.getKey(), (Object[])columns)) {
                    ((Consumer)e.getValue().second).consume((Object)model);
                    continue;
                }
                this.removeTab((Component)e.getValue().first);
                it.remove();
            }
        } else {
            this.myScrollPane.setViewportView(null);
            this.myToolbar.setTargetComponent(null);
            for (int i3 = this.myTabs.getTabCount(); i3 > 0; --i3) {
                this.myTabs.removeTabAt(i3);
            }
            this.myCharts.clear();
        }
    }

    private void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            PlanView.$$$reportNull$$$0(4);
        }
        sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
        sink.set(PlatformCoreDataKeys.SELECTED_ITEM, (Object)PlanView.getSelectedNode(this.myTable));
        sink.setNull(CommonDataKeys.VIRTUAL_FILE);
    }

    private static void dispatchMouseEventByTreeCell(MouseEvent e, TreeTableTree tree2) {
        TreeCellRenderer renderer2;
        int y;
        int x = e.getX();
        int row = tree2.getRowForLocation(x, y = e.getY());
        if (row >= 0 && (renderer2 = tree2.getCellRenderer()) != null) {
            TreePath path = tree2.getPathForRow(row);
            Object node = path.getLastPathComponent();
            Component component = renderer2.getTreeCellRendererComponent((JTree)tree2, node, tree2.isRowSelected(row), tree2.isExpanded(row), tree2.getModel().isLeaf(node), row, true);
            Rectangle bounds = tree2.getPathBounds(path);
            if (bounds != null) {
                component.setBounds(bounds);
                component.doLayout();
                Component at = SwingUtilities.getDeepestComponentAt(component, x - bounds.x, y - bounds.y);
                if (at != null) {
                    Component last = (Component)UIUtil.uiParents((Component)at, (boolean)false).last();
                    Point pt = SwingUtilities.convertPoint(last, x - bounds.x, y - bounds.y, at);
                    at.dispatchEvent(new MouseEvent(at, e.getID(), e.getWhen(), e.getModifiers(), pt.x, pt.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            }
        }
    }

    public void registerChart(MyColumnInfo<? extends Number> column2, Component comp, Consumer<PlanModel> updater) {
        this.myTabs.insertTab(DatabaseBundle.message("PlanView.tab.title.flame.chart", column2.getName()), null, comp, null, -1);
        this.myCharts.put(column2, (Pair<Component, Consumer<PlanModel>>)Pair.create((Object)comp, updater));
        int idx = this.findTabIdx(comp);
        if (idx != -1) {
            this.myTabs.setSelectedIndex(idx);
        }
    }

    public void removeChart(MyColumnInfo<? extends Number> column2) {
        Pair<Component, Consumer<PlanModel>> pair = this.myCharts.remove(column2);
        this.removeTab(pair == null ? null : (Component)pair.first);
    }

    public boolean hasChart(MyColumnInfo<? extends Number> column2) {
        return this.myCharts.containsKey(column2);
    }

    private int findTabIdx(@Nullable Component component) {
        if (component == null) {
            return -1;
        }
        int c2 = this.myTabs.getTabCount();
        for (int i2 = 0; i2 < c2; ++i2) {
            if (this.myTabs.getComponentAt(i2) != component) continue;
            return i2;
        }
        return -1;
    }

    private void removeTab(@Nullable Component component) {
        int idx = this.findTabIdx(component);
        if (idx != -1) {
            this.myTabs.removeTabAt(idx);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            PlanView.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            PlanView.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @NotNull
    public static PlanView createView(@NotNull Project project) {
        if (project == null) {
            PlanView.$$$reportNull$$$0(7);
        }
        return new PlanView(project);
    }

    @Nullable
    public static PlanView getPlanView(@NotNull DataContext context) {
        if (context == null) {
            PlanView.$$$reportNull$$$0(8);
        }
        TreeTableView table = PlanView.getTreeTable(context);
        return (PlanView)UIUtil.getClientProperty((Component)table, PlanView.class);
    }

    @Nullable
    public static PlanModel.GenericNode contextPlanNode(@NotNull DataContext context) {
        if (context == null) {
            PlanView.$$$reportNull$$$0(9);
        }
        return (PlanModel.GenericNode)ObjectUtils.tryCast((Object)PlatformCoreDataKeys.SELECTED_ITEM.getData(context), PlanModel.GenericNode.class);
    }

    @Nullable
    private static PlanModel.GenericNode getSelectedNode(TreeTableView c2) {
        PlanTreeNode node;
        Object item = ContainerUtil.getFirstItem((List)(c2 == null ? null : c2.getSelection()));
        if (c2 != null && item == null) {
            TreeTableTree tree2 = c2.getTree();
            item = tree2.getRowCount() > 0 ? tree2.getPathForRow(0).getLastPathComponent() : null;
        }
        return (node = (PlanTreeNode)ObjectUtils.tryCast((Object)item, PlanTreeNode.class)) == null ? null : node.getNode();
    }

    @Nullable
    private static TreeTableView getTreeTable(@NotNull DataContext context) {
        Component data;
        TreeTableView view;
        if (context == null) {
            PlanView.$$$reportNull$$$0(10);
        }
        if ((view = (TreeTableView)ObjectUtils.tryCast((Object)(data = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context)), TreeTableView.class)) != null) {
            return view;
        }
        JBTabs pane = (JBTabs)ObjectUtils.tryCast((Object)data, JBTabs.class);
        if (pane == null || pane.getTabCount() == 0) {
            return null;
        }
        return (TreeTableView)UIUtil.findComponentOfType((JComponent)pane.getTabAt(0).getComponent(), TreeTableView.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ui/PlanView";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ui/PlanView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "columnsFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlanView";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contextPlanNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTreeTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public static final class MyColumnInfo<T>
    extends NlsColumnInfo<PlanTreeNode, T> {
        private final Function<PlanModel.GenericNode, T> myValue;

        private MyColumnInfo(@NotNull Supplier<@NlsContexts.ColumnName String> title, @NotNull Function<PlanModel.GenericNode, T> value) {
            if (title == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            super(title);
            this.myValue = value;
        }

        @Nullable
        public T valueOf(PlanTreeNode node) {
            return (T)this.myValue.fun((Object)node.getNode());
        }

        @Nullable
        public Double doubleValueOf(PlanModel.GenericNode node) {
            Number res2 = (Number)ObjectUtils.tryCast((Object)this.myValue.fun((Object)node), Number.class);
            return res2 == null ? null : Double.valueOf(res2.doubleValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/plan/ui/PlanView$MyColumnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ShowFullAction
    extends DumbAwareAction {
        private static final AnAction INSTANCE = new ShowFullAction();

        ShowFullAction() {
            super(DatabaseBundle.message("action.PlanView.show.full.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreeTableView component;
            if (e == null) {
                ShowFullAction.$$$reportNull$$$0(0);
            }
            if ((component = PlanView.getTreeTable(e.getDataContext())) == null) {
                return;
            }
            int col = component.getSelectedColumn();
            int row = component.getSelectedRow();
            if (col < 0 || col >= component.getColumnCount() || row < 0 || row >= component.getRowCount()) {
                return;
            }
            String val = String.valueOf(component.getModel().getValueAt(row, col));
            if (StringUtil.isEmpty((String)val)) {
                return;
            }
            String title = String.valueOf(component.getColumnModel().getColumn(col).getHeaderValue());
            JTextArea text = new JTextArea(val);
            text.setLineWrap(true);
            text.setEditable(false);
            text.setSize(new Dimension(200, 200));
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)text, (boolean)true), (JComponent)text).setShowBorder(true).setResizable(true).setMovable(true).setTitle(title).setRequestFocus(true).setDimensionServiceKey(e.getProject(), "PlanView.ShowFull", false).createPopup();
            popup2.showInBestPositionFor(e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/plan/ui/PlanView$ShowFullAction", "actionPerformed"));
        }
    }

    public static class NlsTreeColumnInfo
    extends TreeColumnInfo {
        private final Supplier<@NlsContexts.ColumnName String> myName;

        public NlsTreeColumnInfo(@NotNull Supplier<@NlsContexts.ColumnName String> name2) {
            if (name2 == null) {
                NlsTreeColumnInfo.$$$reportNull$$$0(0);
            }
            super(name2.get());
            this.myName = name2;
        }

        public String getName() {
            return this.myName.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/plan/ui/PlanView$NlsTreeColumnInfo", "<init>"));
        }
    }

    public static abstract class NlsColumnInfo<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        private final Supplier<@NlsContexts.ColumnName String> myName;

        public NlsColumnInfo(@NotNull Supplier<@NlsContexts.ColumnName String> name2) {
            if (name2 == null) {
                NlsColumnInfo.$$$reportNull$$$0(0);
            }
            super(name2.get());
            this.myName = name2;
        }

        public String getName() {
            return this.myName.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/plan/ui/PlanView$NlsColumnInfo", "<init>"));
        }
    }
}

