/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbBookmark;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.database.view.DataSourceNode;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u001cH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/psi/DbBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getWeight", "", "getProject", "compare", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "createBookmark", "Lcom/intellij/database/psi/DbBookmark;", "map", "", "", "context", "", "id", "path", "Lcom/intellij/database/util/ObjectPath;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "dasObject", "Lcom/intellij/database/model/DasObject;", "url", "Ljavax/swing/tree/TreePath;", "element", "Lcom/intellij/database/psi/DbElement;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbBookmarkProvider.kt\ncom/intellij/database/psi/DbBookmarkProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class DbBookmarkProvider
implements BookmarkProvider {
    @NotNull
    private final Project project;

    public DbBookmarkProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Runnable runnable = () -> DbBookmarkProvider._init_$lambda$0(this);
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        SingleAlarm alarm2 = new SingleAlarm(runnable, 300, (Disposable)messageBus);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<DbPsiFacade.Listener> topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> DbBookmarkProvider._init_$lambda$1(alarm2, arg_0));
    }

    public int getWeight() {
        return 300;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        DbBookmark dbBookmark2;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        DbBookmark dbBookmark1 = bookmark1 instanceof DbBookmark ? (DbBookmark)bookmark1 : null;
        DbBookmark dbBookmark = dbBookmark2 = bookmark2 instanceof DbBookmark ? (DbBookmark)bookmark2 : null;
        if (dbBookmark1 == null && dbBookmark2 == null) {
            return 0;
        }
        if (dbBookmark1 == null) {
            return -1;
        }
        if (dbBookmark2 == null) {
            return 1;
        }
        ObjectPath p1 = dbBookmark1.getPath();
        ObjectPath p2 = dbBookmark2.getPath();
        if (p1 == null && p2 == null) {
            DbDataSource dbDataSource = dbBookmark1.getDataSource();
            DbDataSource dbDataSource2 = dbBookmark2.getDataSource();
            return StringUtil.naturalCompare((String)(dbDataSource != null ? dbDataSource.getName() : null), (String)(dbDataSource2 != null ? dbDataSource2.getName() : null));
        }
        if (p1 == null || p2 == null) {
            return p1 == null ? -1 : 1;
        }
        int result2 = StringUtil.naturalCompare((String)p1.name, (String)p2.name);
        if (result2 != 0) {
            return result2;
        }
        return p1.kind.compareTo(p2.kind);
    }

    @Nullable
    public DbBookmark createBookmark(@NotNull Map<String, String> map2) {
        DbBookmark dbBookmark;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        String string = map2.get("url");
        if (string != null) {
            String it = string;
            boolean bl = false;
            dbBookmark = this.createBookmark(it);
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    @Nullable
    public DbBookmark createBookmark(@Nullable Object context) {
        DbBookmark dbBookmark;
        Object object = context;
        if (object instanceof TreePath) {
            dbBookmark = this.createBookmark((TreePath)context);
        } else if (object instanceof DbElement) {
            dbBookmark = this.createBookmark((DbElement)context);
        } else if (object instanceof AbstractUrlFavoriteAdapter) {
            if (Intrinsics.areEqual((Object)((AbstractUrlFavoriteAdapter)context).getNodeProvider().getFavoriteTypeId(), (Object)"database")) {
                String string = ((AbstractUrlFavoriteAdapter)context).getURL();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
                dbBookmark = this.createBookmark(string);
            } else {
                dbBookmark = null;
            }
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    private final DbBookmark createBookmark(String id, ObjectPath path) {
        return new DbBookmark(this, id, path);
    }

    private final DbBookmark createBookmark(DasDataSource dataSource, DasObject dasObject) {
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        return this.createBookmark(string, ObjectPaths.of(dasObject));
    }

    private final DbBookmark createBookmark(String url) {
        DbBookmark dbBookmark;
        DatabaseVirtualFileSystem.FileDesc fileDesc = DatabaseVirtualFileSystem.parseUrl(url);
        if (fileDesc != null) {
            DatabaseVirtualFileSystem.FileDesc $this$createBookmark_u24lambda_u243 = fileDesc;
            boolean bl = false;
            if ($this$createBookmark_u24lambda_u243.family != null) {
                dbBookmark = null;
            } else {
                String string = $this$createBookmark_u24lambda_u243.dataSourceId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSourceId");
                dbBookmark = this.createBookmark(string, $this$createBookmark_u24lambda_u243.path);
            }
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    private final DbBookmark createBookmark(TreePath path) {
        DbBookmark dbBookmark;
        Object node = path.getLastPathComponent();
        if (node instanceof DataSourceNode) {
            dbBookmark = this.createBookmark(((DataSourceNode)node).rawDataSource, null);
        } else if (node instanceof DasObject) {
            DataSourceNode dataSourceNode = (DataSourceNode)TreeUtil.findObjectInPath((TreePath)path, DataSourceNode.class);
            if (dataSourceNode != null) {
                DataSourceNode $this$createBookmark_u24lambda_u244 = dataSourceNode;
                boolean bl = false;
                dbBookmark = this.createBookmark($this$createBookmark_u24lambda_u244.rawDataSource, (DasObject)node);
            } else {
                dbBookmark = null;
            }
        } else {
            dbBookmark = null;
        }
        return dbBookmark;
    }

    /*
     * WARNING - void declaration
     */
    private final DbBookmark createBookmark(DbElement element) {
        void it;
        DbElement dbElement;
        DbDataSource dbDataSource = element.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbElement dbElement2 = dbElement = element;
        DasDataSource dasDataSource = dbDataSource;
        DbBookmarkProvider dbBookmarkProvider = this;
        boolean bl = false;
        boolean bl2 = !(it instanceof DbDataSource);
        return dbBookmarkProvider.createBookmark(dasDataSource, bl2 ? dbElement : null);
    }

    private static final void _init_$lambda$0(DbBookmarkProvider this$0) {
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((BookmarksListener)messageBus.syncPublisher(topic)).structureChanged(null);
    }

    private static final void _init_$lambda$1(SingleAlarm $alarm, DbDataSource it) {
        SingleAlarm.cancelAndRequest$default((SingleAlarm)$alarm, (boolean)false, (int)1, null);
    }
}

