/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredDdlBuilder
extends DdlBuilder {
    protected EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
    protected final LinkedList<TextAttributes> myStack = new LinkedList();
    protected boolean myQuoteState;

    public ColoredDdlBuilder(StringBuilder sb) {
        super(sb);
    }

    public ColoredDdlBuilder() {
    }

    @NotNull
    public ColoredDdlBuilder pushStyle(TextAttributesKey key2) {
        ColoredDdlBuilder coloredDdlBuilder = this.pushStyle(this.scheme.getAttributes(key2));
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(0);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    public ColoredDdlBuilder pushStyle(@Nullable TextAttributes attributes) {
        this.myStack.addLast(attributes);
        if (attributes != null) {
            this.setAttributes(attributes, true);
        }
        ColoredDdlBuilder coloredDdlBuilder = this;
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(1);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    public ColoredDdlBuilder popStyle() {
        TextAttributes attributes = this.myStack.removeLast();
        if (attributes != null) {
            this.setAttributes(attributes, false);
        }
        ColoredDdlBuilder coloredDdlBuilder = this;
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(2);
        }
        return coloredDdlBuilder;
    }

    protected void setAttributes(@Nullable TextAttributes attributes, boolean enabled) {
        if (attributes == null) {
            return;
        }
        int fontType = attributes.getFontType();
        Color fg = attributes.getForegroundColor();
        if (enabled) {
            if (fg != null) {
                this.append("<font").append(" color=\"#").append(ColorUtil.toHex((Color)fg)).append("\"");
                Color bg = attributes.getBackgroundColor();
                if (bg != null) {
                    this.append(" bgcolor=\"#").append(ColorUtil.toHex((Color)bg)).append("\"");
                }
                this.append(">");
            }
            if ((fontType & 2) != 0) {
                this.append("<i>");
            }
            if ((fontType & 1) != 0) {
                this.append("<b>");
            }
        } else {
            if ((fontType & 1) != 0) {
                this.append("</b>");
            }
            if ((fontType & 2) != 0) {
                this.append("</i>");
            }
            if (fg != null) {
                this.append("</font>");
            }
        }
    }

    @Override
    @NotNull
    public ColoredDdlBuilder plain(@NotNull String text) {
        if (text == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(3);
        }
        ColoredDdlBuilder coloredDdlBuilder = (ColoredDdlBuilder)super.plain(text);
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(4);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    public ColoredDdlBuilder plain(@NotNull String text, @Nullable TextAttributesKey key2) {
        if (text == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(5);
        }
        ColoredDdlBuilder coloredDdlBuilder = this.pushStyle(key2).plain(text).popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(6);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    protected ColoredDdlBuilder append(@NotNull String text) {
        if (text == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(7);
        }
        ColoredDdlBuilder coloredDdlBuilder = (ColoredDdlBuilder)super.append(text);
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(8);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder keyword(@NotNull String keyword) {
        if (keyword == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(9);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
        super.keyword(keyword);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(10);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder symbol(@NotNull String symbol) {
        if (symbol == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(11);
        }
        if ("'".equals(symbol)) {
            boolean bl = this.myQuoteState = !this.myQuoteState;
            if (this.myQuoteState) {
                this.pushStyle(DefaultLanguageHighlighterColors.STRING);
            }
            super.symbol(symbol);
            if (!this.myQuoteState) {
                this.popStyle();
            }
            ColoredDdlBuilder coloredDdlBuilder = this;
            if (coloredDdlBuilder == null) {
                ColoredDdlBuilder.$$$reportNull$$$0(12);
            }
            return coloredDdlBuilder;
        }
        TextAttributesKey key2 = switch (symbol) {
            case "." -> DefaultLanguageHighlighterColors.DOT;
            case "," -> DefaultLanguageHighlighterColors.COMMA;
            case "(", ")" -> DefaultLanguageHighlighterColors.PARENTHESES;
            case ";" -> DefaultLanguageHighlighterColors.SEMICOLON;
            default -> null;
        };
        this.pushStyle(key2);
        super.symbol(symbol);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(13);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder comment(@NotNull String s) {
        if (s == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(14);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.LINE_COMMENT);
        super.comment(s);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(15);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder type(@NotNull String type) {
        if (type == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(16);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
        super.type(type);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(17);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder type(@NotNull DasTypedObject typedInfo) {
        if (typedInfo == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(18);
        }
        this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
        super.type(typedInfo);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(19);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder literal(@NotNull String literal) {
        if (literal == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(20);
        }
        TextAttributesKey key2 = literal.indexOf(39) > -1 || literal.indexOf(34) > -1 ? DefaultLanguageHighlighterColors.STRING : DefaultLanguageHighlighterColors.NUMBER;
        this.pushStyle(key2);
        super.literal(literal);
        ColoredDdlBuilder coloredDdlBuilder = this.popStyle();
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(21);
        }
        return coloredDdlBuilder;
    }

    @Override
    @NotNull
    public ColoredDdlBuilder ref(@Nullable DasObject object, String name2) {
        ColoredDdlBuilder coloredDdlBuilder = (ColoredDdlBuilder)super.ref(object, name2);
        if (coloredDdlBuilder == null) {
            ColoredDdlBuilder.$$$reportNull$$$0(22);
        }
        return coloredDdlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 7, 9, 11, 14, 16, 18, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ColoredDdlBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pushStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "popStyle";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ColoredDdlBuilder";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "plain";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "keyword";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "symbol";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "comment";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "literal";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "plain";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "keyword";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "symbol";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "comment";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "literal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 7, 9, 11, 14, 16, 18, 20 -> new IllegalArgumentException(string);
        };
    }
}

